<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Category_Box_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-category-box';
    }

    public function get_title() {
        return esc_html__('Category Box', 'syron');
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }



    protected function register_controls() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label'              => esc_html__( 'Columns', 'syron' ),
                'type'               => Controls_Manager::SELECT,
                'default'            => '4',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-categories-box' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
                ],
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label'     => esc_html__( 'Column Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '30',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-categories-box' => 'column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'     => esc_html__( 'Row Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '30',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-categories-box' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hide_last_item_on_tablet',
            [
                'label'     => esc_html__( 'Hide Last Item On Tablet', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'selectors' => [
                    'body[data-elementor-device-mode="tablet"] {{WRAPPER}} .cat-item:last-of-type' => 'display: none;',
                ],
            ]
        );

        $this->add_control(
            'hide_last_item_on_mobile',
            [
                'label'     => esc_html__( 'Hide Last Item On Mobile', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'selectors' => [
                    'body[data-elementor-device-mode="mobile"] {{WRAPPER}} .cat-item:last-of-type' => 'display: none;',
                ],
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'section_categories',
            [
                'label' => esc_html__( 'Categories', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $categories_list = get_terms(['taxonomy' => 'category', 'fields' => 'id=>name']);


        $repeater = new Repeater();

        $repeater->add_control(
            'category',
            [
                'label'         => esc_html__( 'Category', 'syron' ),
                'type'          => Controls_Manager::SELECT,
                'options'       => $categories_list,

            ]
        );

        $repeater->add_control(
            'category_image',
            [
                'label' => esc_html__( 'Image', 'syron' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );


        $this->add_control(
            'category_items',
            [
                'label' => esc_html__( 'Category Items', 'syron' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
				'prevent_empty' => false,
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__( 'Settings', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'open_link_new_tab',
            [
                'label'     => esc_html__( 'Open Link In New Tab', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'image_animation',
            [
                'label'     => esc_html__( 'Image Animation', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

	    $this->add_control(
		    'category_layout',
		    [
			    'label'   => esc_html__( 'Layout', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'simple-layout',
			    'options' => [
				    'card-layout'             => esc_html__( 'Card Layout', 'syron' ),
				    'simple-layout'           => esc_html__( 'Simple Layout', 'syron' ),
			    ],
		    ]
	    );

	    $this->add_group_control(
		    Group_Control_Image_Size::get_type(),
		    [
			    'name' => 'thumbnail',
			    'exclude' => ['custom'],
			    'default' => 'rivax-small-square',
		    ]
	    );

	    $this->add_responsive_control(
		    'image_height',
		    [
			    'label'     => esc_html__( 'Image Height', 'syron' ),
			    'type'      => Controls_Manager::SLIDER,
			    'size_units'=> [ 'px', '%' ],
			    'range'     => [
				    'px' => [
					    'min' => 50,
					    'max' => 400,
				    ],
				    '%' => [
					    'min' => 30,
					    'max' => 150,
				    ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .image-wrapper::before' => 'padding-top: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

        $this->add_responsive_control(
            'image_width',
            [
                'label'     => esc_html__( 'Image Width', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'range'     => [
                    'px' => [
                        'min' => 50,
                        'max' => 200,
                    ],
                ],
                'condition' => [
                    'content_position' => 'beside'
                ]
            ]
        );


	    $this->add_control(
		    'content_position',
		    [
			    'label'   => esc_html__( 'Content Position', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'below',
			    'options' => [
				    'below'             => esc_html__( 'Below', 'syron' ),
				    'inside'            => esc_html__( 'Inside', 'syron' ),
				    'beside'            => esc_html__( 'Beside', 'syron' ),
			    ],
			    'render_type'    => 'template',
			    'prefix_class' => 'content-position-',
		    ]
	    );

	    $this->add_control(
		    'content_align',
		    [
			    'label' => esc_html__( 'Alignment', 'syron' ),
			    'type' => Controls_Manager::CHOOSE,
			    'options' => [
				    'left' => [
					    'title' => esc_html__( 'Left', 'syron' ),
					    'icon' => 'eicon-text-align-left',
				    ],
				    'center' => [
					    'title' => esc_html__( 'Center', 'syron' ),
					    'icon' => 'eicon-text-align-center',
				    ],
				    'right' => [
					    'title' => esc_html__( 'Right', 'syron' ),
					    'icon' => 'eicon-text-align-right',
				    ]
			    ],
			    'default' => 'left',
			    'selectors' => [
				    '{{WRAPPER}} .content-wrapper' => 'text-align: {{VALUE}};'
			    ]
		    ]
	    );


        $this->add_control(
            'show_count',
            [
                'label'     => esc_html__( 'Show Posts Count', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'category_count_text',
            [
                'label'     => esc_html__( 'Count Text', 'syron' ),
                'type'      => Controls_Manager::TEXT,
                'default' => esc_html__( ' Posts' , 'syron' ),
                'condition' => [
                    'show_count' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();



	    $this->start_controls_section('section_style_cat_item',
		    [
			    'label' => esc_html__('Category Item', 'syron'),
			    'tab' => Controls_Manager::TAB_STYLE,
		    ]);

	    $this->add_responsive_control('cat_item_padding',
		    [
			    'label' => esc_html__('Padding', 'syron'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'selectors' => [
				    '{{WRAPPER}} .cat-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]);

	    $this->add_responsive_control('cat_item_border_radius',
		    [
			    'label' => esc_html__('Border Radius', 'syron'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'selectors' => [
				    '{{WRAPPER}} .cat-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]);



	    $this->start_controls_tabs('tabs_cat_item_style');

	    $this->start_controls_tab('tab_cat_item_normal',
		    [
			    'label' => esc_html__('Normal', 'syron'),
		    ]);

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'cat_item_background',
			    'exclude' => [ 'image' ],
			    'selector' => '{{WRAPPER}} .cat-item',
		    ]
	    );

        $this->add_control(
            'heading_cat_item_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'cat_item_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .cat-item',
            ]
        );


	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'cat_item_border',
			    'selector' => '{{WRAPPER}} .cat-item',
		    ]);

        $this->add_control('cat_item_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'cat_item_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .cat-item' => 'border-color: {{VALUE}};',
                ],
            ]);


	    $this->add_group_control(Group_Control_Box_Shadow::get_type(),
		    [
			    'name' => 'cat_item_box_shadow',
			    'selector' => '{{WRAPPER}} .cat-item',
		    ]);

	    $this->end_controls_tab();

	    $this->start_controls_tab('tab_cat_item_hover',
		    [
			    'label' => esc_html__('Hover', 'syron'),
		    ]);

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'cat_item_hover_background',
			    'exclude' => [ 'image' ],
			    'selector' => '{{WRAPPER}} .cat-item:hover',
		    ]
	    );

        $this->add_control(
            'heading_cat_item_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'cat_item_hover_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .cat-item:hover',
            ]
        );


	    $this->add_control('cat_item_hover_border_color',
		    [
			    'label' => esc_html__('Border Color', 'syron'),
			    'type' => Controls_Manager::COLOR,
			    'condition' => [
				    'cat_item_border_border!' => '',
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .cat-item:hover' => 'border-color: {{VALUE}};',
			    ],
		    ]);

        $this->add_control('cat_item_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'cat_item_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .cat-item:hover' => 'border-color: {{VALUE}};',
                ],
            ]);


	    $this->add_group_control(Group_Control_Box_Shadow::get_type(),
		    [
			    'name' => 'cat_item_hover_box_shadow',
			    'selector' => '{{WRAPPER}} .cat-item:hover',
		    ]);


	    $this->end_controls_tab();
	    $this->end_controls_tabs();

	    $this->end_controls_section();



	    $this->start_controls_section('section_style_image',
		    [
			    'label' => esc_html__('Image', 'syron'),
			    'tab' => Controls_Manager::TAB_STYLE,
		    ]
	    );

	    $this->start_controls_tabs('tabs_image_style');

	    $this->start_controls_tab('tab_image_normal',
		    [
			    'label' => esc_html__('Normal', 'syron'),
		    ]);

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'image_overlay_color',
			    'label' => esc_html__('Overlay Color', 'syron'),
			    'exclude' => [ 'image' ],
			    'selector' => '{{WRAPPER}} .image-wrapper::after',
		    ]
	    );

	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'image_border',
			    'selector' => '{{WRAPPER}} .image-wrapper',
		    ]);

	    $this->add_responsive_control('image_border_radius',
		    [
			    'label' => esc_html__('Border Radius', 'syron'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'selectors' => [
				    '{{WRAPPER}} .image-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]);

	    $this->add_group_control(Group_Control_Box_Shadow::get_type(),
		    [
			    'name' => 'image_box_shadow',
			    'selector' => '{{WRAPPER}} .image-wrapper',
		    ]);

	    $this->end_controls_tab();

	    $this->start_controls_tab('tab_image_hover',
		    [
			    'label' => esc_html__('Hover', 'syron'),
		    ]);

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'image_overlay_hover_color',
			    'label' => esc_html__('Overlay Color', 'syron'),
			    'exclude' => [ 'image' ],
			    'selector' => '{{WRAPPER}} .image-wrapper:hover::after',
		    ]
	    );

	    $this->add_control('image_hover_border_color',
		    [
			    'label' => esc_html__('Border Color', 'syron'),
			    'type' => Controls_Manager::COLOR,
			    'condition' => [
				    'image_border_border!' => '',
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .image-wrapper:hover' => 'border-color: {{VALUE}};',
			    ],
		    ]);

	    $this->add_group_control(
		    Group_Control_Box_Shadow::get_type(),
		    [
			    'name' => 'image_hover_box_shadow',
			    'selector' => '{{WRAPPER}} .image-wrapper:hover',
		    ]);

	    $this->end_controls_tab();
	    $this->end_controls_tabs();

	    $this->end_controls_section();


        $this->start_controls_section('section_style_title',
            [
                'label' => esc_html__('Title', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);

        $this->add_responsive_control('title_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .title a',
            ]);


        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $this->add_control('title_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title a' => '--body-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .title a' => '--body-color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'syron' ),
            ]
        );

        $this->add_control('title_hover_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title a:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_hover_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .title a:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();



        $this->start_controls_section('section_style_count',
            [
                'label' => esc_html__('Count', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_count' => 'yes'
                ]
            ]);


        $this->add_control('count_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .count' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('count_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .count' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'count_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .count',
            ]);

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}