<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Dark_Mode_Switcher_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-dark-mode-switcher';
    }

    public function get_title() {
        return esc_html__('Dark Mode Switcher', 'syron');
    }

    public function get_icon() {
        return 'eicon-dark-mode';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__( 'General', 'syron' ),
            ]
        );

        $this->end_controls_section();



        $this->start_controls_section(
            'section_style_general',
            [
                'label' => esc_html__( 'General', 'syron' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}