<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Gradient_Line_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-gradient-line';
    }

    public function get_title() {
        return esc_html__('Gradient Line', 'syron');
    }

    public function get_icon() {
        return 'eicon-global-colors';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__( 'General', 'syron' ),
            ]
        );

        $this->add_control(
            'colors_number',
            [
                'label'              => esc_html__( 'Colors Number', 'syron' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                ],
                'default'   => '2',
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label' => esc_html__( 'Height', 'syron' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-gradient-line' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'blur',
            [
                'label' => esc_html__( 'Blur', 'syron' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 150,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-gradient-line' => 'filter: blur({{SIZE}}{{UNIT}});',
                ],
            ]
        );

        $this->add_control(
            'opacity',
            [
                'label'     => esc_html__( 'Opacity', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-gradient-line' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-gradient-line' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'color_01',
            [
                'label' => esc_html__('Color 1', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-gradient-line' => '--color-01: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'color_02',
            [
                'label' => esc_html__('Color 2', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-gradient-line' => '--color-02: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'color_03',
            [
                'label' => esc_html__('Color 3', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-gradient-line' => '--color-03: {{VALUE}};',
                ],
                'condition' => [
                    'colors_number' => ['3', '4', '5'],
                ],
            ]
        );

        $this->add_control(
            'color_04',
            [
                'label' => esc_html__('Color 4', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-gradient-line' => '--color-04: {{VALUE}};',
                ],
                'condition' => [
                    'colors_number' => ['4', '5'],
                ],
            ]
        );

        $this->add_control(
            'color_05',
            [
                'label' => esc_html__('Color 5', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-gradient-line' => '--color-05: {{VALUE}};',
                ],
                'condition' => [
                    'colors_number' => ['5'],
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}