<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Image_Morphing_Widget extends Widget_Base {


    public function get_name() {
        return 'rivax-image-morphing';
    }

    public function get_title() {
        return esc_html__('Image Morphing', 'syron');
    }

    public function get_icon() {
        return 'eicon-svg';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }


    protected function register_controls() {

        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__( 'Settings', 'syron' ),
            ]
        );

        $this->add_control(
            'animation_style',
            [
                'label'     => esc_html__( 'Animation Style', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'style-1'  => esc_html__( 'Style 1', 'syron' ),
                    'style-2'  => esc_html__( 'Style 2', 'syron' ),
                    'style-3'  => esc_html__( 'Style 3', 'syron' ),
                    'style-4'  => esc_html__( 'Style 4', 'syron' ),
                    'style-5'  => esc_html__( 'Style 5', 'syron' ),
                    'style-6'  => esc_html__( 'Style 6', 'syron' ),
                    'style-7'  => esc_html__( 'Style 7', 'syron' ),
                    'style-8'  => esc_html__( 'Style 8', 'syron' ),
                ],
                'default'   => 'style-1',
            ]
        );

        $this->add_control(
            'content_type',
            [
                'label'     => esc_html__( 'Content Type', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'image'  => esc_html__( 'Image', 'syron' ),
                    'color' => esc_html__( 'Color', 'syron' ),
                ],
                'default'   => 'color',
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__( 'Image', 'syron' ),
                'type' => Controls_Manager::MEDIA,
                'condition' => [
                    'content_type' => 'image',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'exclude' => ['custom'],
                'default' => 'full',
                'condition' => [
                    'content_type' => 'image',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'morphing_bg',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .image-morphing-content',
                'condition' => [
                    'content_type' => 'color',
                ],
            ]
        );

        $this->add_control(
            'heading_morphing_bg_dark_mode',
            [
                'label'     => esc_html__( 'Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'condition' => [
                    'content_type' => 'color',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'morphing_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .image-morphing-content',
                'condition' => [
                    'content_type' => 'color',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section('section_style_morphing',
            [
                'label' => esc_html__('Morphing', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'max_width',
            [
                'label'     => esc_html__( 'Max Width', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units'=> [ 'px', '%' ],
                'range'     => [
                    'px' => [
                        'min' => 50,
                        'max' => 800,
                    ],
                    '%' => [
                        'min' => 50,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-morphing' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label'     => esc_html__( 'Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units'=> [ 'px', '%' ],
                'range'     => [
                    'px' => [
                        'min' => 50,
                        'max' => 500,
                    ],
                    '%' => [
                        'min' => 50,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-morphing-content::before' => 'padding-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'morphing_border',
                'selector' => '{{WRAPPER}} .image-morphing',
            ]);

        $this->add_control('morphing_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'morphing_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .image-morphing' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'morphing_box_shadow',
                'selector' => '{{WRAPPER}} .image-morphing',
            ]);

        $this->add_control(
            'morphing_blur',
            [
                'label'     => esc_html__( 'Filter Blur', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-morphing' => 'filter: blur({{SIZE}}{{UNIT}});',
                ],
            ]
        );

        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}