<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Instagram_Widget extends Widget_Base {


    public function get_name() {
        return 'rivax-instagram';
    }

    public function get_title() {
        return esc_html__('Instagram', 'syron');
    }

    public function get_icon() {
        return 'eicon-instagram-gallery';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }


    protected function register_controls() {

        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__( 'Settings', 'syron' ),
            ]
        );

        $this->add_control(
            'profile_image',
            [
                'label' => esc_html__( 'Profile Image', 'syron' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'username',
            [
                'label'       => esc_html__( 'Username', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'default'   => 'RivaxStudio',
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'       => esc_html__( 'Button Text', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Follow Me', 'syron' ),
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label' => esc_html__( 'Button Icon', 'syron' ),
                'type' => Controls_Manager::ICONS,
                'skin' => 'inline',
                'label_block' => false,
            ]
        );
		
		$this->add_control(
            'link',
            [
                'label'       => esc_html__( 'Link', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => 'https://www.instagram.com/rivaxStudio',
            ]
        );

        $this->add_control(
            'tagline',
            [
                'label'       => esc_html__( 'Tagline', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'We become what we think about!', 'syron' ),
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'     => esc_html__( 'Layout', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    '1'  => esc_html__( 'Layout 1', 'syron' ),
                    '2'  => esc_html__( 'Layout 2', 'syron' ),
                    '3'  => esc_html__( 'Layout 3', 'syron' ),
                    '4'  => esc_html__( 'Layout 4', 'syron' ),
                ],
                'default'   => '1',
            ]
        );

        $this->add_control(
            'show_profile_image',
            [
                'label'     => esc_html__( 'Show Profile Image', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
            ]
        );

        $this->add_control(
            'show_username',
            [
                'label'     => esc_html__( 'Show Username', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
            ]
        );

        $this->add_control(
            'show_tagline',
            [
                'label'     => esc_html__( 'Show Tagline', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
            ]
        );

        $this->add_control(
            'show_button',
            [
                'label'     => esc_html__( 'Show Button', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
            ]
        );



        $this->end_controls_section();




        $this->start_controls_section(
            'section_images',
            [
                'label' => esc_html__( 'Images', 'syron' ),
            ]
        );

        $this->add_control(
            'images_layout',
            [
                'label'     => esc_html__( 'Images Layout', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    '1'  => esc_html__( 'Layout 1', 'syron' ),
                    '2'  => esc_html__( 'Layout 2', 'syron' ),
                    '3'  => esc_html__( 'Layout 3', 'syron' ),
                    '4'  => esc_html__( 'Layout 4', 'syron' ),
                    '5'  => esc_html__( 'Layout 5', 'syron' ),
                    'marquee-left'  => esc_html__( 'Marquee Left', 'syron' ),
                    'marquee-right'  => esc_html__( 'Marquee Right', 'syron' ),
                ],
                'default'   => '1',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label'              => esc_html__( 'Columns', 'syron' ),
                'type'               => Controls_Manager::SELECT,
                'default'            => '6',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7',
                    '8' => '8',
                    '9' => '9',
                    '10' => '10',
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-images' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
                ],
                'condition' => [
                    'images_layout!' => ['marquee-left', 'marquee-right'],
                ],
            ]
        );

        $this->add_control(
            'image_animation',
            [
                'label'     => esc_html__( 'Image Animation', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'marquee_pauseonhover',
            [
                'label' => esc_html__( 'Pause on Hover', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [
                    'images_layout' => ['marquee-left', 'marquee-right'],
                ],
            ]
        );

        $this->add_control(
            'marquee_swing',
            [
                'label' => esc_html__( 'Swing', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
                'condition' => [
                    'images_layout' => ['marquee-left', 'marquee-right'],
                ],
            ]
        );

        $this->add_responsive_control(
            'marquee_height',
            [
                'label'     => esc_html__( 'Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'vw' ],
                'range'     => [
                    'px' => [
                        'min' => 50,
                        'max' => 500,
                    ],
                    'vw' => [
                        'min' => 5,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .insta-item' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'images_layout' => ['marquee-left', 'marquee-right'],
                ],
            ]
        );

        $this->add_responsive_control(
            'marquee_time',
            [
                'label'     => esc_html__( 'Duration(s)', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .marquee-wrap' => '--marquee-time: {{SIZE}}s;',
                ],
                'condition' => [
                    'images_layout' => ['marquee-left', 'marquee-right'],
                ],
            ]
        );

        $this->add_responsive_control(
            'images_gap',
            [
                'label'     => esc_html__( 'Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-images' => '--gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'max_rows',
            [
                'label'              => esc_html__( 'Maximum Rows', 'syron' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'none' => esc_html__( 'None', 'syron' ),
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                ],
                'selectors_dictionary' => [
                    'none' => '',
                    '1' => 'grid-auto-rows: 0;grid-template-rows: repeat(1, 1fr);',
                    '2' => 'grid-auto-rows: 0;grid-template-rows: repeat(2, 1fr);',
                    '3' => 'grid-auto-rows: 0;grid-template-rows: repeat(3, 1fr);',
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-images' => '{{VALUE}}'
                ],
                'condition' => [
                    'images_layout!' => ['marquee-left', 'marquee-right'],
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'exclude' => ['custom'],
                'default' => 'rivax-small-square',
            ]);

        $this->add_control(
            'images',
            [
                'label' => esc_html__( 'Add Images', 'syron' ),
                'type' => Controls_Manager::GALLERY,
            ]
        );

        $this->end_controls_section();




        $this->start_controls_section('section_style_header',
            [
                'label' => esc_html__('Header', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'header_gap',
            [
                'label'     => esc_html__( 'Header & Images Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-wrapper' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'heading_style_profile_image',
            [
                'label'     => esc_html__( 'Profile Image', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'profile_image_size',
            [
                'label'     => esc_html__( 'Image Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 50,
                        'max' => 150,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-profile-img img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'profile_image_margin',
            [
                'label' => esc_html__( 'Margin', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-profile-img img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'profile_image_border',
                'selector' => '{{WRAPPER}} .rivax-insta-profile-img img',
            ]);
			
			$this->add_control('profile_image_border_color_dark_mode',
		    [
			    'label' => esc_html__('Border Color - Dark Mode', 'syron'),
			    'type' => Controls_Manager::COLOR,
			    'condition' => [
				    'profile_image_border_border!' => '',
			    ],
			    'selectors' => [
				    'html[scheme="dark"] {{WRAPPER}} .rivax-insta-profile-img img' => 'border-color: {{VALUE}};',
			    ],
		    ]);

        $this->add_control('profile_image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-profile-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'profile_image_box_shadow',
                'selector' => '{{WRAPPER}} .rivax-insta-profile-img img',
            ]);


        $this->add_control(
            'heading_style_username',
            [
                'label'     => esc_html__( 'Username', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control('username_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-info .username' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'username_typography',
                'selector' => '{{WRAPPER}} .rivax-insta-info .username',
            ]
        );


        $this->add_control(
            'heading_style_tagline',
            [
                'label'     => esc_html__( 'Tagline', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control('tagline_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-info .tagline' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tagline_typography',
                'selector' => '{{WRAPPER}} .rivax-insta-info .tagline',
            ]
        );

        $this->end_controls_section();



        $this->start_controls_section('section_style_button',
            [
                'label' => esc_html__('Button', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button_margin',
            [
                'label' => esc_html__( 'Margin', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label' => esc_html__( 'Padding', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_control(
            'button_icon_spacing',
            [
                'label'     => esc_html__( 'Icon Spacing', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-btn' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_icon_size',
            [
                'label'     => esc_html__( 'Icon Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-btn .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .rivax-insta-btn',
            ]
        );


        $this->start_controls_tabs('tabs_button_style');

        $this->start_controls_tab('tab_button_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control('button_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-btn' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('button_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-insta-btn' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button_bg',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .rivax-insta-btn',
            ]
        );

        $this->add_control(
            'heading_button_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .rivax-insta-btn',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .rivax-insta-btn',
            ]);

        $this->add_control('button_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-insta-btn' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .rivax-insta-btn',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_button_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_control('button_hover_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-btn:hover' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('button_hover_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-insta-btn:hover' => 'color: {{VALUE}};',
                ],
            ]);






        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button_hover_bg',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .rivax-insta-btn:hover',
            ]
        );

        $this->add_control(
            'heading_button_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button_hover_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .rivax-insta-btn:hover',
            ]
        );

        $this->add_control('button_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-insta-btn:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('button_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'button_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-insta-btn:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_hover_box_shadow',
                'selector' => '{{WRAPPER}} .rivax-insta-btn:hover',
            ]);


        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();



        $this->start_controls_section('section_style_images',
            [
                'label' => esc_html__('Images', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tabs_image_style');

        $this->start_controls_tab('tab_image_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control('image_overlay',
            [
                'label' => esc_html__('Overlay', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .insta-item .item-img::before' => 'background: {{VALUE}};',
                ],
            ]);


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'selector' => '{{WRAPPER}} .insta-item',
            ]);

        $this->add_control('image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .insta-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'selector' => '{{WRAPPER}} .insta-item',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_image_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_control(
            'image_hover_shape',
            [
                'label'     => esc_html__( 'Hover Shape', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control('image_hover_overlay',
            [
                'label' => esc_html__('Overlay', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .insta-item .item-img:hover::before' => 'background: {{VALUE}};',
                ],
            ]);

        $this->add_control('image_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'image_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .insta-item:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('image_hover_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .insta-item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_hover_box_shadow',
                'selector' => '{{WRAPPER}} .insta-item:hover',
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();



        $this->end_controls_section();

    }



    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}