<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Marquee_Headings_Widget extends Widget_Base {


    public function get_name() {
        return 'rivax-marquee-headings';
    }

    public function get_title() {
        return esc_html__('Marquee Headings', 'syron');
    }

    public function get_icon() {
        return 'eicon-t-letter';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }


    protected function register_controls() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', 'syron' ),
            ]
        );

        $this->add_control(
            'direction',
            [
                'label'     => esc_html__( 'Direction', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'left'  => esc_html__( 'Left', 'syron' ),
                    'right' => esc_html__( 'Right', 'syron' ),
                ],
                'default'   => 'left',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'     => esc_html__( 'HTML Tag', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'h5',
                'options'   => rivax_get_title_tags(),
            ]
        );

        $this->add_responsive_control(
            'gap',
            [
                'label'     => esc_html__( 'Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-marquee-headings' => '--gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'time',
            [
                'label'     => esc_html__( 'Duration(s)', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-marquee-headings' => '--marquee-time: {{SIZE}}s;',
                ],
            ]
        );

        $this->add_control(
            'pauseonhover',
            [
                'label' => esc_html__( 'Pause on Hover', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
		
		$this->add_control(
            'side_fading',
            [
                'label' => esc_html__( 'Side Fading', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'icon_top',
            [
                'label' => esc_html__( 'Icon Top', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}} .heading-wrap' => 'flex-direction: column;',
                ],
            ]
        );

        $this->end_controls_section();



        $this->start_controls_section(
            'section_items',
            [
                'label' => esc_html__( 'Items', 'syron' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'syron' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control('item_title_color',
            [
                'label' => esc_html__('Title Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .heading-wrap' => 'color: {{VALUE}};',
                ],
            ]);

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'syron' ),
                'type' => Controls_Manager::ICONS,
                'skin' => 'inline',
                'label_block' => false,
                'separator' => 'before',
            ]
        );

        $repeater->add_control('item_icon_bg',
            [
                'label' => esc_html__('Icon Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .icon' => 'background: {{VALUE}};',
                ],
            ]);

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Items', 'syron' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'prevent_empty' => false,
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section('section_style_item',
            [
                'label' => esc_html__('Item', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .heading-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control('item_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .heading-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->start_controls_tabs('tabs_item_style');
        $this->start_controls_tab('tab_item_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control('item_bg',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading-item' => 'background: {{VALUE}};',
                ],
            ]);
			
		$this->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'item_border',
			'selector' => '{{WRAPPER}} .heading-item',
		]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_item_dark_mode',
            [
                'label' => esc_html__('Dark Mode', 'syron'),
            ]);

        $this->add_control('item_bg_dark_mode',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .heading-item' => 'background: {{VALUE}};',
                ],
            ]);
			
		$this->add_control('item_border_color_dark_mode',
		[
			'label' => esc_html__('Border Color', 'syron'),
			'type' => Controls_Manager::COLOR,
			'condition' => [
				'item_border_border!' => '',
			],
			'selectors' => [
				'html[scheme="dark"] {{WRAPPER}} .heading-item' => 'border-color: {{VALUE}};',
			],
		]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section('section_style_title',
            [
                'label' => esc_html__('Title', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'		 => 'title_typography',
                'selector'	 => '{{WRAPPER}} .heading-wrap',
            ]
        );
		
		$this->add_group_control(
            Group_Control_Text_Stroke::get_type(),
            [
                'name' => 'title_stroke',
                'selector' => '{{WRAPPER}} .heading-wrap',
            ]
        );

        $this->add_control('title_stroke_color_dark_mode',
            [
                'label' => esc_html__('Stroke Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .heading-wrap' => '-webkit-text-stroke-color: {{VALUE}}; stroke: {{VALUE}};',
                ],
                'condition' => [
                    'title_stroke_text_stroke_type!' => '',
                ],
            ]);

        $this->add_control(
            'title_gradient',
            [
                'label'     => esc_html__( 'Gradient Color', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
            ]
        );

        $this->start_controls_tabs('tabs_title_style');
        $this->start_controls_tab('tab_title_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control('title_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading-wrap' => 'color: {{VALUE}};',
                ],
                'condition'	=> [
                    'title_gradient' => '',
                ],
            ]);

        $this->add_control(
            'title_gradient_01',
            [
                'label' => esc_html__('Color One', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'title_gradient' => 'yes',
                ],

            ]
        );

        $this->add_control(
            'title_gradient_02',
            [
                'label' => esc_html__('Color Two', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'title_gradient' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_gradient_03',
            [
                'label' => esc_html__('Color Three', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'title_gradient' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .gradient-heading' => 'background-image: linear-gradient(90deg, {{title_gradient_01.VALUE}} 0%, {{title_gradient_02.VALUE}} 50%, {{title_gradient_03.VALUE}} 100%)',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('tab_title_dark_mode',
            [
                'label' => esc_html__('Dark Mode', 'syron'),
            ]);

        $this->add_control('title_color_dark_mode',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .heading-wrap' => 'color: {{VALUE}};',
                ],
                'condition'	=> [
                    'title_gradient' => '',
                ],
            ]);

        $this->add_control(
            'title_gradient_01_dark_mode',
            [
                'label' => esc_html__('Color One', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'title_gradient' => 'yes',
                ],

            ]
        );

        $this->add_control(
            'title_gradient_02_dark_mode',
            [
                'label' => esc_html__('Color Two', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'title_gradient' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_gradient_03_dark_mode',
            [
                'label' => esc_html__('Color Three', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition'	=> [
                    'title_gradient' => 'yes',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .gradient-heading' => 'background-image: linear-gradient(90deg, {{title_gradient_01.VALUE}} 0%, {{title_gradient_02.VALUE}} 50%, {{title_gradient_03.VALUE}} 100%)',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section('section_style_icon',
            [
                'label' => esc_html__('Icon', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_gap',
            [
                'label'     => esc_html__( 'Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .heading-wrap' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label'     => esc_html__( 'Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control('icon_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'label' => esc_html__('Box Shadow', 'syron'),
                'name' => 'icon_box_shadow',
                'selector' => '{{WRAPPER}} .icon',
            ]);

        $this->start_controls_tabs('tabs_icon_style');
        $this->start_controls_tab('tab_icon_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control('icon_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('icon_bg',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'background: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_icon_dark_mode',
            [
                'label' => esc_html__('Dark Mode', 'syron'),
            ]);

        $this->add_control('icon_color_dark_mode',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .icon' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('icon_bg_dark_mode',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .icon' => 'background: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }



    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}