<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Navigation_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-navigation';
    }

    public function get_title() {
        return esc_html__('Navigation', 'syron');
    }

    public function get_icon() {
        return 'eicon-nav-menu';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }

    /**
     * Get all registered menus.
     *
     * @return array of menus.
     */
    private function get_menus()
    {
        $menus   = wp_get_nav_menus();
        $options = [];

        if (empty($menus)) {
            return $options;
        }

        foreach ($menus as $menu) {
            $options[$menu->term_id] = $menu->name;
        }

        return $options;
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('settings', 'syron'),
            ]
        );

        $menus = $this->get_menus();

        if ($menus) {
            $this->add_control(
                'menu',
                [
                    'label'       => esc_html__('Select Menu', 'syron'),
                    'description' => sprintf(esc_html__('Go to the %s Menu screen %s to manage your menus.', 'syron'), '<a href="' . admin_url('nav-menus.php') . '" target="_blank">', '</a>'),
                    'type'        => Controls_Manager::SELECT,
                    'label_block' => false,
                    'options'     => $menus,
                    'default'     => array_keys($menus)[0],
                ]
            );
        } else {
            $this->add_control(
                'menu_not_exist',
                [
                    'type'      => Controls_Manager::RAW_HTML,
                    'raw'       => sprintf(esc_html__('There are no menus in your site. Go to the %s Menu screen %s to create one.', 'syron'), '<a href="' . admin_url('nav-menus.php') . '" target="_blank">', '</a>'),
                ]
            );
        }

        $this->add_control(
            'menu_type',
            [
                'label' => esc_html__( 'Menu Type', 'syron' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'horizontal'  => esc_html__( 'Horizontal', 'syron' ),
                    'vertical' => esc_html__( 'Vertical', 'syron' ),
                ],
            ]
        );

        $this->add_control(
            'h_mega_menu_width',
            [
                'label' => esc_html__( 'Mega Menu Width', 'syron' ),
                'type' => Controls_Manager::SELECT,
                'condition' => ['menu_type' => 'horizontal'],
                'default' => 'boxed',
                'options' => [
                    'boxed'  => esc_html__( 'Boxed', 'syron' ),
                    'wide' => esc_html__( 'Wide', 'syron' ),
                ],
            ]
        );

        $this->add_responsive_control(
            'H_menu_align', [
                'label' => esc_html__('Alignment', 'syron'),
                'condition' => ['menu_type' => 'horizontal'],
                'type' => Controls_Manager::CHOOSE,
                'options' => [

                    'flex-start' => [
                        'title' => esc_html__('Start', 'syron'),
                        'icon' => 'eicon-justify-start-h',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'syron'),
                        'icon' => 'eicon-justify-center-h',
                    ],
                    'space-between' => [
                        'title' => esc_html__('Space Between', 'syron'),
                        'icon' => 'eicon-justify-space-between-h',
                    ],
                    'space-around' => [
                        'title' => esc_html__('Space Around', 'syron'),
                        'icon' => 'eicon-justify-space-around-h',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('End', 'syron'),
                        'icon' => 'eicon-justify-end-h',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'h_submenu_spacing',
            [
                'label'     => esc_html__( 'Submenu Spacing', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav > li.menu-item::before' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .rivax-header-nav > li.menu-item > .sub-menu' => 'top: calc(100% + {{SIZE}}{{UNIT}});',
                ],
                'condition' => ['menu_type' => 'horizontal'],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_top_level_style',
            [
                'label' => esc_html__('Top Level', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'menu_typography',
                'label' => esc_html__( 'Typography', 'syron' ),
                'selector' => '{{WRAPPER}} .rivax-header-nav > li.menu-item > a, {{WRAPPER}} .rivax-header-v-nav > li.menu-item > a',
            ]
        );

        $this->add_responsive_control(
            'h_menu_items_spacing',
            [
                'label'     => esc_html__( 'Spacing', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['menu_type' => 'horizontal'],
            ]
        );

        $this->start_controls_tabs('menu_color_tabs');
        # Normal State Tab
        $this->start_controls_tab(
            'menu_color_tab_normal_state',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]
        );

        $this->add_control(
            'menu_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav > li.menu-item > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .rivax-header-v-nav > li.menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'menu_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-nav > li.menu-item > a' => 'color: {{VALUE}}',
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-v-nav > li.menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        # Hover State Tab
        $this->start_controls_tab(
            'menu_color_tab_hover_state',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]
        );

        $this->add_control(
            'menu_color_hover',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav > li.menu-item > a:hover, {{WRAPPER}} .rivax-header-nav > li.current-menu-item > a, {{WRAPPER}} .rivax-header-nav > li.current-menu-ancestor > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .rivax-header-v-nav > li.menu-item > a:hover, {{WRAPPER}} .rivax-header-v-nav > li.current-menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'menu_color_hover_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-nav > li.menu-item > a:hover, html[scheme="dark"] {{WRAPPER}} .rivax-header-nav > li.current-menu-item > a, html[scheme="dark"] {{WRAPPER}} .rivax-header-nav > li.current-menu-ancestor > a' => 'color: {{VALUE}}',
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-v-nav > li.menu-item > a:hover, html[scheme="dark"] {{WRAPPER}} .rivax-header-v-nav > li.current-menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'h_menu_hover_shape',
            [
                'label' => esc_html__( 'Hover Shape', 'syron' ),
                'type' => Controls_Manager::SELECT,
                'condition' => ['menu_type' => 'horizontal'],
                'options' => [
                    'hover-default'  => esc_html__( 'Style Default', 'syron' ),
                    'hover-style-1'  => esc_html__( 'Style 1', 'syron' ),
                    'hover-style-2'  => esc_html__( 'Style 2', 'syron' ),
                    'hover-style-3'  => esc_html__( 'Style 3', 'syron' ),
                    'hover-style-4'  => esc_html__( 'Style 4', 'syron' ),
                    'hover-style-5'  => esc_html__( 'Style 5', 'syron' ),
                    'hover-style-6'  => esc_html__( 'Style 6', 'syron' ),
                    'hover-style-7'  => esc_html__( 'Style 7', 'syron' ),
                    'hover-style-8'  => esc_html__( 'Style 8', 'syron' ),
                ],
            ]
        );

        $this->add_control(
            'h_menu_hover_shape_radius',
            [
                'label'     => esc_html__( 'Radius', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav > li.menu-item > a::before' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['menu_type' => 'horizontal'],
            ]
        );

        $this->add_control(
            'h_menu_hover_shape_color',
            [
                'label' => esc_html__('Shape Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['menu_type' => 'horizontal'],
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav > li.menu-item > a' => '--menu-shape-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'h_menu_hover_shape_color_dark_mode',
            [
                'label' => esc_html__('Shape Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['menu_type' => 'horizontal'],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-nav > li.menu-item > a' => '--menu-shape-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();



        $this->start_controls_section(
            'section_submenu_style',
            [
                'label' => esc_html__('Submenu', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'submenu_typography',
                'label' => esc_html__( 'Typography', 'syron' ),
                'selector' => '{{WRAPPER}} .rivax-header-nav .sub-menu li.menu-item > a, {{WRAPPER}} .rivax-header-v-nav .sub-menu li.menu-item > a',
            ]
        );

        $this->add_control(
            'h_submenu_radius',
            [
                'label' => esc_html__( 'Border Radius', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => ['menu_type' => 'horizontal'],
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav .sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'h_submenu_box_shadow',
                'label' => esc_html__( 'Box Shadow', 'syron' ),
                'condition' => ['menu_type' => 'horizontal'],
                'selector' => '{{WRAPPER}} .rivax-header-nav .sub-menu',
            ]
        );

        $this->start_controls_tabs( 'tabs_h_submenu' );

        /**
         * Normal.
         */
        $this->start_controls_tab(
            'tab_h_submenu_normal',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'h_submenu_bg',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .rivax-header-nav .sub-menu',
                'condition' => ['menu_type' => 'horizontal'],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'h_submenu_border',
                'label' => esc_html__( 'Border', 'syron' ),
                'condition' => ['menu_type' => 'horizontal'],
                'selector' => '{{WRAPPER}} .rivax-header-nav .sub-menu',
            ]
        );

        $this->add_control(
            'submenu_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav .sub-menu li.menu-item > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .rivax-header-v-nav .sub-menu li.menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submenu_color_hover',
            [
                'label' => esc_html__('Color Hover', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-header-nav .sub-menu li.menu-item > a:hover, {{WRAPPER}} .rivax-header-nav .sub-menu li.current-menu-item > a, {{WRAPPER}} .rivax-header-nav .sub-menu li.current-menu-ancestor > a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .rivax-header-v-nav .sub-menu li.menu-item > a:hover, {{WRAPPER}} .rivax-header-v-nav .sub-menu li.current-menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        /**
         * Dark Mode.
         */
        $this->start_controls_tab(
            'tab_h_submenu_dark_mode',
            [
                'label' => esc_html__( 'Dark Mode', 'syron' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'h_submenu_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .rivax-header-nav .sub-menu',
                'condition' => ['menu_type' => 'horizontal'],
            ]
        );

        $this->add_control('h_submenu_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'h_submenu_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-nav .sub-menu' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control(
            'submenu_color_dark_mode',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-nav .sub-menu li.menu-item > a' => 'color: {{VALUE}}',
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-v-nav .sub-menu li.menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submenu_color_hover_dark_mode',
            [
                'label' => esc_html__('Color Hover', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-nav .sub-menu li.menu-item > a:hover, html[scheme="dark"] {{WRAPPER}} .rivax-header-nav .sub-menu li.current-menu-item > a, html[scheme="dark"] {{WRAPPER}} .rivax-header-nav .sub-menu li.current-menu-ancestor > a' => 'color: {{VALUE}}',
                    'html[scheme="dark"] {{WRAPPER}} .rivax-header-v-nav .sub-menu li.menu-item > a:hover, html[scheme="dark"] {{WRAPPER}} .rivax-header-v-nav .sub-menu li.current-menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }


}