<?php

namespace Elementor;

use RivaxStudio\Traits\Rivax_Group_Control_Query;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_News_Ticker_Widget extends Widget_Base {

    use Rivax_Group_Control_Query;

    public function get_name() {
        return 'rivax-news-ticker';
    }

    public function get_title() {
        return esc_html__('News Ticker', 'syron');
    }

    public function get_icon() {
        return 'eicon-posts-ticker rivax-e-icon';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }

	public function get_style_depends() {
		if (\Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode()) {
			return [];
		}
		
		if ( $this->get_settings_for_display( 'animation_type' ) != 'marquee' ) {
			return [ 'swiper', 'e-swiper' ];
		} else {
			return [];
		}
	}

    protected function register_settings_controls() {

        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__( 'Settings', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title_settings',
            [
                'label' => esc_html__( 'Title Settings', 'syron' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control('show_title', [
            'label' => esc_html__('Show Title', 'syron'),
            'type' => Controls_Manager::SWITCHER,
        ]);

        $this->add_control(
            'title',
            [
                'label'     => esc_html__( 'Title', 'syron' ),
                'type'      => Controls_Manager::TEXT,
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_position',
            [
                'label'     => esc_html__( 'Position', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    '0'   => [
                        'title' => esc_html__( 'Start', 'syron' ),
                        'icon'  => 'eicon-order-start',
                    ],
                    '3'  => [
                        'title' => esc_html__( 'End', 'syron' ),
                        'icon'  => 'eicon-order-end',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-wrapper' => 'order: {{VALUE}};',
                ],
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_icon_type',
            [
                'label'     => esc_html__( 'Icon Type', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'none'     => esc_html__( 'None', 'syron' ),
                    'pulse'  => esc_html__( 'Pulse', 'syron' ),
                    'icon' => esc_html__( 'Icon', 'syron' ),
                ],
                'default'   => 'none',
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_icon_position',
            [
                'label'     => esc_html__( 'Icon Position', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    '0'   => [
                        'title' => esc_html__( 'Start', 'syron' ),
                        'icon'  => 'eicon-order-start',
                    ],
                    '3'  => [
                        'title' => esc_html__( 'End', 'syron' ),
                        'icon'  => 'eicon-order-end',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-icon-wrapper' => 'order: {{VALUE}};',
                ],
                'condition' => [
                    'show_title' => 'yes',
                    'title_icon_type!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__( 'Icon', 'syron' ),
                'type' => Controls_Manager::ICONS,
                'condition' => [
                    'show_title' => 'yes',
                    'title_icon_type' => 'icon',
                ],
            ]
        );


        $this->add_control(
            'item_settings',
            [
                'label' => esc_html__( 'Item Settings', 'syron' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_control('open_link_new_tab', [
            'label' => esc_html__('Open Link New Tab', 'syron'),
            'type' => Controls_Manager::SWITCHER,
        ]);


        $this->add_control('show_item_icon', [
            'label' => esc_html__('Show icon', 'syron'),
            'type' => Controls_Manager::SWITCHER,
        ]);
		
		$this->add_control('hide_first_item_icon', [
            'label' => esc_html__('Hide For First Item', 'syron'),
            'type' => Controls_Manager::SWITCHER,
			'condition' => [
                    'show_item_icon' => 'yes',
            ],
			'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-item:first-of-type .item-icon' => 'display: none;',
            ],
        ]);

        $this->add_control(
            'item_icon',
            [
                'label' => esc_html__( 'Icon', 'syron' ),
                'type' => Controls_Manager::ICONS,
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]
        );

        $this->add_control('show_item_thumbnail', [
            'label' => esc_html__('Show Featured Image', 'syron'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'show_custom_content!' => 'yes',
            ],
        ]);

        $this->add_control('show_item_date', [
            'label' => esc_html__('Show date', 'syron'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'show_custom_content!' => 'yes',
            ],
        ]);

        $this->add_control(
            'date_format',
            [
                'label' => esc_html__( 'Date Format', 'syron' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'F j, Y',
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'date_format_info',
            [
                'type'      => Controls_Manager::RAW_HTML,
                'raw'       => sprintf(esc_html__('%s Date Format Documentation %s', 'syron'), '<a href="https://wordpress.org/documentation/article/customize-date-and-time-format/" target="_blank">', '</a>'),
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'animation_settings',
            [
                'label' => esc_html__( 'Animation Settings', 'syron' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'animation_type',
            [
                'label'     => esc_html__( 'Animation Type', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'marquee'     => esc_html__( 'Marquee', 'syron' ),
                    'type'  => esc_html__( 'Type', 'syron' ),
                    'fade' => esc_html__( 'Fade', 'syron' ),
                    'horizontal' => esc_html__( 'Horizontal Slide', 'syron' ),
                    'vertical' => esc_html__( 'Vertical Slide', 'syron' ),
                ],
                'default'   => 'marquee',
            ]
        );

        $this->add_responsive_control(
            'marquee_time',
            [
                'label'     => esc_html__( 'Duration(s)', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-items' => '--marquee-time: {{SIZE}}s;',
                ],
                'condition' => [
                    'animation_type' => 'marquee',
                ],
            ]
        );


        $this->add_responsive_control('marquee_items_gap',
            [
                'label' => esc_html__('Items Gap', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-items' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'animation_type' => 'marquee',
                ],
            ]);


        $this->add_responsive_control(
            'carousel_vertical_height',
            [
                'label'       => esc_html__( 'Container Height', 'syron' ),
                'type'        => Controls_Manager::SLIDER,
                'range'       => [
                    'px' => [
                        'min'  => 20,
                        'max'  => 600,
                        'step' => 5
                    ],
                ],
                'default'     => [
                    'size' => 20,
                ],
                'selectors'   => [
                    '{{WRAPPER}} .swiper' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition'   => [
                    'animation_type' => 'vertical',
                ],
            ]
        );

        $this->add_control(
            'carousel_autoplay',
            [
                'label'   => esc_html__( 'Autoplay', 'syron' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition'   => [
                    'animation_type!' => 'marquee',
                ],

            ]
        );

        $this->add_control(
            'carousel_autoplay_speed',
            [
                'label'     => esc_html__( 'Autoplay Speed', 'syron' ),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 5000,
                'step' => 100,
                'condition' => [
                    'animation_type!' => 'marquee',
                    'carousel_autoplay' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'pauseonhover',
            [
                'label' => esc_html__( 'Pause on Hover', 'syron' ),
                'type'  => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'carousel_speed',
            [
                'label'   => esc_html__( 'Animation Speed (ms)', 'syron' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 500,
                'min'  => 100,
                'max'  => 5000,
                'step' => 100,
                'condition'   => [
                    'animation_type!' => ['marquee', 'type'],
                ],
            ]
        );

        $this->add_control(
            'typing_speed',
            [
                'label'   => esc_html__( 'Typing Speed', 'syron' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 3000,
                'min'  => 500,
                'max'  => 10000,
                'step' => 100,
                'selectors'   => [
                    '{{WRAPPER}} .rivax-news-ticker-wrapper' => '--typing-speed: {{SIZE}}ms;',
                ],
                'condition'   => [
                    'animation_type' => 'type',
                ],
            ]
        );


        $this->add_control(
            'side_fading',
            [
                'label'     => esc_html__( 'Side Fading', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'none'     => esc_html__( 'None', 'syron' ),
                    'left'     => esc_html__( 'Left', 'syron' ),
                    'right'     => esc_html__( 'Right', 'syron' ),
                    'both'     => esc_html__( 'Both', 'syron' ),
                ],
                'default'   => 'none',
                'separator' => 'before',
            ]
        );


        $this->add_control(
            'arrows_settings',
            [
                'label' => esc_html__( 'Arrows Settings', 'syron' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition'   => [
                    'animation_type!' => 'marquee',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows',
            [
                'label'     => esc_html__( 'Arrows', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition'   => [
                    'animation_type!' => 'marquee',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_icon',
            [
                'label'     => esc_html__( 'Arrows Icon', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'ri-right-arrow-1',
                'options'   => rivax_get_arrows_icons(),
                'condition' => [
                    'animation_type!' => 'marquee',
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_layout',
            [
                'label'     => esc_html__( 'Layout', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'row'   => [
                        'title' => esc_html__( 'inline', 'syron' ),
                        'icon'  => 'eicon-navigation-horizontal',
                    ],
                    'column'  => [
                        'title' => esc_html__( 'Vertical', 'syron' ),
                        'icon'  => 'eicon-navigation-vertical',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-arrows' => 'flex-direction: {{VALUE}};',
                ],
                'condition' => [
                    'animation_type!' => 'marquee',
                    'carousel_arrows!' => '',
                ],
            ]
        );



        $this->end_controls_section();

    }


    protected function register_custom_content_controls() {

        $this->start_controls_section(
            'section_custom_content',
            [
                'label' => esc_html__( 'Custom Content', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('show_custom_content', [
            'label' => esc_html__('Show Custom Content', 'syron'),
            'type' => Controls_Manager::SWITCHER,
        ]);

        $repeater = new Repeater();

        $repeater->add_control(
            'custom_content_title',
            [
                'label'     => esc_html__( 'Title', 'syron' ),
                'type'      => Controls_Manager::TEXT,
                'default' => esc_html__( 'Custom Title' , 'syron' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'custom_content_url',
            [
                'label'     => esc_html__( 'URL', 'syron' ),
                'type'      => Controls_Manager::TEXT,
                'default' => '#',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'custom_content_items',
            [
                'label' => esc_html__( 'Custom Content Items', 'syron' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'custom_content_title' => esc_html__( 'Title #1', 'syron' ),
                        'custom_content_url' => '#',
                    ],
                ],
                'title_field' => '{{{ custom_content_title }}}',
                'condition' => [
                    'show_custom_content' => 'yes',
                ],
            ]
        );


        $this->end_controls_section();

    }


    protected function register_style_controls() {

        $this->start_controls_section('section_style_container',
            [
                'label' => esc_html__('Container', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('container_bg',
            [
                'label' => esc_html__('Background Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-wrapper' => '--ticker-wrapper-bg: {{VALUE}};',
                ],
            ]);

        $this->add_control('container_bg_dark_mode',
            [
                'label' => esc_html__('Background Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-news-ticker-wrapper' => '--ticker-wrapper-bg: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'container_border',
                'selector' => '{{WRAPPER}} .rivax-news-ticker-wrapper',
            ]);

        $this->add_control('container_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'container_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-news-ticker-wrapper' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('container_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'container_box_shadow',
                'selector' => '{{WRAPPER}} .rivax-news-ticker-wrapper',
            ]);


        $this->end_controls_section();



        $this->start_controls_section('section_style_title',
            [
                'label' => esc_html__('Title', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control('title_bg',
            [
                'label' => esc_html__('Background Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-wrapper' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_bg_dark_mode',
            [
                'label' => esc_html__('Background Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-news-ticker-title-wrapper' => 'background-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-text' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-news-ticker-title-text' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .rivax-news-ticker-title-wrapper',
            ]);

        $this->add_control('title_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'title_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-news-ticker-title-text' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('title_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('title_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'title_box_shadow',
                'selector' => '{{WRAPPER}} .rivax-news-ticker-title-wrapper',
            ]);


        $this->add_control('title_spacing',
            [
                'label' => esc_html__('Icon Spacing', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-wrapper' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_text_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .rivax-news-ticker-title-text',
            ]);


        $this->add_control(
            'title_pulse_settings',
            [
                'label' => esc_html__( 'Pulse Settings', 'syron' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'title_icon_type' => 'pulse',
                ],
            ]
        );

        $this->add_control('title_pulse_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-pulse' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title_icon_type' => 'pulse',
                ],
            ]);

        $this->add_control('title_pulse_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-news-ticker-title-pulse' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title_icon_type' => 'pulse',
                ],
            ]);

        $this->add_responsive_control('title_pulse_size',
            [
                'label' => esc_html__('Size', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 5,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-pulse' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'title_icon_type' => 'pulse',
                ],
            ]);

        $this->add_control('title_pulse_border_size',
            [
                'label' => esc_html__('Border Size', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-pulse::after, {{WRAPPER}} .rivax-news-ticker-title-pulse::before' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'title_icon_type' => 'pulse',
                ],
            ]);



        $this->add_control(
            'title_icon_settings',
            [
                'label' => esc_html__( 'Icon Settings', 'syron' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'title_icon_type' => 'icon',
                ],
            ]
        );

        $this->add_control('title_icon_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-icon' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title_icon_type' => 'icon',
                ],
            ]);

        $this->add_control('title_icon_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-news-ticker-title-icon' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title_icon_type' => 'icon',
                ],
            ]);

        $this->add_control('title_icon_bg',
            [
                'label' => esc_html__('Background Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-icon' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'title_icon_type' => 'icon',
                ],
            ]);

        $this->add_control('title_icon_bg_dark_mode',
            [
                'label' => esc_html__('Background Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .rivax-news-ticker-title-icon' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'title_icon_type' => 'icon',
                ],
            ]);

        $this->add_responsive_control('title_icon_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'title_icon_type' => 'icon',
                ],
            ]);


        $this->add_control('title_icon_size',
            [
                'label' => esc_html__('Size', 'syron'),
                'type' => Controls_Manager::NUMBER,
                'min' => 5,
                'max' => 50,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-icon' => 'font-size: {{VALUE}}px;',
                ],
                'condition' => [
                    'title_icon_type' => 'icon',
                ],
            ]);


        $this->add_responsive_control('title_icon_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-title-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'title_icon_type' => 'icon',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'title_icon_shadow',
                'selector' => '{{WRAPPER}} .rivax-news-ticker-title-icon',
                'condition' => [
                    'title_icon_type' => 'icon',
                ],
            ]);


        $this->end_controls_section();



        $this->start_controls_section('section_style_item',
            [
                'label' => esc_html__('Item', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control('items_content_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('item_spacing',
            [
                'label' => esc_html__('Spacing', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-item' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]);

        $this->add_control(
            'item_title_settings',
            [
                'label' => esc_html__( 'Title', 'syron' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'item_title_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .item-title',
            ]);


        $this->start_controls_tabs('item_title_tabs');
        # Normal State Tab
        $this->start_controls_tab(
            'item_title_tab_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_title_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .item-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        # Hover State Tab
        $this->start_controls_tab(
            'item_title_tab_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]
        );

        $this->add_control(
            'item_title_color_hover',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-title:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_title_color_hover_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .item-title:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();



        $this->add_control(
            'item_icon_settings',
            [
                'label' => esc_html__( 'Icon', 'syron' ),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]
        );

        $this->add_control('item_icon_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-icon' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]);

        $this->add_control('item_icon_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .item-icon' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]);

        $this->add_control('item_icon_bg',
            [
                'label' => esc_html__('Background Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-icon' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]);

        $this->add_control('item_icon_bg_dark_mode',
            [
                'label' => esc_html__('Background Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .item-icon' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]);

        $this->add_responsive_control('item_icon_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .item-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]);


        $this->add_control('item_icon_size',
            [
                'label' => esc_html__('Size', 'syron'),
                'type' => Controls_Manager::NUMBER,
                'min' => 5,
                'max' => 50,
                'selectors' => [
                    '{{WRAPPER}} .item-icon' => 'font-size: {{VALUE}}px;',
                ],
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]);


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_icon_border',
                'selector' => '{{WRAPPER}} .item-icon',
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]);

        $this->add_control('item_icon_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_icon_border_border!' => '',
                    'show_item_icon' => 'yes',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .item-icon' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('item_icon_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .item-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_icon_shadow',
                'selector' => '{{WRAPPER}} .item-icon',
                'condition' => [
                    'show_item_icon' => 'yes',
                ],
            ]);



        $this->add_control(
            'item_thumbnail_settings',
            [
                'label' => esc_html__( 'Thumbnail', 'syron' ),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'show_item_thumbnail' => 'yes',
                    'show_custom_content!' => 'yes',
                ],
            ]
        );


        $this->add_control('item_thumbnail_size',
            [
                'label' => esc_html__('Size', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 30,
                        'max' => 120,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-thumbnail' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_item_thumbnail' => 'yes',
                    'show_custom_content!' => 'yes',
                ],
            ]);


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_thumbnail_border',
                'selector' => '{{WRAPPER}} .item-thumbnail img',
                'condition' => [
                    'show_item_thumbnail' => 'yes',
                    'show_custom_content!' => 'yes',
                ],
            ]);

        $this->add_responsive_control('item_thumbnail_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .item-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_item_thumbnail' => 'yes',
                    'show_custom_content!' => 'yes',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_thumbnail_shadow',
                'selector' => '{{WRAPPER}} .item-thumbnail img',
                'condition' => [
                    'show_item_thumbnail' => 'yes',
                    'show_custom_content!' => 'yes',
                ],
            ]);



        $this->add_control(
            'item_date_settings',
            [
                'label' => esc_html__( 'Date', 'syron' ),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]
        );

        $this->add_control('item_date_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-date' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]);

        $this->add_control('item_date_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .item-date' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]);

        $this->add_control('item_date_bg',
            [
                'label' => esc_html__('Background Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-date' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]);

        $this->add_control('item_date_bg_dark_mode',
            [
                'label' => esc_html__('Background Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .item-date' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]);

        $this->add_responsive_control('item_date_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .item-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]);


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_date_border',
                'selector' => '{{WRAPPER}} .item-date',
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]);

        $this->add_control('item_date_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_date_border_border!' => '',
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .item-date' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('item_date_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .item-date' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]);


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'item_date_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .item-date',
                'condition' => [
                    'show_custom_content!' => 'yes',
                    'show_item_date' => 'yes',
                ],
            ]);

        $this->end_controls_section();



        $this->start_controls_section(
            'section_carousel_navigation_style',
            [
                'label'      => esc_html__( 'Navigation', 'syron' ),
                'tab'        => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'animation_type!' => 'marquee',
                    'carousel_arrows!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_arrows_section_padding',
            [
                'label'      => esc_html__( 'Section Padding', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'selectors'  => [
                    '{{WRAPPER}} .rivax-news-ticker-arrows' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('carousel_arrows_gap',
            [
                'label' => esc_html__('Arrows Gap', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-arrows' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control(
            'carousel_arrows_padding',
            [
                'label'      => esc_html__( 'Padding', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'selectors'  => [
                    '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_arrows_size',
            [
                'label'     => esc_html__( 'Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-news-ticker-arrows' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->start_controls_tabs( 'tabs_carousel_arrows_style' );

        $this->start_controls_tab(
            'tabs_carousel_arrows_normal',
            [
                'label'     => esc_html__( 'Normal', 'syron' ),
            ]
        );

        $this->add_control(
            'carousel_arrows_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_color_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_background',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'carousel_arrows_border',
                'selector'  => '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next',
            ]
        );

        $this->add_control('carousel_arrows_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'carousel_arrows_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control(
            'carousel_arrows_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'selectors'  => [
                    '{{WRAPPER}} .carousel-nav-prev, {{WRAPPER}} .carousel-nav-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_carousel_arrows_hover',
            [
                'label'     => esc_html__( 'Hover', 'syron' ),
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev:hover, {{WRAPPER}} .carousel-nav-next:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_color_dark_mode',
            [
                'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev:hover, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_background',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev:hover, {{WRAPPER}} .carousel-nav-next:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev:hover, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-nav-prev:hover, {{WRAPPER}} .carousel-nav-next:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'carousel_arrows_border_border!' => '',
                ],
            ]
        );

        $this->add_control(
            'carousel_arrows_hover_border_color_dark_mode',
            [
                'label'     => esc_html__( 'Border Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .carousel-nav-prev:hover, html[scheme="dark"] {{WRAPPER}} .carousel-nav-next:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'carousel_arrows_border_border!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'carousel_arrows_hover_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'selectors'  => [
                    '{{WRAPPER}} .carousel-nav-prev:hover, {{WRAPPER}} .carousel-nav-next:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();


    }



    protected function register_controls() {

        $this->register_settings_controls();
        $this->register_query_builder_controls();
        $this->register_custom_content_controls();

        $this->register_style_controls();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}