<?php

namespace Elementor;

use RivaxStudio\Traits\Rivax_Group_Control_Query;
use RivaxStudio\Traits\Rivax_Global_Widget_Controls;
use RivaxStudio\Traits\Rivax_Post_skin_base;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Pansy_Slider_Widget extends Widget_Base {

    use Rivax_Group_Control_Query;
    use Rivax_Global_Widget_Controls;
    use Rivax_Post_skin_base;

    public function get_name() {
        return 'rivax-pansy-slider';
    }

    public function get_title() {
        return esc_html__('Pansy Slider', 'syron');
    }

    public function get_icon() {
        return 'eicon-post-slider';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }
	
	public function get_style_depends() {
		return [ 'swiper', 'e-swiper' ];
	}


    protected function register_post_controls() {

        $this->start_controls_section(
            'section_post_settings',
            [
                'label' => esc_html__( 'Post Settings', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'item_height',
            [
                'label'     => esc_html__( 'Item Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 300,
                        'max' => 1000,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_width',
            [
                'label'     => esc_html__( 'Content Width', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units'=> [ 'px', '%' ],
                'range'     => [
                    'px' => [
                        'min' => 200,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 40,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper-inner' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'align_content',
            [
                'label'     => esc_html__( 'Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'start'   => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'end'  => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'v_align_content',
            [
                'label'     => esc_html__( 'Vertical Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'start'   => [
                        'title' => esc_html__( 'top', 'syron' ),
                        'icon'  => 'eicon-v-align-top',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon'  => 'eicon-v-align-middle',
                    ],
                    'end'  => [
                        'title' => esc_html__( 'bottom', 'syron' ),
                        'icon'  => 'eicon-v-align-bottom',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'exclude' => ['custom'],
                'default' => 'rivax-wide',
                'separator' => 'before',
            ]);

        $this->add_control(
            'skip_lazy_loading',
            [
                'label'     => esc_html__( 'Skip Lazy Loading', 'syron' ),
                'description' => sprintf(esc_html__('Use this to remove lazy loading from %s Largest Contentful Paint (LCP) %s image.', 'syron'), '<a href="' . esc_url('https://gtmetrix.com/dont-lazy-load-lcp-image.html') . '" target="_blank">', '</a>'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    '0'     => esc_html__( 'No', 'syron' ),
                    '1'     => esc_html__( '1 Image', 'syron' ),
                ],
            ]
        );

        $this->add_control(
            'carousel_effect',
            [
                'label'        => esc_html__( 'Effect', 'syron' ),
                'type'         => Controls_Manager::SELECT,
                'default'      => 'fade',
                'options'      => [
                    'slide'    => esc_html__( 'Slide', 'syron' ),
                    'fade'     => esc_html__( 'Fade', 'syron' ),
                ],
                'separator'    => 'before',
            ]
        );

        $this->add_control(
            'image_zoom_size',
            [
                'label'     => esc_html__( 'Image Zoom Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 2,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1,
                ],
            ]
        );

        $this->register_title_controls('h2');

        $this->register_terms_controls();

        $this->register_author_controls();

        $this->register_date_controls();

        $this->register_comments_controls();

        $this->register_views_count_controls();

        $this->register_reading_time_controls();

        $this->register_excerpt_controls();

        $this->end_controls_section();

    }


    protected function register_thumb_controls() {

        $this->start_controls_section(
            'section_thumb_settings',
            [
                'label' => esc_html__( 'Thumb Settings', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'thumbs_direction',
            [
                'label'     => esc_html__( 'Direction', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options'   => [
                    'horizontal'     => esc_html__( 'Horizontal', 'syron' ),
                    'vertical'       => esc_html__( 'Vertical', 'syron' ),
                ],
            ]
        );

        $this->add_control(
            'thumbs_count',
            [
                'label'     => esc_html__( 'Count', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default' => '3',
                'options'   => [
                    '3'     => '3',
                    '4'     => '4',
                    '5'     => '5',
                ],
            ]
        );

        $this->add_control(
            'thumb_style',
            [
                'label'     => esc_html__( 'Thumb Style', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'default' => '',
                'options'   => [
                    ''                           => esc_html__( 'Default', 'syron' ),
                    'thumb-style-1'              => esc_html__( 'Style 1', 'syron' ),
                    'thumb-style-2'              => esc_html__( 'Style 2', 'syron' ),
                    'thumb-style-3'              => esc_html__( 'Style 3', 'syron' ),
					'thumb-style-4'              => esc_html__( 'Style 4', 'syron' ),
                ],
            ]
        );

        $this->add_control(
            'thumbs_spacing',
            [
                'label'     => esc_html__( 'Items Spacing', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
            ]
        );

        $this->add_responsive_control(
            'thumbs_container_size',
            [
                'label'     => esc_html__( 'Container Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units'=> [ 'px', '%' ],
                'range'     => [
                    'px' => [
                        'min' => 200,
                        'max' => 600,
                    ],
                    '%' => [
                        'min' => 30,
                        'max' => 80,
                    ],
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-wrapper' => '--thumbs-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'thumbs_h_align',
            [
                'label'     => esc_html__( 'Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon'  => 'eicon-h-align-right',
                    ],
                ],
                'condition' => [
                    'thumbs_direction' => 'horizontal',
                ],
                'selectors' => [
                    '{{WRAPPER}} .thumbs-slider' => 'margin-{{VALUE}}: 0;',
                ],
            ]
        );

        $this->add_control(
            'thumbs_v_align',
            [
                'label'     => esc_html__( 'Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'start'   => [
                        'title' => esc_html__( 'top', 'syron' ),
                        'icon'  => 'eicon-v-align-top',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon'  => 'eicon-v-align-middle',
                    ],
                ],
                'condition' => [
                    'thumbs_direction' => 'vertical',
                ],
                'selectors' => [
                    '{{WRAPPER}} .thumbs-slider-inner' => 'align-items: {{VALUE}};',
                ],
            ]
        );

	    $this->add_control(
		    'thumbs_h_edge',
		    [
			    'label'     => esc_html__( 'Edge Position', 'syron' ),
			    'type'      => Controls_Manager::SWITCHER,
			    'condition' => [
				    'thumbs_direction' => 'horizontal',
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .thumbs-slider-wrapper' => 'transform: translateY(50%);',
			    ],
		    ]
	    );

        $this->end_controls_section();

    }


    protected function register_style_post_controls() {

        $this->start_controls_section('section_style_post',
            [
                'label' => esc_html__('Items', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_overlay_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .main-slider .image-wrapper::before',
            ]
        );

        $this->add_responsive_control('item_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .main-slider' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->end_controls_section();

        $this->start_controls_section('section_style_thumb',
            [
                'label' => esc_html__('Thumb', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);

        $this->add_control(
            'thumb_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thumb-wrapper' => '--th-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'thumb_active_color',
            [
                'label' => esc_html__('Active Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thumb-wrapper' => '--th-active-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control('thumb_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .thumb-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_control(
            'thumb_opacity',
            [
                'label'     => esc_html__( 'Opacity', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .thumb-wrapper' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function register_controls() {

        $this->register_query_builder_controls();
        $this->register_post_controls();
        $this->register_slider_controls();
        $this->register_carousel_nav_controls('slider');
        $this->register_thumb_controls();

        $this->register_style_post_controls();
        $this->register_style_title_controls();
        $this->register_style_terms_controls();
        $this->register_style_meta_controls();
        $this->register_style_excerpt_controls();
        $this->register_style_carousel_nav_controls('slider');

    }


    protected function render_slider_header() {
        $settings        = $this->get_settings_for_display();

        $id = 'rivax-slider-' . $this->get_id();

        $this->add_render_attribute( 'slider', 'id', $id );
        $this->add_render_attribute( 'slider', 'class', 'rivax-posts-carousel-wrapper' );

        if ( $settings['carousel_pagination'] ) {
            $pagination_type = $settings['carousel_pagination_type'];
        } else {
            $pagination_type = '';
        }

        $slider_settings = [
            "autoplay"              => ( "yes" == $settings["slider_autoplay"] ) ? [ "delay" => $settings["slider_autoplay_speed"] ] : false,
            "loop"                  => ( $settings["slider_loop"] == "yes" ),
            "speed"                 => $settings["slider_speed"]["size"],
            "pauseOnMouseEnter"     => ( $settings["slider_pauseonhover"] == "yes" ),
            "grabCursor"            => ( $settings["slider_grab_cursor"] == "yes" ),
            "effect"                => $settings["carousel_effect"],
            "parallax"              => true,
            "loopedSlides"          => 6,
            "touchRatio"          => 0.2,
            "navigation"            => [
                "nextEl" => "#" . $id . " .carousel-nav-next",
                "prevEl" => "#" . $id . " .carousel-nav-prev",
            ],
            "pagination"            => [
                "el"             => "#" . $id . " .carousel-pagination",
                "type"           => $pagination_type,
                "clickable"      => "true",
                'dynamicBullets' => ( "yes" == $settings["carousel_dynamic_bullets"] ),
            ],
            "a11y"            => [
                "enabled"             => "false",
            ],
            "fadeEffect"            => [
                "crossFade" => true,
            ],

        ];


        $this->add_render_attribute('slider', 'data-settings', wp_json_encode(array_filter($slider_settings)) );

        ?>
        <div <?php $this->print_render_attribute_string( 'slider' ); ?>>
        <div class="swiper main-slider">
        <div class="swiper-wrapper">
        <?php
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}