<?php

namespace Elementor;

use RivaxStudio\Traits\Rivax_Group_Control_Query;
use RivaxStudio\Traits\Rivax_Global_Widget_Controls;
use RivaxStudio\Traits\Rivax_Post_skin_base;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Post_Elastic_Widget extends Widget_Base {

    use Rivax_Group_Control_Query;
    use Rivax_Global_Widget_Controls;
    use Rivax_Post_skin_base;

    public function get_name() {
        return 'rivax-post-elastic';
    }

    public function get_title() {
        return esc_html__('Post Elastic', 'syron');
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }
	
	public function get_style_depends() {
		if (\Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode()) {
			return [];
		}
		
		if ( $this->get_settings_for_display( 'layout' ) == 'carousel' ) {
			return [ 'swiper', 'e-swiper' ];
		} else {
			return [];
		}
	}


    protected function register_layout_controls() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'     => esc_html__( 'Layout', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'grid'     => esc_html__( 'Grid', 'syron' ),
                    'carousel' => esc_html__( 'Carousel', 'syron' ),
                ],
                'default'   => 'grid',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label'              => esc_html__( 'Columns', 'syron' ),
                'type'               => Controls_Manager::SELECT,
                'default'            => '2',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
                ],
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label'     => esc_html__( 'Column Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '30',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
                    'body:not(.rtl) {{WRAPPER}} .rivax-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .rivax-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'     => esc_html__( 'Row Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '30',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout!' => 'carousel',
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function register_post_controls(){

        $this->start_controls_section(
            'section_post_settings',
            [
                'label' => esc_html__( 'Post Settings', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

	    $this->add_control(
		    'article_layout',
		    [
			    'label'   => esc_html__( 'Layout', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'card-layout',
			    'options' => [
				    'card-layout'         => esc_html__( 'Card Layout', 'syron' ),
				    'simple-layout'       => esc_html__( 'Simple Layout', 'syron' ),
				    'mini-layout'       => esc_html__( 'Mini Layout', 'syron' ),
			    ],
		    ]
	    );

        $this->add_responsive_control(
            'start_position',
            [
                'label' => esc_html__( 'Start Position', 'syron' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'row' => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'row-reverse' => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                    'column' => [
                        'title' => esc_html__( 'Top', 'syron' ),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'column-reverse' => [
                        'title' => esc_html__( 'Bottom', 'syron' ),
                        'icon' => 'eicon-v-align-bottom',
                    ]
                ],
                'default' => 'row',
                'selectors' => [
                    '{{WRAPPER}} .post-inner' => 'flex-direction: {{VALUE}}'
                ],
            ]
        );

        $this->add_control(
            'full_width_footer',
            [
                'label'   => esc_html__( 'Full Width Footer', 'syron' ),
                'type'    => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'show_image',
            [
                'label'   => esc_html__( 'Show Image', 'syron' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'image_animation',
            [
                'label'     => esc_html__( 'Image Animation', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [
                    'show_image!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'exclude' => ['custom'],
                'default' => 'rivax-small-square',
                'condition' => [
                    'show_image!' => '',
                ],
            ]
        );

        $this->add_control(
            'skip_lazy_loading',
            [
                'label'     => esc_html__( 'Skip Lazy Loading', 'syron' ),
                'description' => sprintf(esc_html__('Use this to remove lazy loading from %s Largest Contentful Paint (LCP) %s image.', 'syron'), '<a href="' . esc_url('https://gtmetrix.com/dont-lazy-load-lcp-image.html') . '" target="_blank">', '</a>'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    '0'     => esc_html__( 'No', 'syron' ),
                    '1'     => esc_html__( '1 Image', 'syron' ),
                    '2'     => esc_html__( '2 Images', 'syron' ),
                    '3'     => esc_html__( '3 Images', 'syron' ),
                    '4'     => esc_html__( '4 Images', 'syron' ),
                ],
            ]
        );


	    $this->add_responsive_control(
		    'thumbnail_zigzag',
		    [
			    'label' => esc_html__( 'Zigzag Position', 'syron' ),
			    'type' => Controls_Manager::CHOOSE,
			    'options' => [
				    'unset' => [
					    'title' => esc_html__( 'No', 'syron' ),
					    'icon' => 'eicon-close',
				    ],
				    '2' => [
					    'title' => esc_html__( 'Yes', 'syron' ),
					    'icon' => 'eicon-check',
				    ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .post-item:nth-child(even) .image-outer-wrapper' => 'order: {{VALUE}}'
			    ],
			    'condition' => [
				    'show_image!' => '',
			    ],
		    ]
	    );
		
		$this->add_responsive_control(
            'align_content',
            [
                'label'     => esc_html__( 'Content Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-inner' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                ],
				'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'align_vertical_content',
            [
                'label'     => esc_html__( 'Content Vertical Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'start' => [
                        'title' => esc_html__( 'Top', 'syron' ),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon' => 'eicon-v-align-middle',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Bottom', 'syron' ),
                        'icon' => 'eicon-v-align-bottom',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'align-self: {{VALUE}};',
                ],
            ]
        );
		
		$this->add_control(
            'hide_last_item_on_tablet',
            [
                'label'     => esc_html__( 'Hide Last Item On Tablet', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'selectors' => [
                    'body[data-elementor-device-mode="tablet"] {{WRAPPER}} .post-item:last-of-type' => 'display: none;',
                ],
				'condition' => [
                    'layout' => 'grid',
                ],
				'separator' => 'before',
            ]
        );

        $this->register_title_controls();

        $this->register_terms_controls();

	    $this->register_author_controls();

        $this->register_date_controls();

		$this->register_comments_controls();

	    $this->add_control(
		    'comments_position',
		    [
			    'label'   => esc_html__( 'Position', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'inline',
			    'options' => [
				    'inline'         => esc_html__( 'Inline', 'syron' ),
				    'footer'         => esc_html__( 'Footer', 'syron' ),
			    ],
			    'condition' => [
				    'show_comments' => 'yes',
			    ],
		    ]
	    );

		$this->register_views_count_controls();

	    $this->add_control(
		    'views_position',
		    [
			    'label'   => esc_html__( 'Position', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'inline',
			    'options' => [
				    'inline'         => esc_html__( 'Inline', 'syron' ),
				    'footer'         => esc_html__( 'Footer', 'syron' ),
			    ],
			    'condition' => [
				    'show_views_count' => 'yes',
			    ],
		    ]
	    );

		$this->register_reading_time_controls();

	    $this->add_control(
		    'reading_position',
		    [
			    'label'   => esc_html__( 'Position', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'inline',
			    'options' => [
				    'inline'         => esc_html__( 'Inline', 'syron' ),
				    'footer'         => esc_html__( 'Footer', 'syron' ),
			    ],
			    'condition' => [
				    'show_reading_time' => 'yes',
			    ],
		    ]
	    );

        $this->register_excerpt_controls();

        $this->register_post_format_icon_controls();

	    $this->add_control(
		    'show_counter',
		    [
			    'label'     => esc_html__( 'Counter', 'syron' ),
			    'type'      => Controls_Manager::SWITCHER,
			    'separator' => 'before'
		    ]
	    );

	    $this->add_control(
		    'counter_position',
		    [
			    'label'   => esc_html__( 'Position', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'outside-image',
			    'options' => [
				    'inside-image'         => esc_html__( 'Inside Image', 'syron' ),
				    'outside-image'         => esc_html__( 'Outside Image', 'syron' ),
			    ],
			    'condition' => [
				    'show_counter' => 'yes'
			    ]
		    ]
	    );

	    $this->add_control(
		    'counter_inside_image_position',
		    [
			    'label'     => esc_html__( 'Inside Position', 'syron' ),
			    'type'      => Controls_Manager::SELECT,
			    'options'   => [
				    'top-left'          => esc_html__( 'Top Left', 'syron' ),
				    'top-right'         => esc_html__( 'Top Right', 'syron' ),
				    'bottom-left'       => esc_html__( 'Bottom Left', 'syron' ),
				    'bottom-right'      => esc_html__( 'Bottom Right', 'syron' ),
				    'center-center'      => esc_html__( 'Center Center', 'syron' ),
				    'center-left'      => esc_html__( 'Center Left', 'syron' ),
				    'center-right'      => esc_html__( 'Center Right', 'syron' ),
			    ],
			    'default'   => 'top-left',
			    'condition' => [
				    'show_counter' => 'yes',
				    'counter_position' => 'inside-image',
			    ]
		    ]
	    );

        $this->end_controls_section();

    }


    protected function register_style_post_controls() {

        $this->start_controls_section('section_style_post',
            [
                'label' => esc_html__('Items', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control('item_padding',
            [
                'label' => esc_html__('Item Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->start_controls_tabs('tabs_item_style');

        $this->start_controls_tab('tab_item_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .post-wrapper',
            ]
        );

        $this->add_control(
            'heading_item_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .post-wrapper',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'item_border',
                'selector' => '{{WRAPPER}} .post-wrapper',
            ]
        );

        $this->add_control('item_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'selectors'  => [
                    '{{WRAPPER}} .post-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'selector' => '{{WRAPPER}} .post-wrapper',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_item_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_hover_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .post-wrapper:hover',
            ]
        );

        $this->add_control(
            'heading_item_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_hover_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .post-wrapper:hover',
            ]
        );

        $this->add_control('item_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('item_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_hover_box_shadow',
                'selector' => '{{WRAPPER}} .post-wrapper:hover',
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_image',
            [
                'label'     => esc_html__( 'Image', 'syron' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_image' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control('item_image_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .image-outer-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control(
            'item_image_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'syron' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'selectors'  => [
                    '{{WRAPPER}} .image-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_image_width',
            [
                'label'     => esc_html__( 'Width', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units'=> [ 'px', '%', 'vw', 'vh' ],
                'range'     => [
                    'px' => [
                        'min' => 50,
                        'max' => 600,
                    ],
                    '%' => [
                        'min' => 20,
                        'max' => 100,
                    ],
					'vw' => [
                        'min' => 20,
                        'max' => 100,
                    ],
					'vh' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-outer-wrapper' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_image_height',
            [
                'label'     => esc_html__( 'Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units'=> [ 'px', '%', 'vw', 'vh' ],
                'range'     => [
                    'px' => [
                        'min' => 50,
                        'max' => 600,
                    ],
                    '%' => [
                        'min' => 20,
                        'max' => 100,
                    ],
					'vw' => [
                        'min' => 20,
                        'max' => 100,
                    ],
					'vh' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-outer-wrapper' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


	    $this->start_controls_tabs('tabs_item_image_style');

	    $this->start_controls_tab('tab_item_image_normal',
		    [
			    'label' => esc_html__('Normal', 'syron'),
		    ]);

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'item_image_overlay_color',
			    'label' => esc_html__('Overlay Color', 'syron'),
			    'exclude' => [ 'image' ],
			    'selector' => '{{WRAPPER}} .image-wrapper::before',
		    ]
	    );

	    $this->add_control(
		    'item_image_overlay_height',
		    [
			    'label'     => esc_html__( 'Overlay Height', 'syron' ),
			    'type'      => Controls_Manager::SLIDER,
			    'range'     => [
				    'px' => [
					    'min' => 0,
					    'max' => 100,
				    ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .image-wrapper::before' => 'height: {{SIZE}}%;',
			    ],
		    ]
	    );


	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'item_image_border',
			    'selector' => '{{WRAPPER}} .image-wrapper',
		    ]);

        $this->add_control('item_image_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_image_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .image-wrapper' => 'border-color: {{VALUE}};',
                ],
            ]);

	    $this->add_group_control(Group_Control_Box_Shadow::get_type(),
		    [
			    'name' => 'item_image_box_shadow',
			    'selector' => '{{WRAPPER}} .image-wrapper',
		    ]);

	    $this->end_controls_tab();

	    $this->start_controls_tab('tab_item_image_hover',
		    [
			    'label' => esc_html__('Hover', 'syron'),
		    ]);

	    $this->add_group_control(
		    Group_Control_Background::get_type(),
		    [
			    'name' => 'item_image_overlay_hover_color',
			    'label' => esc_html__('Overlay Color', 'syron'),
			    'exclude' => [ 'image' ],
			    'selector' => '{{WRAPPER}} .image-wrapper:hover::before',
		    ]
	    );

	    $this->add_control(
		    'item_image_overlay_hover_height',
		    [
			    'label'     => esc_html__( 'Overlay Height', 'syron' ),
			    'type'      => Controls_Manager::SLIDER,
			    'range'     => [
				    'px' => [
					    'min' => 0,
					    'max' => 100,
				    ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .image-wrapper:hover::before' => 'height: {{SIZE}}%;',
			    ],
		    ]
	    );

	    $this->add_control('item_image_hover_border_color',
		    [
			    'label' => esc_html__('Border Color', 'syron'),
			    'type' => Controls_Manager::COLOR,
			    'condition' => [
				    'item_image_border_border!' => '',
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .image-wrapper:hover' => 'border-color: {{VALUE}};',
			    ],
		    ]);

        $this->add_control('item_image_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_image_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .image-wrapper:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

	    $this->add_group_control(
		    Group_Control_Box_Shadow::get_type(),
		    [
			    'name' => 'item_image_hover_box_shadow',
			    'selector' => '{{WRAPPER}} .image-wrapper:hover',
		    ]);

	    $this->end_controls_tab();
	    $this->end_controls_tabs();

        $this->end_controls_section();
    }


    protected function register_controls() {

        $this->register_layout_controls();
        $this->register_query_builder_controls();
        $this->register_post_controls();
        $this->register_pagination_controls();
        $this->register_carousel_controls();
        $this->register_carousel_nav_controls();

        $this->register_style_post_controls();
        $this->register_style_post_date_controls();
        $this->register_style_post_counter_controls();
        $this->register_style_title_controls();
        $this->register_style_terms_controls();
        $this->register_style_meta_controls();
        $this->register_style_excerpt_controls();
        $this->register_style_post_format_icon_controls();
        $this->register_style_pagination_controls();
        $this->register_style_carousel_nav_controls();

    }



	// Overwrite global register_date_controls()
	protected function register_date_controls() {

		$this->add_control(
			'show_date',
			[
				'label'     => esc_html__( 'Date', 'syron' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'separator' => 'before'
			]
		);

		$this->add_control(
			'meta_date_position',
			[
				'label'   => esc_html__( 'Position', 'syron' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'inline',
				'options' => [
					'inline'              => esc_html__( 'Inline', 'syron' ),
					'inside-image'         => esc_html__( 'Inside Image', 'syron' ),
					'outside-image'         => esc_html__( 'Outside Image', 'syron' ),
				],
				'condition' => [
					'show_date' => 'yes'
				]
			]
		);

        $this->add_responsive_control(
            'date_vertically',
            [
                'label' => esc_html__( 'Vertically', 'syron' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Start', 'syron' ),
                        'icon' => 'eicon-align-start-v',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon' => 'eicon-justify-center-v',
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'End', 'syron' ),
                        'icon' => 'eicon-align-end-v',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .date-in-out-image' => 'align-self: {{VALUE}};',
                ],
                'condition' => [
                    'show_date' => 'yes',
                    'meta_date_position' => 'outside-image'
                ]
            ]
        );

		$this->add_control(
			'show_date_icon',
			[
				'label'     => esc_html__( 'Icon', 'syron' ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'show_date' => 'yes',
					'meta_date_position!' => ['inside-image', 'outside-image'],
				]
			]
		);

		$this->add_control(
			'human_diff_time',
			[
				'label'     => esc_html__( 'Human Different Time', 'syron' ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'show_date' => 'yes',
					'meta_date_position!' => ['inside-image', 'outside-image'],
				]
			]
		);

		$this->add_control(
			'show_time',
			[
				'label'     => esc_html__( 'Show Time', 'syron' ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'human_diff_time' => '',
					'show_date'       => 'yes',
					'meta_date_position!' => ['inside-image', 'outside-image'],
				]
			]
		);

		$this->add_control(
			'date_inside_image_position',
			[
				'label'     => esc_html__( 'Image Date Position', 'syron' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'top-left'          => esc_html__( 'Top Left', 'syron' ),
					'top-right'         => esc_html__( 'Top Right', 'syron' ),
					'bottom-left'       => esc_html__( 'Bottom Left', 'syron' ),
					'bottom-right'      => esc_html__( 'Bottom Right', 'syron' ),
				],
				'default'   => 'bottom-right',
				'condition' => [
					'show_date' => 'yes',
					'meta_date_position' => 'inside-image',
				]
			]
		);

	}



    protected function render() {

        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}