<?php

namespace Elementor;

use RivaxStudio\Traits\Rivax_Group_Control_Query;
use RivaxStudio\Traits\Rivax_Global_Widget_Controls;
use RivaxStudio\Traits\Rivax_Post_skin_base;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Post_Modern_Widget extends Widget_Base {

    use Rivax_Group_Control_Query;
    use Rivax_Global_Widget_Controls;
    use Rivax_Post_skin_base;

    public function get_name() {
        return 'rivax-post-modern';
    }

    public function get_title() {
        return esc_html__('Post Modern', 'syron');
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }
	
	public function get_style_depends() {
		if (\Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode()) {
			return [];
		}
		
		if ( $this->get_settings_for_display( 'layout' ) == 'carousel' ) {
			return [ 'swiper', 'e-swiper' ];
		} else {
			return [];
		}
	}

	public function get_script_depends() {
		if (\Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode()) {
			return ['masonry'];
		}

		if ( $this->get_settings_for_display( 'layout' ) == 'masonry' ) {
			return [ 'masonry' ];
		} else {
			return [];
		}
	}


    protected function register_layout_controls() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'     => esc_html__( 'Layout', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'grid'     => esc_html__( 'Grid', 'syron' ),
                    'masonry'  => esc_html__( 'Masonry', 'syron' ),
                    'carousel' => esc_html__( 'Carousel', 'syron' ),
                ],
                'default'   => 'grid',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label'              => esc_html__( 'Columns', 'syron' ),
                'type'               => Controls_Manager::SELECT,
                'default'            => '3',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-masonry .post-item' => 'width: calc(100% / {{SIZE}});',
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
                ],
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label'     => esc_html__( 'Column Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '30',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'render_type'    => 'template',
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
                    'body:not(.rtl) {{WRAPPER}} .rivax-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .rivax-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-masonry' => 'margin-left: calc({{SIZE}}{{UNIT}} * -.5); margin-right: calc({{SIZE}}{{UNIT}} * -.5);',
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-masonry .post-item' => 'padding-left: calc({{SIZE}}{{UNIT}} * .5); padding-right: calc({{SIZE}}{{UNIT}} * .5);',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'     => esc_html__( 'Row Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '40',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .rivax-posts-wrapper.layout-masonry .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout!' => 'carousel',
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function register_post_controls() {

        $this->start_controls_section(
            'section_post_settings',
            [
                'label' => esc_html__( 'Post Settings', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

	    $this->add_control(
		    'article_layout',
		    [
			    'label'   => esc_html__( 'Layout', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'card-layout',
			    'options' => [
				    'card-layout'         => esc_html__( 'Card Layout', 'syron' ),
				    'simple-layout'       => esc_html__( 'Simple Layout', 'syron' ),
			    ],
		    ]
	    );

	    $this->add_control(
            'align_content',
            [
                'label'     => esc_html__( 'Content Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-inner' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                ],
            ]
        );

		
		$this->add_control(
            'hide_last_item_on_tablet',
            [
                'label'     => esc_html__( 'Hide Last Item On Tablet', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'selectors' => [
                    'body[data-elementor-device-mode="tablet"] {{WRAPPER}} .post-item:last-of-type' => 'display: none;',
                ],
				'condition' => [
                    'layout' => 'grid',
                ],
				'separator' => 'before',
            ]
        );	

		$this->add_control(
            'image_animation',
            [
                'label'     => esc_html__( 'Image Animation', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default' => 'yes',
				'separator' => 'before',
            ]
        );		

        $this->add_responsive_control(
            'image_height',
            [
                'label'     => esc_html__( 'Image Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
				'size_units'=> [ 'px', '%', 'vw', 'vh' ],
                'range'     => [
                    'px' => [
                        'min' => 200,
                        'max' => 800,
                    ],
                    '%' => [
                        'min' => 30,
                        'max' => 100,
                    ],
					'vw' => [
                        'min' => 20,
                        'max' => 100,
                    ],
					'vh' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper' => 'height: {{SIZE}}{{UNIT}};',
                ],
				'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
            'name' => 'thumbnail',
            'exclude' => ['custom'],
            'default' => 'rivax-small',
        ]);

        $this->add_control(
            'skip_lazy_loading',
            [
                'label'     => esc_html__( 'Skip Lazy Loading', 'syron' ),
                'description' => sprintf(esc_html__('Use this to remove lazy loading from %s Largest Contentful Paint (LCP) %s image.', 'syron'), '<a href="' . esc_url('https://gtmetrix.com/dont-lazy-load-lcp-image.html') . '" target="_blank">', '</a>'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    '0'     => esc_html__( 'No', 'syron' ),
                    '1'     => esc_html__( '1 Image', 'syron' ),
                    '2'     => esc_html__( '2 Images', 'syron' ),
                    '3'     => esc_html__( '3 Images', 'syron' ),
                    '4'     => esc_html__( '4 Images', 'syron' ),
                ],
            ]
        );

        $this->add_control('show_image_svg_cover', [
            'label' => esc_html__('Image Svg Cover', 'syron'),
            'type' => Controls_Manager::SWITCHER,
        ]);

        $this->add_control(
            'image_svg_cover',
            [
                'label'     => esc_html__( 'Cover Style', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'clouds'            => esc_html__( 'Clouds', 'syron' ),
                    'corner'            => esc_html__( 'Corner', 'syron' ),
                    'corner2'            => esc_html__( 'Corner 2', 'syron' ),
                    'corner-up'         => esc_html__( 'Corner Up', 'syron' ),
                    'cross-line'        => esc_html__( 'Cross Line', 'syron' ),
                    'curve'             => esc_html__( 'Curve', 'syron' ),
                    'curve-up'          => esc_html__( 'Curve Up', 'syron' ),
                    'drops'             => esc_html__( 'Drops', 'syron' ),
                    'mountains'         => esc_html__( 'Mountains', 'syron' ),
                    'pyramids'          => esc_html__( 'Pyramids', 'syron' ),
                    'splash'            => esc_html__( 'Splash', 'syron' ),
                    'split'             => esc_html__( 'Split', 'syron' ),
                    'book'              => esc_html__( 'Book', 'syron' ),
                    'tilt'              => esc_html__( 'Tilt', 'syron' ),
                    'torn-paper'        => esc_html__( 'Torn Paper', 'syron' ),
                    'triangle'          => esc_html__( 'Triangle', 'syron' ),
                    'wave'              => esc_html__( 'Wave', 'syron' ),
                    'wave2'             => esc_html__( 'Wave 2', 'syron' ),
                    'wave3'             => esc_html__( 'Wave 3', 'syron' ),
                    'wave-dash'         => esc_html__( 'Wave Dash', 'syron' ),
                    'wave-splash'       => esc_html__( 'Wave Splash', 'syron' ),
                    'zigzag'            => esc_html__( 'Zigzag', 'syron' ),
                    'slant-up'          => esc_html__( 'Slant Up', 'syron' ),
                ],
                'default'   => 'clouds',
                'condition' => [
                    'show_image_svg_cover' => 'yes',
                ],
            ]
        );

        $this->register_title_controls();

        $this->register_terms_controls();

        $this->register_author_controls();

        $this->register_date_controls();

        $this->register_comments_controls();

	    $this->add_control(
		    'comments_position',
		    [
			    'label'   => esc_html__( 'Position', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'inline',
			    'options' => [
				    'inline'         => esc_html__( 'Inline', 'syron' ),
				    'footer'         => esc_html__( 'Footer', 'syron' ),
			    ],
			    'condition' => [
				    'show_comments' => 'yes',
			    ],
		    ]
	    );

	    $this->register_views_count_controls();

	    $this->add_control(
		    'views_position',
		    [
			    'label'   => esc_html__( 'Position', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'inline',
			    'options' => [
				    'inline'         => esc_html__( 'Inline', 'syron' ),
				    'footer'         => esc_html__( 'Footer', 'syron' ),
			    ],
			    'condition' => [
				    'show_views_count' => 'yes',
			    ],
		    ]
	    );

	    $this->register_reading_time_controls();

	    $this->add_control(
		    'reading_position',
		    [
			    'label'   => esc_html__( 'Position', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'inline',
			    'options' => [
				    'inline'         => esc_html__( 'Inline', 'syron' ),
				    'footer'         => esc_html__( 'Footer', 'syron' ),
			    ],
			    'condition' => [
				    'show_reading_time' => 'yes',
			    ],
		    ]
	    );

        $this->register_excerpt_controls();

        $this->register_post_format_icon_controls();

	    $this->add_control(
		    'show_counter',
		    [
			    'label'     => esc_html__( 'Counter', 'syron' ),
			    'type'      => Controls_Manager::SWITCHER,
			    'separator' => 'before'
		    ]
	    );

	    $this->add_control(
		    'counter_position',
		    [
			    'label'   => esc_html__( 'Position', 'syron' ),
			    'type'    => Controls_Manager::SELECT,
			    'default' => 'outside-image',
			    'options' => [
				    'inside-image'         => esc_html__( 'Inside Image', 'syron' ),
				    'outside-image'         => esc_html__( 'Outside Image', 'syron' ),
			    ],
			    'condition' => [
				    'show_counter' => 'yes'
			    ]
		    ]
	    );

	    $this->add_control(
		    'counter_inside_position',
		    [
			    'label'     => esc_html__( 'Inside Position', 'syron' ),
			    'type'      => Controls_Manager::SELECT,
			    'options'   => [
				    'top-left'          => esc_html__( 'Top Left', 'syron' ),
				    'top-right'         => esc_html__( 'Top Right', 'syron' ),
				    'bottom-left'       => esc_html__( 'Bottom Left', 'syron' ),
				    'bottom-right'      => esc_html__( 'Bottom Right', 'syron' ),
				    'center-center'      => esc_html__( 'Center Center', 'syron' ),
				    'center-left'      => esc_html__( 'Center Left', 'syron' ),
				    'center-right'      => esc_html__( 'Center Right', 'syron' ),
			    ],
			    'default'   => 'top-left',
			    'condition' => [
				    'show_counter' => 'yes',
			    ]
		    ]
	    );


        $this->add_control('show_top_content', [
            'label' => esc_html__('Top Content', 'syron'),
            'type' => Controls_Manager::SWITCHER,
            'separator' => 'before',
        ]);

        $this->add_control('top_content_comments', [
            'label' => esc_html__('Comments', 'syron'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'show_top_content' => 'yes',
            ],
        ]);

        $this->add_control('top_content_views', [
            'label' => esc_html__('Views', 'syron'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'show_top_content' => 'yes',
            ],
        ]);

        $this->add_control('top_content_reading_time', [
            'label' => esc_html__('Reading Time', 'syron'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'show_top_content' => 'yes',
            ],
        ]);

        $this->end_controls_section();

    }


    protected function register_style_post_controls() {

        $this->start_controls_section('section_style_post',
            [
                'label' => esc_html__('Items', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control('item_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->start_controls_tabs('tabs_item_style');

        $this->start_controls_tab('tab_item_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .post-wrapper',
            ]
        );

        $this->add_control(
            'heading_item_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .post-wrapper',
            ]
        );


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .post-wrapper',
            ]);

        $this->add_control('item_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('item_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'selector' => '{{WRAPPER}} .post-wrapper',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_item_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_hover_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .post-wrapper:hover',
            ]
        );

        $this->add_control(
            'heading_item_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_hover_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .post-wrapper:hover',
            ]
        );

        $this->add_control('item_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-wrapper:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('item_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .post-wrapper:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_hover_box_shadow',
                'selector' => '{{WRAPPER}} .post-wrapper:hover',
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section('section_style_image',
            [
            'label' => esc_html__('Image', 'syron'),
            'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control('image_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->start_controls_tabs('tabs_image_style');

        $this->start_controls_tab('tab_image_normal',
            [
            'label' => esc_html__('Normal', 'syron'),
        ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'image_overlay_color',
                'label' => esc_html__('Overlay Color', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .image-wrapper::before',
            ]
        );

	    $this->add_control(
		    'image_overlay_height',
		    [
			    'label'     => esc_html__( 'Overlay Height', 'syron' ),
			    'type'      => Controls_Manager::SLIDER,
			    'range'     => [
				    'px' => [
					    'min' => 0,
					    'max' => 100,
				    ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .image-wrapper::before' => 'height: {{SIZE}}%;',
			    ],
		    ]
	    );


        $this->add_group_control(
             Group_Control_Border::get_type(),
            [
            'name' => 'image_border',
            'selector' => '{{WRAPPER}} .image-wrapper',
        ]);

        $this->add_control('image_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'image_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .image-wrapper' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('image_border_radius',
            [
            'label' => esc_html__('Border Radius', 'syron'),
            'type' => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .image-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
            'name' => 'image_box_shadow',
            'selector' => '{{WRAPPER}} .image-wrapper',
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_image_hover',
            [
            'label' => esc_html__('Hover', 'syron'),
        ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'image_overlay_hover_color',
                'label' => esc_html__('Overlay Color', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .image-wrapper:hover::before',
            ]
        );

	    $this->add_control(
		    'image_overlay_hover_height',
		    [
			    'label'     => esc_html__( 'Overlay Height', 'syron' ),
			    'type'      => Controls_Manager::SLIDER,
			    'range'     => [
				    'px' => [
					    'min' => 0,
					    'max' => 100,
				    ],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .image-wrapper:hover::before' => 'height: {{SIZE}}%;',
			    ],
		    ]
	    );

        $this->add_control('image_hover_border_color',
            [
            'label' => esc_html__('Border Color', 'syron'),
            'type' => Controls_Manager::COLOR,
            'condition' => [
                'image_border_border!' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .image-wrapper:hover' => 'border-color: {{VALUE}};',
            ],
        ]);

        $this->add_control('image_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'image_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .image-wrapper:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
             Group_Control_Box_Shadow::get_type(),
             [
            'name' => 'image_hover_box_shadow',
            'selector' => '{{WRAPPER}} .image-wrapper:hover',
        ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_control(
            'image_svg_cover_heading',
            [
                'label'     => esc_html__( 'Svg Cover', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_image_svg_cover' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'image_svg_cover_height',
            [
                'label'     => esc_html__( 'Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 20,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .svg-cover' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_image_svg_cover' => 'yes',
                ],
            ]
        );

        $this->add_control('image_svg_cover_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'show_image_svg_cover' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .svg-cover' => 'fill: {{VALUE}};',
                ],
            ]);

        $this->add_control('image_svg_cover_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'show_image_svg_cover' => 'yes',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .svg-cover' => 'fill: {{VALUE}};',
                ],
            ]);


        $this->end_controls_section();

        $this->start_controls_section('section_style_content',
            [
                'label' => esc_html__('Content', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


	    $this->add_responsive_control('content_padding',
		    [
			    'label' => esc_html__('Padding', 'syron'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'size_units' => ['px', '%'],
			    'selectors' => [
				    '{{WRAPPER}} .content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]);

        $this->add_responsive_control('content_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);


        $this->start_controls_tabs('tabs_content_style');

        $this->start_controls_tab('tab_content_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .content-wrapper',
            ]
        );

        $this->add_control(
            'heading_content_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_bg_dark_mode',
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .content-wrapper',
            ]
        );

        $this->add_responsive_control('content_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_box_shadow',
                'selector' => '{{WRAPPER}} .content-wrapper',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_content_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_hover_background',
                'label' => esc_html__('Background', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .post-wrapper:hover .content-wrapper',
            ]
        );

        $this->add_control(
            'heading_content_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_hover_bg_dark_mode',
                'label' => esc_html__('Background', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .post-wrapper:hover .content-wrapper',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_hover_box_shadow',
                'selector' => '{{WRAPPER}} .post-wrapper:hover .content-wrapper',
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();



        $this->start_controls_section('section_style_top_content',
            [
                'label' => esc_html__('Top Content', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_top_content' => 'yes',
                ],
            ]);


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'top_content_background',
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .top-content',
            ]
        );

        $this->add_control('top_content_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .top-content, .top-content a' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'top_content_border',
                'selector' => '{{WRAPPER}} .top-content',
            ]);

        $this->add_responsive_control('top_content_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .top-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'top_content_shadow',
                'selector' => '{{WRAPPER}} .top-content',
            ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'top_content_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .top-content',
            ]);

        $this->end_controls_section();

    }


    protected function register_controls() {

        $this->register_layout_controls();
        $this->register_query_builder_controls();
        $this->register_post_controls();
        $this->register_pagination_controls();
        $this->register_carousel_controls();
        $this->register_carousel_nav_controls();

        $this->register_style_post_controls();
	    $this->register_style_post_date_controls();
	    $this->register_style_post_counter_controls();
        $this->register_style_title_controls();
        $this->register_style_terms_controls();
        $this->register_style_meta_controls();
        $this->register_style_excerpt_controls();
        $this->register_style_post_format_icon_controls();
        $this->register_style_pagination_controls();
        $this->register_style_carousel_nav_controls();

    }



    protected function render_top_content() {
        if ( !$this->get_settings( 'show_top_content' ) ) {
            return;
        }

        $settings = $this->get_settings_for_display();
        ?>
        <div class="top-content">
            <?php if( $settings['top_content_comments'] ): ?>
            <span class="top-comments" title="<?php esc_attr_e('Comments', 'syron') ?>"><i class="ri-chat"></i><?php echo get_comments_number(); ?></span>
            <?php endif; ?>

            <?php if( $settings['top_content_views'] ): ?>
                <span class="top-views" title="<?php esc_attr_e('Views', 'syron') ?>"><i class="ri-fire"></i><?php echo rivax_get_post_views(get_the_ID()); ?></span>
            <?php endif; ?>

            <?php if( $settings['top_content_reading_time'] ): ?>
                <span class="top-reading-time" title="<?php esc_attr_e('Reading Time', 'syron') ?>"><i class="ri-clock"></i><?php echo rivax_get_reading_time(); ?></span>
            <?php endif; ?>
        </div>
        <?php
    }



    // Overwrite global register_date_controls()
    protected function register_date_controls() {

        $this->add_control(
            'show_date',
            [
                'label'     => esc_html__( 'Date', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'meta_date_position',
            [
                'label'   => esc_html__( 'Position', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'inline',
                'options' => [
                    'inline'              => esc_html__( 'Inline', 'syron' ),
                    'inside-image'         => esc_html__( 'Inside Image', 'syron' ),
                ],
                'condition' => [
                    'show_date' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_date_icon',
            [
                'label'     => esc_html__( 'Icon', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => [
                    'show_date' => 'yes',
                    'meta_date_position!' => ['inside-image'],
                ]
            ]
        );

        $this->add_control(
            'human_diff_time',
            [
                'label'     => esc_html__( 'Human Different Time', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => [
                    'show_date' => 'yes',
                    'meta_date_position!' => ['inside-image'],
                ]
            ]
        );

        $this->add_control(
            'show_time',
            [
                'label'     => esc_html__( 'Show Time', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => [
                    'human_diff_time' => '',
                    'show_date'       => 'yes',
                    'meta_date_position!' => ['inside-image'],
                ]
            ]
        );

        $this->add_control(
            'date_inside_image_position',
            [
                'label'     => esc_html__( 'Image Date Position', 'syron' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'top-left'          => esc_html__( 'Top Left', 'syron' ),
                    'top-right'         => esc_html__( 'Top Right', 'syron' ),
                    'bottom-left'       => esc_html__( 'Bottom Left', 'syron' ),
                    'bottom-right'      => esc_html__( 'Bottom Right', 'syron' ),
                ],
                'default'   => 'bottom-right',
                'condition' => [
                    'show_date' => 'yes',
                    'meta_date_position' => 'inside-image',
                ]
            ]
        );

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}