<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Profile_Card_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-profile-card';
    }

    public function get_title() {
        return esc_html__('Profile Card', 'syron');
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__( 'General', 'syron' ),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__( 'Image', 'syron' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'exclude' => ['custom'],
                'default' => 'rivax-small-tall',
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'              => esc_html__( 'Layout', 'syron' ),
                'type'               => Controls_Manager::SELECT,
                'default'            => '1',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                ],
            ]
        );

        $this->add_responsive_control(
            'max_width',
            [
                'label'     => esc_html__( 'Max Width', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 100,
                        'max' => 800,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-profile-card' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout!' => ['5'],
                ],
            ]
        );

        $this->add_responsive_control(
            'image_height',
            [
                'label'     => esc_html__( 'Image Height', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 100,
                        'max' => 800,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .rivax-profile-card.layout-5 .image-wrapper' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_animation',
            [
                'label'     => esc_html__( 'Image Animation', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'syron' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
                'default' => esc_html__( 'Rivax Studio', 'syron' ),
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__( 'Subtitle', 'syron' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__( 'Creative Web Designer', 'syron' ),
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'syron' ),
                'type' => Controls_Manager::URL,
                'placeholder' => 'https://example.com/',
            ]
        );

        $this->add_control(
            'content_align',
            [
                'label' => esc_html__( 'Alignment', 'syron' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_image',
            [
                'label' => esc_html__( 'Image', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control('image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .image-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'selector' => '{{WRAPPER}} .image-wrapper',
            ]);

        $this->start_controls_tabs('tabs_image_style');
        $this->start_controls_tab('tab_image_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'selector' => '{{WRAPPER}} .image-wrapper',
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'image_overlay',
                'label' => esc_html__('Overlay', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .image-wrapper::after',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('tab_image_dark_mode',
            [
                'label' => esc_html__('Dark Mode', 'syron'),
            ]);

        $this->add_control('image_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'image_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .image-wrapper' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_content',
            [
                'label' => esc_html__( 'Content', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control('content_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('content_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_responsive_control('content_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_control(
            'content_blur_bg',
            [
                'label'         => esc_html__( 'Blur Background', 'syron' ),
                'description'   => esc_html__( 'Need a low opacity background.', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .content-wrapper' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_content_style');
        $this->start_controls_tab('tab_content_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_bg',
                'label' => esc_html__('Background', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .content-wrapper',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('tab_content_dark_mode',
            [
                'label' => esc_html__('Dark Mode', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_bg_dark_mode',
                'label' => esc_html__('Background', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .content-wrapper',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'heading_title_style',
            [
                'label'     => esc_html__( 'Title', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .title-wrap',
            ]);

        $this->add_control('title_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-wrap' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .title-wrap' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control(
            'heading_subtitle_style',
            [
                'label'     => esc_html__( 'Subtitle', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .subtitle-wrap',
            ]);

        $this->add_control('subtitle_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .subtitle-wrap' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('subtitle_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .subtitle-wrap' => 'color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_animation',
            [
                'label' => esc_html__( 'Animation', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => ['5'],
                ],
            ]
        );

        $this->add_control('animation_color1',
            [
                'label' => esc_html__('Color 1', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .face.face1' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'layout' => ['5'],
                ],
            ]);

        $this->add_control('animation_color2',
            [
                'label' => esc_html__('Color 2', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .face.face2' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'layout' => ['5'],
                ],
            ]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}