<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Search_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-search';
    }

    public function get_title() {
        return esc_html__('Search', 'syron');
    }

    public function get_icon() {
        return 'eicon-search';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('Settings', 'syron'),
            ]
        );

        $this->add_control(
            'search_type',
            [
                'label' => esc_html__( 'Search Type', 'syron' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'popup',
                'options' => [
                    'popup'  => esc_html__( 'Popup', 'syron' ),
                    'inline' => esc_html__( 'Inline', 'syron' ),
                ],
            ]
        );

        $this->add_control(
            'popup_style',
            [
                'label' => esc_html__( 'Popup Style', 'syron' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                    'style-1'  => esc_html__( 'Style 1', 'syron' ),
                    'style-2'  => esc_html__( 'Style 2', 'syron' ),
                ],
                'condition' => ['search_type' => 'popup'],
            ]
        );

        $this->add_control(
            'submit_icon',
            [
                'label' => esc_html__( 'Submit Icon', 'syron' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'submit_title',
            [
                'label' => esc_html__( 'Submit Title', 'syron' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		
		$this->add_control(
		    'placeholder_text',
		    [
			    'label' => esc_html__( 'Placeholder', 'syron' ),
			    'type' => Controls_Manager::TEXT,
		    ]
	    );

	    $this->add_control(
		    'popup_title',
		    [
			    'label' => esc_html__( 'Title', 'syron' ),
			    'type' => Controls_Manager::TEXT,
			    'condition' => ['search_type' => 'popup'],
		    ]
	    );	    

        $this->add_responsive_control(
            'text_align', [
                'label' => esc_html__('Alignment', 'syron'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [

                    'left' => [
                        'title' => esc_html__('Left', 'syron'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'syron'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'syron'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener-wrapper' => 'justify-content: {{VALUE}};',
                    '{{WRAPPER}} .inline-search-form' => 'text-align: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'popular_search',
            [
                'label' => esc_html__( 'Popular Search', 'syron' ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'popular_search_title',
            [
                'label' => esc_html__( 'Title', 'syron' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Popular Searches:', 'syron' ),
                'condition' => ['popular_search' => 'yes'],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'popular_keyword',
            [
                'label' => esc_html__( 'Keyword', 'syron' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

	    $repeater->add_control(
		    'popular_keyword_color',
		    [
			    'label' => esc_html__( 'Color', 'syron' ),
			    'type' => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} {{CURRENT_ITEM}}' => '--keyword-color: {{VALUE}};',
			    ],
		    ]
	    );

        $this->add_control(
            'popular_keywords',
            [
                'label' => esc_html__( 'Popular Search Keywords', 'syron' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ popular_keyword }}}',
                'prevent_empty' => false,
                'fields' => $repeater->get_controls(),
                'condition' => ['popular_search' => 'yes'],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_form',
            [
                'label' => esc_html__('Form', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'form_width',
            [
                'label' => esc_html__('Max Width', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-search-form' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'form_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .search-field' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'form_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .search-field' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'form_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-field' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'form_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .search-field' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'form_placeholder_color',
            [
                'label' => esc_html__('Placeholder Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-field::-webkit-input-placeholder, {{WRAPPER}} .search-field::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'label' => esc_html__( 'Border', 'syron' ),
                'selector' => '{{WRAPPER}} .search-field',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'form_search_field_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .search-field',
            ]);


        $this->start_controls_tabs('form_tabs');
        $this->start_controls_tab(
            'form_tab_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]
        );

        $this->add_control(
            'form_border_color_dark_mode',
            [
                'label'     => esc_html__( 'Border Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .search-field' => 'border-color: {{VALUE}};'
                ],
                'condition' => [
                    'form_border_border!' => ''
                ]
            ]
        );

        $this->add_control(
            'form_bg',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-field' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'form_bg_dark_mode',
            [
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .search-field' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'label' => esc_html__( 'Box Shadow', 'syron' ),
                'selector' => '{{WRAPPER}} .search-field',
            ]
        );


        $this->end_controls_tab();

        $this->start_controls_tab(
            'form_tab_focus',
            [
                'label' => esc_html__('Focus', 'syron'),
            ]
        );

        $this->add_control(
            'form_focus_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .search-field:focus' => 'border-color: {{VALUE}};'
                ],
                'condition' => [
                    'form_border_border!' => ''
                ]
            ]
        );

        $this->add_control(
            'form_focus_border_color_dark_mode',
            [
                'label'     => esc_html__( 'Border Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .search-field:focus' => 'border-color: {{VALUE}};'
                ],
                'condition' => [
                    'form_border_border!' => ''
                ]
            ]
        );

        $this->add_control(
            'form_focus_bg',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-field:focus' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'form_focus_bg_dark_mode',
            [
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .search-field:focus' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_focus_box_shadow',
                'label' => esc_html__( 'Box Shadow', 'syron' ),
                'selector' => '{{WRAPPER}} .search-field:focus',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();



        $this->start_controls_section(
            'section_style_submit',
            [
                'label' => esc_html__('Submit', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'submit_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .submit' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'submit_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .submit' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'submit_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'submit_font_size',
            [
                'label' => esc_html__('Font Size', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .submit' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'submit_border',
                'label' => esc_html__( 'Border', 'syron' ),
                'selector' => '{{WRAPPER}} .submit',
            ]
        );

        $this->add_control(
            'submit_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .submit' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'submit_border_border!' => ''
                ]
            ]
        );


        $this->start_controls_tabs('submit_tabs');
        $this->start_controls_tab(
            'submit_tab_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]
        );

        $this->add_control(
            'submit_bg',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .submit' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submit_bg_dark_mode',
            [
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .submit' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submit_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .submit' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submit_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .submit' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'submit_box_shadow',
                'label' => esc_html__( 'Box Shadow', 'syron' ),
                'selector' => '{{WRAPPER}} .submit',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'submit_tab_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]
        );

        $this->add_control(
            'submit_bg_hover',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .submit:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submit_bg_hover_dark_mode',
            [
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .submit:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submit_color_hover',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .submit:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submit_color_hover_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .submit:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'submit_border_color_hover',
            [
                'label'     => esc_html__( 'Border Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .submit:hover' => 'border-color: {{VALUE}};'
                ],
                'condition' => [
                    'submit_border_border!' => ''
                ]
            ]
        );

        $this->add_control(
            'submit_border_color_hover_dark_mode',
            [
                'label'     => esc_html__( 'Border Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .submit:hover' => 'border-color: {{VALUE}};'
                ],
                'condition' => [
                    'submit_border_border!' => ''
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'submit_box_shadow_hover',
                'label' => esc_html__( 'Box Shadow', 'syron' ),
                'selector' => '{{WRAPPER}} .submit:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_opener',
            [
                'label' => esc_html__('Opener', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['search_type' => 'popup'],
            ]
        );

        $this->add_control(
            'opener_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'opener_margin',
            [
                'label' => esc_html__('Margin', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'opener_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'syron' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'opener_font_size',
            [
                'label' => esc_html__('Font Size', 'syron'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'opener_border',
                'label' => esc_html__( 'Border', 'syron' ),
                'selector' => '{{WRAPPER}} .popup-search-opener',
            ]
        );

        $this->add_control(
            'opener_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .popup-search-opener' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'opener_border_border!' => ''
                ]
            ]
        );


        $this->start_controls_tabs('opener_tabs');
        $this->start_controls_tab(
            'opener_tab_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]
        );

        $this->add_control(
            'opener_bg',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'opener_bg_dark_mode',
            [
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .popup-search-opener' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'opener_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'opener_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .popup-search-opener' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'opener_box_shadow',
                'label' => esc_html__( 'Box Shadow', 'syron' ),
                'selector' => '{{WRAPPER}} .popup-search-opener',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'opener_tab_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]
        );

        $this->add_control(
            'opener_bg_hover',
            [
                'label' => esc_html__('Background', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'opener_bg_hover_dark_mode',
            [
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .popup-search-opener:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'opener_color_hover',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'opener_color_hover_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .popup-search-opener:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'opener_border_color_hover',
            [
                'label'     => esc_html__( 'Border Color', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener:hover' => 'border-color: {{VALUE}};'
                ],
                'condition' => [
                    'opener_border_border!' => ''
                ]
            ]
        );

        $this->add_control(
            'opener_border_color_hover_dark_mode',
            [
                'label'     => esc_html__( 'Border Color - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .popup-search-opener:hover' => 'border-color: {{VALUE}};'
                ],
                'condition' => [
                    'opener_border_border!' => ''
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'opener_box_shadow_hover',
                'label' => esc_html__( 'Box Shadow', 'syron' ),
                'selector' => '{{WRAPPER}} .popup-search-opener:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'section_popup_container_style',
            [
                'label' => esc_html__('Popup Container', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['search_type' => 'popup'],
            ]
        );

        $this->add_control(
            'heading_popup_container',
            [
                'label'     => esc_html__( 'Container', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'popup_container_bg',
                'label' => esc_html__('Background', 'syron'),
                'selector' => '{{WRAPPER}} .popup-search .popup-search-container',
            ]
        );

        $this->add_control(
            'heading_popup_container_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'popup_container_bg_dark_mode',
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .popup-search .popup-search-container',
            ]
        );

        $this->add_control(
            'heading_popup_container_close',
            [
                'label'     => esc_html__( 'Close Button', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'popup_container_Close_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-close' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'popup_container_Close_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .popup-search-close' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'heading_popup_container_title',
            [
                'label'     => esc_html__( 'Title', 'syron' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'popup_container_title_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-title-wrapper h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'popup_container_title_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .popup-search-title-wrapper h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'popup_container_title_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .popup-search-title-wrapper h3',
            ]);

        $this->end_controls_section();


    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}