<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Social_Icons_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-social-icons';
    }

    public function get_title() {
        return esc_html__('Social Icons', 'syron');
    }

    public function get_icon() {
        return 'eicon-social-icons';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }



    protected function register_controls() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'icon_position',
            [
                'label'   => esc_html__( 'Icon Position', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'left',
                'options' => [
                    'left'              => esc_html__( 'Left', 'syron' ),
                    'top'            => esc_html__( 'Top', 'syron' ),
                ],
                'prefix_class' => 'social-icon-',
            ]
        );

        $this->add_control(
            'subtitle_position',
            [
                'label'   => esc_html__( 'Subtitle Position', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'right',
                'options' => [
                    'right'              => esc_html__( 'Right', 'syron' ),
                    'bottom'            => esc_html__( 'Bottom', 'syron' ),
                ],
                'prefix_class' => 'social-subtitle-',
            ]
        );

        $this->add_control(
            'display_type',
            [
                'label'   => esc_html__( 'Display', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid'               => esc_html__( 'Grid', 'syron' ),
                    'inline'            => esc_html__( 'Inline', 'syron' ),
                ],
                'prefix_class' => 'social-layout-',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label'              => esc_html__( 'Columns', 'syron' ),
                'type'               => Controls_Manager::SELECT,
                'default'            => '2',
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-social-icons' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
                ],
                'condition' => [
                    'display_type' => 'grid'
                ]
            ]
        );


        $this->add_responsive_control(
            'align_content',
            [
                'label'     => esc_html__( 'Content Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-social-icons' => 'justify-content: {{VALUE}};',
                ],
                'condition' => [
                    'display_type' => 'inline'
                ]
            ]
        );


        $this->add_responsive_control(
            'column_gap',
            [
                'label'     => esc_html__( 'Column Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '10',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-social-icons' => 'column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'     => esc_html__( 'Row Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => '10',
                ],
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-social-icons' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'section_social_icons',
            [
                'label' => esc_html__( 'Social Icons', 'syron' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'move_up_animation',
            [
                'label'   => esc_html__( 'Move Up Animation', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'item',
                'options' => [
                    'none'               => esc_html__( 'None', 'syron' ),
                    'icon'            => esc_html__( 'Social Icon', 'syron' ),
                    'item'            => esc_html__( 'Social Item', 'syron' ),
                ],
                'prefix_class' => 'social-move-up-',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'social_icon',
            [
                'label' => esc_html__( 'Icon', 'syron' ),
                'type' => Controls_Manager::ICONS,
                'recommended' => [
                    'fa-brands' => [
                        'dribbble',
                        'facebook-f',
                        'github',
                        'instagram',
                        'linkedin-in',
                        'pinterest-p',
                        'stack-overflow',
                        'telegram-plane',
                        'tiktok',
                        'tumblr',
                        'vimeo-v',
                        'youtube',
                        'whatsapp',
                        'behance',
                        'soundcloud',
                        'x-twitter',
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'social_link',
            [
                'label'      => esc_html__( 'Link', 'syron' ),
                'type'       => Controls_Manager::TEXT,
                'input_type' => 'url',
            ]
        );

        $repeater->add_control(
            'social_title',
            [
                'label' => esc_html__( 'Title', 'syron' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'social_subtitle',
            [
                'label' => esc_html__( 'Sub Title', 'syron' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'social_color',
            [
                'label' => esc_html__( 'Color', 'syron' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.social-item' => '--social-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'social_media_items',
            [
                'label' => esc_html__( 'Social Media Items', 'syron' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );


        $this->end_controls_section();




        $this->start_controls_section('section_style_official',
            [
                'label' => esc_html__('Official Color', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]);

        $this->add_control(
            'official_icon_heading',
            [
                'label'     => esc_html__( 'Icon', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->start_controls_tabs('tabs_official_icon_style');

        $this->start_controls_tab('tab_official_icon_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control(
            'official_icon_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-icon-color-',
            ]
        );

        $this->add_control(
            'official_icon_bg',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-icon-bg-',
            ]
        );

        $this->add_control(
            'official_icon_shadow',
            [
                'label'     => esc_html__( 'Shadow', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-icon-shadow-',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('tab_official_icon_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_control(
            'official_icon_hover_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-icon-hover-color-',
            ]
        );

        $this->add_control(
            'official_icon_hover_bg',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-icon-hover-bg-',
            ]
        );

        $this->add_control(
            'official_icon_hover_shadow',
            [
                'label'     => esc_html__( 'Shadow', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-icon-hover-shadow-',
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();



        $this->add_control(
            'official_item_heading',
            [
                'label'     => esc_html__( 'Item', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->start_controls_tabs('tabs_official_item_style');

        $this->start_controls_tab('tab_official_item_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control(
            'official_item_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-item-color-',
            ]
        );

        $this->add_control(
            'official_item_bg',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-item-bg-',
            ]
        );

        $this->add_control(
            'official_item_shadow',
            [
                'label'     => esc_html__( 'Shadow', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-item-shadow-',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('tab_official_item_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_control(
            'official_item_hover_color',
            [
                'label'     => esc_html__( 'Color', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-item-hover-color-',
            ]
        );

        $this->add_control(
            'official_item_hover_bg',
            [
                'label'     => esc_html__( 'Background', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-item-hover-bg-',
            ]
        );

        $this->add_control(
            'official_item_hover_shadow',
            [
                'label'     => esc_html__( 'Shadow', 'syron' ),
                'type'      => Controls_Manager::SWITCHER,
                'prefix_class' => 'official-item-hover-shadow-',
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();




        $this->start_controls_section('section_style_item',
            [
                'label' => esc_html__('Item', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('item_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .social-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);


        $this->start_controls_tabs('tabs_item_style');

        $this->start_controls_tab('tab_item_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'label' => esc_html__('background', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .social-item',
            ]
        );

        $this->add_control(
            'heading_item_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_dark_mode',
                'label' => esc_html__('background - Dark Mode', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .social-item',
            ]
        );


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .social-item',
            ]);

        $this->add_control('item_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .social-item' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('item_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .social-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'selector' => '{{WRAPPER}} .social-item',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_item_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_hover_background',
                'label' => esc_html__('Background', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .social-item:hover',
            ]
        );

        $this->add_control(
            'heading_item_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_hover_bg_dark_mode',
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .social-item:hover',
            ]
        );


        $this->add_control('item_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-item:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('item_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .social-item:hover' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_hover_box_shadow',
                'selector' => '{{WRAPPER}} .social-item:hover',
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();



        $this->end_controls_section();



        $this->start_controls_section('section_style_icon',
            [
                'label' => esc_html__('Icon', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('icon_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_control(
            'icon_spacing',
            [
                'label'     => esc_html__( 'Spacing', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-item' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_size',
            [
                'label'     => esc_html__( 'Size', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_width',
            [
                'label'     => esc_html__( 'Width', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->start_controls_tabs('tabs_icon_style');

        $this->start_controls_tab('tab_icon_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control('icon_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('icon_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .icon' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_background',
                'label' => esc_html__('Background', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .icon',
            ]
        );

        $this->add_control(
            'heading_icon_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bg_dark_mode',
                'label' => esc_html__('Background - Dark Mode', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .icon',
            ]
        );


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .icon',
            ]);

        $this->add_control('icon_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'icon_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .icon' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_responsive_control('icon_border_radius',
            [
                'label' => esc_html__('Border Radius', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_box_shadow',
                'selector' => '{{WRAPPER}} .icon',
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_icon_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_control('icon_hover_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-item:hover .icon' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('icon_hover_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .social-item:hover .icon' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_hover_background',
                'label' => esc_html__('background', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .social-item:hover .icon',
            ]
        );

        $this->add_control(
            'heading_icon_hover_bg_dark_mode',
            [
                'label'     => esc_html__( 'Background - Dark Mode', 'syron' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_hover_bg_dark_mode',
                'label' => esc_html__('background - Dark Mode', 'syron'),
                'exclude' => [ 'image' ],
                'selector' => 'html[scheme="dark"] {{WRAPPER}} .social-item:hover .icon',
            ]
        );


        $this->add_control('icon_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'icon_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-item:hover .icon' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('icon_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'icon_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .social-item:hover .icon' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_hover_box_shadow',
                'selector' => '{{WRAPPER}} .social-item:hover .icon',
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();




        $this->start_controls_section('section_style_title',
            [
                'label' => esc_html__('Title', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('title_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .title',
            ]);


        $this->start_controls_tabs('tabs_title_style');

        $this->start_controls_tab('tab_title_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control('title_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .title',
            ]);

        $this->add_control('title_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'title_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .title' => 'border-color: {{VALUE}};',
                ],
            ]);


        $this->end_controls_tab();

        $this->start_controls_tab('tab_title_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_control('title_hover_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-item:hover .title' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_hover_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .social-item:hover .title' => 'color: {{VALUE}};',
                ],
            ]);


        $this->add_control('title_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'title_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-item:hover .title' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('title_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'title_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .social-item:hover .title' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section('section_style_subtitle',
            [
                'label' => esc_html__('Subtitle', 'syron'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_padding',
            [
                'label' => esc_html__('Padding', 'syron'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

        $this->add_control(
            'subtitle_spacing',
            [
                'label'     => esc_html__( 'Spacing', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-content' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'label' => esc_html__('Typography', 'syron'),
                'selector' => '{{WRAPPER}} .subtitle',
            ]);


        $this->start_controls_tabs('tabs_subtitle_style');

        $this->start_controls_tab('tab_subtitle_normal',
            [
                'label' => esc_html__('Normal', 'syron'),
            ]);

        $this->add_control('subtitle_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .subtitle' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('subtitle_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .subtitle' => 'color: {{VALUE}};',
                ],
            ]);


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'subtitle_border',
                'selector' => '{{WRAPPER}} .subtitle',
            ]);

        $this->add_control('subtitle_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'subtitle_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .subtitle' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_subtitle_hover',
            [
                'label' => esc_html__('Hover', 'syron'),
            ]);

        $this->add_control('subtitle_hover_color',
            [
                'label' => esc_html__('Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-item:hover .subtitle' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('subtitle_hover_color_dark_mode',
            [
                'label' => esc_html__('Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .social-item:hover .subtitle' => 'color: {{VALUE}};',
                ],
            ]);

        $this->add_control('subtitle_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'subtitle_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-item:hover .subtitle' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->add_control('subtitle_hover_border_color_dark_mode',
            [
                'label' => esc_html__('Border Color - Dark Mode', 'syron'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'subtitle_border_border!' => '',
                ],
                'selectors' => [
                    'html[scheme="dark"] {{WRAPPER}} .social-item:hover .subtitle' => 'border-color: {{VALUE}};',
                ],
            ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();


    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}