<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class Rivax_Tag_Cloud_Widget extends Widget_Base {

    public function get_name() {
        return 'rivax-tag-cloud';
    }

    public function get_title() {
        return esc_html__('Tag cloud', 'syron');
    }

    public function get_icon() {
        return 'eicon-tags';
    }

    protected function get_html_wrapper_class() {
        return $this->get_name() . '-widget';
    }

    public function get_categories() {
        return ['rivax-elements'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'syron' ),
            ]
        );


        $this->add_responsive_control(
            'column_gap',
            [
                'label'     => esc_html__( 'Column Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-tag-cloud' => 'column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label'     => esc_html__( 'Row Gap', 'syron' ),
                'type'      => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-tag-cloud' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label'     => esc_html__( 'Alignment', 'syron' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'syron' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'syron' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'syron' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                    'space-between'  => [
                        'title' => esc_html__( 'justify', 'syron' ),
                        'icon'  => 'eicon-text-align-justify',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .rivax-tag-cloud' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_query',
            [
                'label' => esc_html__( 'Query', 'syron' ),
            ]
        );

        $this->add_control(
            'item_limit',
            [
                'label' => esc_html__('Item Limit', 'syron'),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
            ]
        );

        $this->add_control(
            'taxonomy',
            [
                'label'   => esc_html__( 'Taxonomy', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'category',
                'options' => [
                    'post_tag'       => esc_html__( 'Tags', 'syron' ),
                    'category'  => esc_html__('Categories', 'syron'),
                ],
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label'   => esc_html__( 'Order By', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'name',
                'options' => [
                    'name'       => esc_html__( 'Name', 'syron' ),
                    'id'  => esc_html__('ID', 'syron'),
                    'count'  => esc_html__('Post Count', 'syron'),
                ],
            ]
        );



        $this->add_control(
            'order',
            [
                'label'   => esc_html__( 'Order', 'syron' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'asc',
                'options' => [
                    'asc'  => esc_html__( 'ASC', 'syron' ),
                    'desc' => esc_html__( 'DESC', 'syron' ),
                ],
            ]
        );

        $this->add_control(
            'include',
            [
                'label'       => esc_html__( 'Include', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Tag ID: 12,3,1', 'syron' ),
            ]
        );

        $this->add_control(
            'exclude',
            [
                'label'       => esc_html__( 'Exclude', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Tag ID: 12,3,1', 'syron' ),
            ]
        );

        $this->add_control(
            'parent',
            [
                'label'       => esc_html__( 'Parent', 'syron' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Tag ID: 12', 'syron' ),
            ]
        );

        $this->end_controls_section();

        //Style
        $this->start_controls_section(
            'section_style_items',
            [
                'label' => esc_html__( 'Items', 'syron' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

	    $this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
			    'name'     => 'category_name_typography',
			    'label'    => esc_html__( 'Typography', 'syron' ),
			    'selector' => '{{WRAPPER}} .rivax-tag-cloud-item',
		    ]
	    );

        $this->start_controls_tabs( 'tabs_item_style' );

        $this->start_controls_tab(
            'tab_item_normal',
            [
                'label' => esc_html__( 'Normal', 'syron' ),
            ]
        );

	    $this->add_control(
		    'category_name_color',
		    [
			    'label'     => esc_html__( 'Color', 'syron' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .rivax-tag-cloud-item' => '--body-color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'category_name_color_dark_mode',
		    [
			    'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    'html[scheme="dark"] {{WRAPPER}} .rivax-tag-cloud-item' => '--body-color: {{VALUE}};',
			    ],
		    ]
	    );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_item_hover',
            [
                'label' => esc_html__( 'Hover', 'syron' ),
            ]
        );

	    $this->add_control(
		    'category_name_color_hover',
		    [
			    'label'     => esc_html__( 'Color', 'syron' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .rivax-tag-cloud-item:hover' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'category_name_color_hover_dark_mode',
		    [
			    'label'     => esc_html__( 'Color - Dark Mode', 'syron' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    'html[scheme="dark"] {{WRAPPER}} .rivax-tag-cloud-item:hover' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $widget_path_name = str_replace('rivax-', '', $this->get_name() );
        include RIVAX_THEME_DIR . '/elementor/templates/' . $widget_path_name . '/' . $widget_path_name . '.php';
    }

}