<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$custom_css = '';

// Accent Colors
if(rivax_get_option('accent-color')) {
	$custom_css .= 'html .editor-styles-wrapper { --accent-color: ' . rivax_get_option('accent-color') . ';}';
}

if(rivax_get_option('second-color')) {
	$custom_css .= 'html .editor-styles-wrapper { --second-color: ' . rivax_get_option('second-color') . ';}';
}

if(rivax_get_option('body-bg')) {
    $custom_css .= 'html .editor-styles-wrapper { --body-bg-color: ' . rivax_get_option('body-bg') . ';}';
}

if(rivax_get_option('body-color')) {
    $custom_css .= 'html .editor-styles-wrapper { --body-color: ' . rivax_get_option('body-color') . ';}';
}

if(rivax_get_option('heading-color')) {
    $custom_css .= 'html .editor-styles-wrapper { --headings-color: ' . rivax_get_option('heading-color') . ';}';
}


/* Typography */
$body_font = rivax_get_option('typography-body')?: [];
if(count(array_filter($body_font)) > 1) {
	$custom_css .= 'html .editor-styles-wrapper {';

	if($body_font['font-family']) {
		$custom_css .= 'font-family: ' . $body_font['font-family'] . ',sans-serif;';
	}
	if($body_font['font-weight']) {
		$custom_css .= 'font-weight: ' . $body_font['font-weight'] . ';';
	}
	if($body_font['font-style']) {
		$custom_css .= 'font-style: ' . $body_font['font-style'] . ';';
	}
	if($body_font['letter-spacing']) {
		$custom_css .= 'letter-spacing: ' . $body_font['letter-spacing'] . ';';
	}
	if($body_font['line-height']) {
		$custom_css .= 'line-height: ' . $body_font['line-height'] . ';';
	}
	if($body_font['font-size']) {
		$custom_css .= 'font-size: ' . $body_font['font-size'] . ';';
	}

	$custom_css .= '}';
}

$heading_font = rivax_get_option('typography-heading')?: [];
if(count(array_filter($heading_font)) > 1) {
	$custom_css .= 'html .editor-styles-wrapper h1, html .editor-styles-wrapper h2, html .editor-styles-wrapper h3, html .editor-styles-wrapper h4, html .editor-styles-wrapper h5, html .editor-styles-wrapper h6, html .editor-styles-wrapper .h1, html .editor-styles-wrapper .h2, html .editor-styles-wrapper .h3, html .editor-styles-wrapper .h4, html .editor-styles-wrapper .h5, html .editor-styles-wrapper .h6 {';

	if($heading_font['font-family']) {
		$custom_css .= 'font-family: ' . $heading_font['font-family'] . ',sans-serif;';
	}
	if($heading_font['font-weight']) {
		$custom_css .= 'font-weight: ' . $heading_font['font-weight'] . ';';
	}
	if($heading_font['font-style']) {
		$custom_css .= 'font-style: ' . $heading_font['font-style'] . ';';
	}
	if($heading_font['letter-spacing']) {
		$custom_css .= 'letter-spacing: ' . $heading_font['letter-spacing'] . ';';
	}
	if($heading_font['line-height']) {
		$custom_css .= 'line-height: ' . $heading_font['line-height'] . ';';
	}

	$custom_css .= '}';
}


if(rivax_get_option('h1-font-size')) {
	$custom_css .= 'html .editor-styles-wrapper h1, html .editor-styles-wrapper .h1 { font-size: ' . rivax_get_option('h1-font-size') . ';}';
}

if(rivax_get_option('h2-font-size')) {
	$custom_css .= 'html .editor-styles-wrapper h2, html .editor-styles-wrapper .h2 { font-size: ' . rivax_get_option('h2-font-size') . ';}';
}

if(rivax_get_option('h3-font-size')) {
	$custom_css .= 'html .editor-styles-wrapper h3, html .editor-styles-wrapper .h3 { font-size: ' . rivax_get_option('h3-font-size') . ';}';
}

if(rivax_get_option('h4-font-size')) {
	$custom_css .= 'html .editor-styles-wrapper h4, html .editor-styles-wrapper .h4 { font-size: ' . rivax_get_option('h4-font-size') . ';}';
}

if(rivax_get_option('h5-font-size')) {
	$custom_css .= 'html .editor-styles-wrapper h5, html .editor-styles-wrapper .h5 { font-size: ' . rivax_get_option('h5-font-size') . ';}';
}

if(rivax_get_option('h6-font-size')) {
	$custom_css .= 'html .editor-styles-wrapper h6, html .editor-styles-wrapper .h6 { font-size: ' . rivax_get_option('h6-font-size') . ';}';
}