<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$custom_css = '';

// Set Container Width
$site_width = absint(rivax_get_option('site-width'));
if($site_width) {
    $custom_css .= ":root { --site-width: " . $site_width . "px; }";
}

// Accent Colors
if(rivax_get_option('accent-color')) {
    $custom_css .= ':root { --accent-color: ' . rivax_get_option('accent-color') . ';}';
}

if(rivax_get_option('second-color')) {
    $custom_css .= ':root { --second-color: ' . rivax_get_option('second-color') . ';}';
}

// Styling
if(rivax_get_option('body-bg')) {
    $custom_css .= ':root { --body-bg-color: ' . rivax_get_option('body-bg') . ';}';
}

if(rivax_get_option('body-color')) {
    $custom_css .= ':root { --body-color: ' . rivax_get_option('body-color') . ';}';
}

if(rivax_get_option('heading-color')) {
    $custom_css .= ':root { --headings-color: ' . rivax_get_option('heading-color') . ';}';
}

if(rivax_get_option('button-bg-hover')) {
    $custom_css .= ':root { --button-bg-hover: ' . rivax_get_option('button-bg-hover') . ';}';
}



// Dark Mode style
if(rivax_get_option('accent-color-dark')) {
    $custom_css .= 'html[scheme="dark"] { --accent-color: ' . rivax_get_option('accent-color-dark') . ';}';
}

if(rivax_get_option('second-color-dark')) {
    $custom_css .= 'html[scheme="dark"] { --second-color: ' . rivax_get_option('second-color-dark') . ';}';
}

if(rivax_get_option('body-bg-dark')) {
    $custom_css .= 'html[scheme="dark"] { --body-bg-color: ' . rivax_get_option('body-bg-dark') . ';}';
}

if(rivax_get_option('body-color-dark')) {
    $custom_css .= 'html[scheme="dark"] { --body-color: ' . rivax_get_option('body-color-dark') . ';}';
}

if(rivax_get_option('heading-color-dark')) {
    $custom_css .= 'html[scheme="dark"] { --headings-color: ' . rivax_get_option('heading-color-dark') . ';}';
}

if(rivax_get_option('button-bg-hover-dark')) {
    $custom_css .= 'html[scheme="dark"] { --button-bg-hover: ' . rivax_get_option('button-bg-hover-dark') . ';}';
}


/* Footer Elements */
if(rivax_get_option('footer-canvas-menu-bg')) {
    $custom_css .= '.footer-canvas-menu-bg { background: ' . rivax_get_option('footer-canvas-menu-bg') . ';}';
}

if(rivax_get_option('footer-canvas-menu-color')) {
    $custom_css .= '.footer-canvas-menu .rivax-header-v-nav li.menu-item a { color: ' . rivax_get_option('footer-canvas-menu-color') . ';}';
    $custom_css .= '.footer-canvas-menu-btn { color: ' . rivax_get_option('footer-canvas-menu-color') . ';}';
}

if(rivax_get_option('footer-canvas-menu-color-hover')) {
    $custom_css .= '.footer-canvas-menu .rivax-header-v-nav li.menu-item a:hover, .footer-canvas-menu .rivax-header-v-nav li.current-menu-item a { color: ' . rivax_get_option('footer-canvas-menu-color-hover') . ';}';
}


/* Typography */
$body_font = rivax_get_option('typography-body')?: [];
if(count(array_filter($body_font)) > 1) {
    $custom_css .= 'body {';

	if($body_font['font-family']) {
		$custom_css .= 'font-family: ' . $body_font['font-family'] . ',sans-serif;';
	}
	if($body_font['font-weight']) {
		$custom_css .= 'font-weight: ' . $body_font['font-weight'] . ';';
	}
	if($body_font['font-style']) {
		$custom_css .= 'font-style: ' . $body_font['font-style'] . ';';
	}
	if($body_font['letter-spacing']) {
		$custom_css .= 'letter-spacing: ' . $body_font['letter-spacing'] . ';';
	}
	if($body_font['line-height']) {
		$custom_css .= '--body-line-height: ' . $body_font['line-height'] . ';';
	}

	$custom_css .= '}';
}

if(!empty($body_font['font-size'])) {
    $custom_css .= 'html { font-size: ' . $body_font['font-size'] . ';}';
}

$heading_font = rivax_get_option('typography-heading')?: [];
if(count(array_filter($heading_font)) > 1) {
    $custom_css .= 'h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6 {';

	if($heading_font['font-family']) {
		$custom_css .= 'font-family: ' . $heading_font['font-family'] . ',sans-serif;';
	}
	if($heading_font['font-weight']) {
		$custom_css .= 'font-weight: ' . $heading_font['font-weight'] . ';';
	}
	if($heading_font['font-style']) {
		$custom_css .= 'font-style: ' . $heading_font['font-style'] . ';';
	}
	if($heading_font['letter-spacing']) {
		$custom_css .= 'letter-spacing: ' . $heading_font['letter-spacing'] . ';';
	}
	if($heading_font['line-height']) {
		$custom_css .= 'line-height: ' . $heading_font['line-height'] . ';';
	}

	$custom_css .= '}';
}


if(rivax_get_option('typography-terms', 'font-family')) {
	$custom_css .= '.term-item, .single-hero-title .category a {';

	$custom_css .= 'font-family: ' . rivax_get_option('typography-terms', 'font-family') . ',sans-serif;';

	if(rivax_get_option('typography-terms', 'font-weight')) {
		$custom_css .= 'font-weight: ' . rivax_get_option('typography-terms', 'font-weight') . ';';
	}
	if(rivax_get_option('typography-terms', 'font-style')) {
		$custom_css .= 'font-style: ' . rivax_get_option('typography-terms', 'font-style') . ';';
	}

	$custom_css .= '}';
}

if(rivax_get_option('typography-menu', 'font-family')) {
    $custom_css .= '.rivax-header-nav, .rivax-header-v-nav {';

    $custom_css .= 'font-family: ' . rivax_get_option('typography-menu', 'font-family') . ',sans-serif;';

    if(rivax_get_option('typography-menu', 'font-weight')) {
        $custom_css .= 'font-weight: ' . rivax_get_option('typography-menu', 'font-weight') . ';';
    }
    if(rivax_get_option('typography-menu', 'font-style')) {
        $custom_css .= 'font-style: ' . rivax_get_option('typography-menu', 'font-style') . ';';
    }

    $custom_css .= '}';
}

if(rivax_get_option('h1-font-size')) {
    $custom_css .= 'h1, .h1 { font-size: ' . rivax_get_option('h1-font-size') . ';}';
}

if(rivax_get_option('h2-font-size')) {
    $custom_css .= 'h2, .h2 { font-size: ' . rivax_get_option('h2-font-size') . ';}';
}

if(rivax_get_option('h3-font-size')) {
    $custom_css .= 'h3, .h3 { font-size: ' . rivax_get_option('h3-font-size') . ';}';
}

if(rivax_get_option('h4-font-size')) {
    $custom_css .= 'h4, .h4 { font-size: ' . rivax_get_option('h4-font-size') . ';}';
}

if(rivax_get_option('h5-font-size')) {
    $custom_css .= 'h5, .h5 { font-size: ' . rivax_get_option('h5-font-size') . ';}';
}

if(rivax_get_option('h6-font-size')) {
    $custom_css .= 'h6, .h6 { font-size: ' . rivax_get_option('h6-font-size') . ';}';
}


$custom_css .='@media screen and (max-width: 1024px) {';

if(rivax_get_option('h1-font-size-responsive')) {
    $custom_css .= 'h1, .h1 { font-size: ' . rivax_get_option('h1-font-size-responsive') . ';}';
}

if(rivax_get_option('h2-font-size-responsive')) {
    $custom_css .= 'h2, .h2 { font-size: ' . rivax_get_option('h2-font-size-responsive') . ';}';
}

if(rivax_get_option('h3-font-size-responsive')) {
    $custom_css .= 'h3, .h3 { font-size: ' . rivax_get_option('h3-font-size-responsive') . ';}';
}

if(rivax_get_option('h4-font-size-responsive')) {
    $custom_css .= 'h4, .h4 { font-size: ' . rivax_get_option('h4-font-size-responsive') . ';}';
}

if(rivax_get_option('h5-font-size-responsive')) {
    $custom_css .= 'h5, .h5 { font-size: ' . rivax_get_option('h5-font-size-responsive') . ';}';
}

if(rivax_get_option('h6-font-size-responsive')) {
    $custom_css .= 'h6, .h6 { font-size: ' . rivax_get_option('h6-font-size-responsive') . ';}';
}

$custom_css .='}';


/* Category Color */
$terms = get_terms(['fields' => 'ids', 'meta_key' => 'rivax_term_color', 'meta_value' => '', 'meta_compare' => '!=']);
foreach ($terms as $term) {
    $term_color = get_term_meta($term, 'rivax_term_color', true);
    if($term_color) {
        $custom_css .= '.term-id-' . $term . '{--term-color: ' . $term_color . ';}';
    }
}

/* custom CSS */
if(rivax_get_option('custom-css')) {
    $custom_css .= rivax_get_option('custom-css');
}