<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

// Add Favicon for AMP
add_action( 'amp_post_template_head', 'wp_site_icon');


// Replace author image
add_filter( 'pre_get_avatar', 'rivax_replace_author_avatar', 10, 3 );
function rivax_replace_author_avatar ($avatar, $id_or_email, $args) {

    if(isset($args["force_default"]) && $args["force_default"]) {
        return $avatar;
    }

	// Get user data.
	if ( is_numeric( $id_or_email ) ) {
		$user = get_user_by( 'id', (int) $id_or_email );
	}
	elseif ( is_object( $id_or_email ) ) {
		$comment = $id_or_email;
		if ( !empty( $comment->user_id ) ) {
			$user = get_user_by( 'id', $comment->user_id );
		} else {
			$user = get_user_by( 'email', $comment->comment_author_email );
		}
		if ( ! $user ) {
			return $avatar;
		}
	} elseif ( is_string( $id_or_email ) ) {
		$user = get_user_by( 'email', $id_or_email );
	} else {
		return $avatar;
	}

	if ( ! $user ) {
		return $avatar;
	}
	$user_id = $user->ID;


	$profile_image_id = intval(get_the_author_meta( 'rivax_author_profile_image_id', $user_id ));
	$profile_image_url = wp_get_attachment_image_url($profile_image_id);
	if($profile_image_url ) {
		return '<img class="avatar avatar-' . (int) $args['size'] . ' photo" src="' . esc_url($profile_image_url) . '" alt="' . esc_attr($user->display_name) . '" loading="lazy" width="' . $args['width'] . '" height="' . $args['height'] . '">';
	}

	return $avatar;

}



// Add class to body
add_filter('body_class', 'rivax_body_class');
function rivax_body_class($classes) {

	if(rivax_get_option('smooth-scroll')) {
		$classes[] = 'rivax-smooth-scroll';
	}

	return $classes;
}


// Add Theme Scheme to HTML tag
add_filter('language_attributes', 'rivax_theme_scheme');
function rivax_theme_scheme($output) {

	if( rivax_dark_mode_enabled() ) {
		$output .= ' scheme="' . rivax_current_theme_scheme() . '"';

		if(rivax_get_option('always-dark-mode')) {
			$output .= ' dark-theme=""';
		}
	}
	return $output;
}


// Full Size for Gif image thumbnail
add_filter('wp_get_attachment_image_src', 'rivax_full_size_gif_images', 10, 4);
function rivax_full_size_gif_images($image, $attachment_id, $size, $icon) {
	if( rivax_get_option('full-size-gif') && ! empty( $image[0] ) ) {

		$format = wp_check_filetype( $image[0] );

		if ( ! empty( $format ) && 'gif' == $format['ext'] && 'full' != $size ) {
			return wp_get_attachment_image_src( $attachment_id, 'full', $icon );
		}

	}

	return $image;
}



// Limit search for custom post types
add_filter('pre_get_posts','rivax_limit_search_post_types',100);
function rivax_limit_search_post_types ($query) {

	$post_types = rivax_get_option('search-post-types');

	if ( is_array($post_types) && count($post_types) && $query->is_search && $query->is_main_query() && !is_admin() ) {
		$query->set('post_type',$post_types);
	}

	return $query;
}
