<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

class Rivax_Theme_Setup {

    function __construct() {

        add_action( 'after_setup_theme', array( $this, 'theme_setup' ) );
        add_action( 'after_setup_theme', array( $this, 'load_translation' ),1 );
		add_action( 'wp_enqueue_scripts', array( $this, 'theme_scripts' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'elementor_styles' ) );        
        add_action( 'widgets_init', array( $this, 'theme_sidebars' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'default_theme_fonts' ) );
	    add_action('enqueue_block_assets', array( $this, 'default_theme_fonts' ), 90 );
        add_filter( 'theme_page_templates', array( $this, 'remove_redux_page_templates'), 11 );
        add_filter( 'theme_post_templates', array( $this, 'remove_redux_page_templates'), 11 );
        add_action( 'amp_post_template_head', array( $this, 'amp_fonts' ) );
        add_filter( 'amp_customizer_is_enabled', '__return_false' );

    }

    // Sets up theme defaults and registers support for various WordPress features.
    function theme_setup() {

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        // Let WordPress manage the document title.
        add_theme_support( 'title-tag' );

        // Enable woocommerce support
        add_theme_support( 'woocommerce' );
        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );

        // Enable support for Post Thumbnail
        add_theme_support( 'post-thumbnails' );

        add_image_size( 'rivax-small', 440, 310, true );
        add_image_size( 'rivax-small-tall', 440, 520, true );
        add_image_size( 'rivax-small-square', 440, 440, true );
        add_image_size( 'rivax-small-masonry', 440 );

        add_image_size( 'rivax-medium', 680, 450, true );
        add_image_size( 'rivax-medium-masonry', 680 );

        add_image_size( 'rivax-large', 960, 560, true );
        add_image_size( 'rivax-wide', 1380, 640, true );

        // Switch default core markup for search form, comment form, and comments to output valid HTML5.
        add_theme_support( 'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
            'script',
            'style',
        ) );

        // Enable support for Post Formats.
        add_theme_support( 'post-formats', array(
            'gallery',
            'video',
            'audio',
            'quote',
            'link',
        ) );


        // Add support for Block Styles.
        add_theme_support( 'wp-block-styles' );

        // Add support for full and wide align images.
        add_theme_support( 'align-wide' );

        // Add support for responsive embedded content.
        add_theme_support( 'responsive-embeds' );

        register_nav_menus(
            array(
                'primary_menu' => esc_html__( 'Primary menu', 'syron' ),
                'mobile_menu' => esc_html__( 'Mobile menu', 'syron' ),
                'amp_menu' => esc_html__( 'AMP menu', 'syron' ),
            )
        );


        if(is_admin()) {

            // Disable Default Colors
            if( get_option('elementor_disable_color_schemes') != 'yes' ) {
                update_option('elementor_disable_color_schemes', 'yes');
            }

            // Disable Default Fonts
            if( get_option('elementor_disable_typography_schemes') != 'yes' ) {
                update_option('elementor_disable_typography_schemes', 'yes');
            }
        }

        // Site width
        $GLOBALS['content_width'] = 860;

    }


    // Make theme available for translation.
    function load_translation () {

        load_theme_textdomain( 'syron', RIVAX_THEME_DIR . '/languages' );
    }

    // Get Custom Style
    function get_custom_style () {
        $custom_css = '';
        include_once RIVAX_THEME_DIR . '/inc/custom-style.php';
        return $custom_css;
    }


	// Default Theme Fonts
	function default_theme_fonts () {

		if( !rivax_get_option('typography-body', 'font-family') ) {
			$is_ssl = is_ssl() ? 'https' : 'http';

			$fonts_url = "$is_ssl://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap";

			wp_enqueue_style( 'rivax-body-font', $fonts_url, array(), null );
		}

		if( !rivax_get_option('typography-heading', 'font-family') ) {
            $is_ssl = is_ssl() ? 'https' : 'http';

            $fonts_url = "$is_ssl://fonts.googleapis.com/css2?family=Inter:wght@600;700&display=swap";

            wp_enqueue_style( 'rivax-heading-font', $fonts_url, array(), null );
        }

	}


    // AMP Fonts
    function amp_fonts () {

        $is_ssl = is_ssl() ? 'https' : 'http';

        $fonts_url = "$is_ssl://fonts.googleapis.com/css2?";

        $body_font_url = '';
        $heading_font_url = '';
        $body_font_family = rivax_get_option('typography-body', 'font-family');
        $heading_font_family = rivax_get_option('typography-heading', 'font-family');

        if( !$body_font_family ) {
            $body_font_url = 'family=Inter:wght@400;500;600;700';
        }
        else {
            $body_font_url = 'family=' . str_replace(' ', '+', $body_font_family);

            $body_font_weight = rivax_get_option('typography-body', 'font-weight');
            if( $body_font_weight ) {

                $body_font_style = rivax_get_option('typography-body', 'font-style');
                if( $body_font_style ) {
                    $body_font_url .=  ':' . $body_font_style . ',wght@' . $body_font_weight;
                }
                else {
                    $body_font_url .= ':wght@' . $body_font_weight;
                }

            }

        }


        if($heading_font_family) {
            $heading_font_url = 'family=' . str_replace(' ', '+', $heading_font_family);

            $heading_font_weight = rivax_get_option('typography-heading', 'font-weight');
            if( $heading_font_weight ) {

                $heading_font_style = rivax_get_option('typography-heading', 'font-style');
                if( $heading_font_style ) {
                    $heading_font_url .=  ':' . $heading_font_style . ',wght@' . $heading_font_weight;
                }
                else {
                    $heading_font_url .= ':wght@' . $heading_font_weight;
                }

            }
        }

        $fonts_url .= implode('&', array_filter([$body_font_url, $heading_font_url])) . '&display=swap';

        ?>
        <link rel="stylesheet" type="text/css" href="<?php echo esc_url($fonts_url); ?>">
        <?php

    }


    // Enqueues Theme Scripts And Styles.
    function theme_scripts() {

        // Styles
        wp_enqueue_style( 'rivax-icon', RIVAX_THEME_URI . '/assets/css/rivax-icon.css', array(), null );

        if( rivax_dark_mode_enabled() ) {
            wp_enqueue_style( 'dark-theme', RIVAX_THEME_URI . '/assets/css/dark-theme.css', array(), null );
        }

        wp_enqueue_style( 'rivax-theme-style', RIVAX_THEME_URI . '/style.css', array(), null );
        wp_add_inline_style( 'rivax-theme-style', $this->get_custom_style() );

		if( is_single() ) {
			wp_enqueue_style( 'rivax-single', RIVAX_THEME_URI . '/assets/css/single-post.css', array(), null );
		}
		
	    wp_enqueue_style( 'rivax-woocommerce', RIVAX_THEME_URI . '/assets/css/woocommerce.css', array('woocommerce-general'), null );


		// Load Elementor Swiper CSS
        if( is_single() && get_post_format() == 'gallery') {
            wp_enqueue_style('swiper');
            wp_enqueue_style('e-swiper');
        }
		
        // Scripts
	    wp_register_script( 'rivax-particles', RIVAX_THEME_URI . '/assets/js/particles.min.js', array('jquery'), null, true );

		if ( is_user_logged_in() ) { // Elementor Editor
		    wp_enqueue_script('rivax-particles');
	    }

	    if(rivax_get_option('smooth-scroll')) {
		    wp_enqueue_script( 'smooth-scroll', RIVAX_THEME_URI . '/assets/js/smooth-scroll.min.js', array(), '1.5.1', true );
	    }

	    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		    wp_enqueue_script( 'comment-reply' );
	    }

	    if(rivax_dark_mode_enabled()) {
		    wp_enqueue_script( 'rivax-head', RIVAX_THEME_URI . '/assets/js/head.js', array(), NULL );
	    }

        wp_enqueue_script( 'rivax-main-script', RIVAX_THEME_URI . '/assets/js/main.js', array( 'jquery' ), false, true );
        wp_localize_script( 'rivax-main-script', 'rivax_ajax_object',
            array(
                'AjaxUrl' => admin_url( 'admin-ajax.php' ),
            )
        );

    }
	
	
	// Enqueues Elementor Styles. Pre Render
    function elementor_styles() {

        if(!class_exists('Elementor\Plugin')){
            return;
        }

	    $elementor = \Elementor\Plugin::instance();
	    $elementor->frontend->enqueue_styles();

        $template_ids = array(
            rivax_get_layout_template_id('sidebar'),
            rivax_get_layout_template_id('footer'),
            rivax_get_layout_template_id('header'),
            rivax_get_layout_template_id('sticky_header'),
            rivax_get_layout_template_id('single_top_content'),
            rivax_get_layout_template_id('single_bottom_content'),
            rivax_get_layout_template_id('404'),
            rivax_get_layout_template_id('archive'),
        );
	    $template_ids = array_filter($template_ids);

        foreach ($template_ids as $template_id) {

	        // Load Elementor Widget Assets
	        if ( ! $elementor->preview->is_preview_mode() ) {
		        $page_assets = get_post_meta( $template_id, '_elementor_page_assets', true );
		        if ( ! empty( $page_assets ) ) {
			        $elementor->assets_loader->enable_assets( $page_assets );
		        }
	        }

	        // Load Post CSS
	        if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
		        $css_file = new \Elementor\Core\Files\CSS\Post( $template_id );
	        } elseif ( class_exists( '\Elementor\Post_CSS_File' ) ) {
		        $css_file = new \Elementor\Post_CSS_File( $template_id );
	        }

	        $css_file->enqueue();
        }

    }



    // Remove Redux Page Templates
    function remove_redux_page_templates($page_templates) {
        unset( $page_templates['redux-templates_canvas'] );
        unset( $page_templates['redux-templates_contained'] );
        unset( $page_templates['redux-templates_full_width'] );

        return $page_templates;
    }


    // Register sidebars
    function theme_sidebars() {

        register_sidebar( array(
            'name' => esc_html__( 'Sidebar', 'syron'),
            'id' => 'rivax_sidebar_widgets',
            'description' => esc_html__( 'Default Sidebar Widgets', 'syron' ),
            'before_widget' => '<div id="%1$s" class="%2$s rivax-sidebar-widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3>',
            'after_title' => '</h3>',
        ));

        register_sidebar( array(
            'name' => esc_html__( 'Footer', 'syron'),
            'id' => 'rivax_footer_widgets',
            'description' => esc_html__( 'Default Footer Widgets', 'syron' ),
            'before_widget' => '<div id="%1$s" class="%2$s rivax-sidebar-widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3>',
            'after_title' => '</h3>',
        ));

    }

}

// Lets start plugin
new Rivax_Theme_Setup();
