<?php
/**
 * Template part for displaying single page
 */

get_header();
?>
<main class="main-wrapper">
    <?php
    $sidebar_position = rivax_get_sidebar_position ('single-page', 'none');

    /* Start the Loop */
    while ( have_posts() ) :
        the_post();

        if($sidebar_position == 'elementor') {
            ?>
            <div class="content-wrapper">
                <?php the_content(); ?>
            </div>
            <?php
        }
        else {
            ?>
            <div class="single-page-outside"></div>
            <div class="content-wrapper">
                <div class="rs-container">
                    <div class="rs-row page-content-wrapper <?php echo 'sidebar-' . $sidebar_position; ?>">
                        <div class="content-container">
                            <article id="post-<?php the_ID(); ?>" <?php post_class( 'single-content card-layout-w' ); ?> >
                                <div class="single-content-inner">
                                    <h1 class="single-page-title"><?php the_title(); ?></h1>
		                            <?php the_content(); ?>
		                            <?php wp_link_pages(); ?>
                                </div>
                            </article>
                            <?php comments_template(); ?>
                        </div>
                        <?php if($sidebar_position == 'left' || $sidebar_position == 'right'): ?>
                            <aside class="sidebar-container <?php if(rivax_get_option('sticky-sidebar')) echo 'sticky'; ?>">
                                <?php get_sidebar(); ?>
                            </aside>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php
        }
    endwhile; // End of the loop.
    ?>
</main>
<?php
get_footer();
