<?php
/**
 * Template part for displaying single post
 */

get_header();
?>
	<main class="main-wrapper">
        <div class="single-post-wrapper">
        <?php
        /* Start the Loop */
        while ( have_posts() ) :
            the_post();

            $sidebar_position = rivax_get_sidebar_position ('single-post', 'none-narrow');
            if($sidebar_position == 'elementor') {
                ?>
                <div class="content-wrapper">
                    <?php the_content(); ?>
                </div>
                <?php
            }
            else {
                ?>
                <?php get_template_part('template-parts/post/content-top'); ?>
                <?php get_template_part('template-parts/post/single-hero-outside'); ?>
                <?php if(rivax_get_option( 'breadcrumb' )): ?>
                <div class="rs-container">
                    <div class="rs-row breadcrumb-wrapper <?php echo 'sidebar-' . $sidebar_position; ?>">
                        <div class="rs-col-6">
	                        <?php rivax_breadcrumb(); ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="content-wrapper">
                    <div class="rs-container">
                        <div class="rs-row page-content-wrapper <?php echo 'sidebar-' . $sidebar_position; ?>">
                            <div class="content-container">
                                <article id="post-<?php the_ID(); ?>" <?php post_class( 'single-content card-layout-w' ); ?> >
	                                <?php get_template_part('template-parts/post/single-hero-inside'); ?>
                                    <div class="single-content-inner">
                                        <?php
                                        if( !empty(rivax_get_option('single-post-meta')['date-updated']) ) {
                                            if( get_the_date() != get_the_modified_date() ) {
												$Updated_title = rivax_get_option('translate-updated-on')?: esc_html__('Updated on', 'syron');
                                                echo '<div><span class="single-date-updated"><span class="badge"></span>' . esc_html($Updated_title) . ' ' . get_the_modified_date() . '</span></div>';
                                            }
                                        }
                                        ?>
	                                    <?php the_content(); ?>
	                                    <?php wp_link_pages(); ?>
	                                    <?php get_template_part('template-parts/post/tags'); ?>
	                                    <?php get_template_part('template-parts/post/share'); ?>
                                    </div>
                                </article>
                                <?php get_template_part('template-parts/post/author-box'); ?>
                                <?php get_template_part('template-parts/post/next-prev-posts'); ?>
                                <?php comments_template(); ?>
                            </div>
                            <?php if($sidebar_position == 'left' || $sidebar_position == 'right'): ?>
                                <aside class="sidebar-container <?php if(rivax_get_option('sticky-sidebar')) echo 'sticky'; ?>">
                                    <?php get_sidebar(); ?>
                                </aside>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php get_template_part('template-parts/post/content-bottom'); ?>
                <?php
            }
        endwhile; // End of the loop.
        ?>
        </div>
	</main>
<?php
get_footer();