<div class="default-archive-container">
    <?php
    if( have_posts() ) {
        ?>
        <div class="default-archive-wrap">
        <?php
        while(have_posts()) {
            the_post();
            $categories = get_the_category();
            $post_cls = 'default-post-list-item post-wrapper card-layout';
            if(!empty($categories)) $post_cls .= ' term-id-' . $categories[0]->term_id;
            ?>
            <article <?php post_class( $post_cls ); ?>>
                <div class="post-wrapper-inner">
                    <?php if ( has_post_thumbnail() ) : ?>
                        <div class="image-container">
                                <?php the_post_thumbnail('thumbnail', array( 'title' => get_the_title() )); ?>
                                <div class="image-animation">
                                    <?php the_post_thumbnail('thumbnail', array( 'title' => get_the_title() )); ?>
                                </div>
                            <a class="rivax-position-cover" href="<?php the_permalink(); ?>"></a>
                            <?php rivax_post_format_icon(); ?>
                        </div>
                    <?php endif; ?>
                    <div class="content-container">
                        <h3 class="title"><span class="title-span"><a class="title-animation-underline" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></span></h3>
                        <div class="meta-details">
                            <div class="author-name">
                                <span class="author-by"><?php esc_html_e('By ', 'syron'); ?></span>
                                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta( 'ID' ))); ?>">
                                    <?php echo esc_html(get_the_author()); ?>
                                </a>
                            </div>
                            <div class="comments">
                                <?php
                                $comments_count = get_comments_number();

                                if( $comments_count == 0 ) {
                                    esc_html_e('No Comment', 'syron');
                                }
                                elseif ( $comments_count == 1 ) {
                                    esc_html_e('One Comment', 'syron');
                                }
                                else {
                                    printf( esc_html__('%d Comments', 'syron'), $comments_count );
                                }
                                ?>
                            </div>
                        </div>
                        <?php
                        $excerpt = rivax_get_the_excerpt(125);
                        if ($excerpt) {
                            echo '<p class="excerpt">' . $excerpt . '</p>';
                        }
                        ?>
                    </div>
                </div>
                <div class="footer-wrap">
                    <div class="terms-wrapper">
                        <?php

                        foreach ($categories as $category) {
                            echo '<a class="term-item term-id-' . $category->term_id . '" href="' . esc_url( get_category_link( $category->term_id ) ) . '"><span>' . esc_html( $category->name ) . '</span></a>';
                        }
                        ?>
                    </div>
                    <div class="footer-meta">
                        <div class="date-wrapper">
                            <span><?php echo get_the_date(); ?></span>
                        </div>
                    </div>
                </div>
            </article>
            <?php
        }
        ?>
        </div>
        <?php

        // Pagination
        global $wp_query;
        if ( $wp_query->max_num_pages > 1 ) :
            ?>
            <nav class="default-post-list-pagination">
                <?php
                $paginate_args = array(
	                'current'   => max( 1, get_query_var( 'paged' ), get_query_var( 'page' ) ),
	                'total'     => $wp_query->max_num_pages,
	                'prev_next' => true,
                );

                echo paginate_links( $paginate_args );
                ?>
            </nav>
        <?php endif;

    }
    else {
        rivax_query_not_found_msg ();
    }
    ?>
</div>