<?php
/**
 * Template part for displaying archive title section
 */

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

global $wp_query;
$post_count = $wp_query->found_posts;

?>

<?php if(!is_front_page()): // Start Archive Title ?>
<div class="rs-container">
    <div class="rs-row">
        <div class="rs-col-6">
            <div class="blog-archive-title card-layout-w">
		        <?php
		        if( is_category() ) {
			        $title = single_cat_title('', false);
			        $sub_title = rivax_get_option('translate-browse-category')?: esc_html__('Browse Category', 'syron');
		        }
                elseif( is_tag() ) {
			        $title = single_tag_title('', false);
			        $sub_title =  rivax_get_option('translate-browse-tag')?: esc_html__('Browse Tag', 'syron');
		        }
                elseif( is_tax() ) {
			        $title = single_term_title('', false);
			        $sub_title =  rivax_get_option('translate-browse')?: esc_html__('Browse', 'syron');
		        }
                elseif (is_post_type_archive()) {
			        $title = post_type_archive_title( '', false );
			        $sub_title =  rivax_get_option('translate-browse')?: esc_html__('Browse', 'syron');
		        }
                elseif( is_search() ) {
			        $title = get_search_query();
			        $sub_title = rivax_get_option('translate-search-for')?: esc_html__('Search Result for', 'syron');
		        }
                elseif( is_author() ) {
	                $title = get_the_author();
	                $sub_title =  rivax_get_option('translate-author')?: esc_html__('Author', 'syron');
		        }
                elseif( is_home() ) {
                    $title = rivax_get_option('translate-our-articles')?: esc_html__('Our Articles', 'syron');
                    $sub_title = rivax_get_option('translate-browse')?: esc_html__('Browse', 'syron');
                }
		        else {
			        $title = get_the_archive_title();
			        $sub_title = rivax_get_option('translate-browse')?: esc_html__('Browse', 'syron');
		        }


		        if(is_author()) {
			        ?>
                    <div class="avatar-wrap">
                        <div class="avatar">
					        <?php echo get_avatar( get_the_author_meta( 'user_email' ), 120 ); ?>
                        </div>
                        <div class="title-wrap">
                            <span class="sub-title"><?php echo esc_html($sub_title); ?></span>
                            <h1 class="title"><?php echo esc_html($title); ?></h1>
                        </div>
                    </div>
                    <div class="description"><p><?php the_author_meta( 'description' ); ?></p></div>
                    <div class="author-social-links">
				        <?php
				        if(function_exists('rivax_author_social')) {
					        rivax_author_social(get_the_author_meta( 'ID' ));
				        }
				        ?>
                    </div>
			        <?php
		        }
                elseif(is_search()) {
			        ?>
                    <div class="title-wrap">
                        <span class="sub-title"><?php echo esc_html($sub_title); ?></span>
                        <h1 class="title"><?php echo wp_kses_post($title); ?></h1>
                    </div>
                    <form action="<?php echo esc_url(home_url('/')); ?>" method="get" class="blog-archive-search-form">
                        <input type="text" name="s" value="<?php echo esc_attr(get_search_query()); ?>" class="search-field" placeholder="<?php echo rivax_get_option('translate-search-3dot')?: esc_attr__('Search ...', 'syron'); ?>" aria-label="Search" required>
                        <button type="submit" class="submit" aria-label="Submit">
                            <i class="ri-search"></i>
                        </button>
                    </form>
			        <?php
		        }
		        else {
                    $title_cls = 'title';
			        if( is_category() ) {
                        $title_cls .= ' term-id-' . get_queried_object_id();
                    }
			        ?>
                    <div class="title-wrap">
                        <span class="sub-title"><?php echo esc_html($sub_title); ?></span>
                        <h1 class="<?php echo esc_attr($title_cls); ?>"><?php echo wp_kses_post($title); ?></h1>
                    </div>
                    <?php the_archive_description('<div class="description">', '</div>'); ?>
			        <?php
		        }
		        ?>
                <div class="post-count"><span>
                    <?php
                    if($post_count > 1) {
                        $post_count_title = rivax_get_option('translate-articles')?: esc_html__('Articles', 'syron');
                    }
                    else {
                        $post_count_title = rivax_get_option('translate-article')?: esc_html__('Article', 'syron');
                    }
                    echo intval($post_count) . ' ' . esc_html($post_count_title);
                    ?>
                </span></div>
            </div>
        </div>
    </div>
</div>
<?php endif; // End Archive Title ?>