<?php
/**
 * Template part for displaying sticky header
 */

$singular_sticky_disabled = is_singular() && (get_post_meta(get_the_ID(), 'rivax_page_sticky_header', true ) == 'disable');
?>
<?php if(rivax_get_option('sticky-header-status') && !$singular_sticky_disabled): ?>
<header id="site-sticky-header">
    <?php
    // Singular Custom Header
    $header_id = rivax_get_layout_template_id('sticky_header');
    $header = rivax_get_display_elementor_content($header_id);

    if($header) {
        echo apply_filters('rivax_print_sticky_header_template', $header);
    }
    else { // Default header
        get_template_part('template-parts/header/header-sticky-default');
    }
    ?>
</header>
<?php endif; ?>