<?php
/**
 * Template part for displaying single post author box
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

if( rivax_get_option('single-post-author-box') ) {
	$author_url = get_author_posts_url(get_the_author_meta( 'ID' ));
    ?>
    <div class="single-author-box-container">
        <div class="single-author-box card-layout-w">
            <div class="single-author-box-avatar">
				<a href="<?php echo esc_url($author_url); ?>">
                <?php echo get_avatar( get_the_author_meta( 'user_email' ), 120 ); ?>
                </a>
            </div>
            <div class="single-author-box-desc">
                <span class="written-by"><?php echo rivax_get_option('translate-author')?: esc_html__('Author', 'syron'); ?></span>
                <h4 class="author-name"><a href="<?php echo esc_url($author_url); ?>"><?php echo esc_html(get_the_author()); ?></a></h4>
                <p class="author-bio"><?php the_author_meta( 'description' ); ?></p>
                <div class="author-social-links">
                    <?php
                    if(function_exists('rivax_author_social')) {
                        rivax_author_social(get_the_author_meta( 'ID' ));
                    }
                    ?>
                </div>
                <a class="button more-articles" href="<?php echo esc_url($author_url); ?>"><?php echo rivax_get_option('translate-follow-me')?: esc_html__('Follow Me', 'syron'); ?></a>
            </div>
        </div>
    </div>
    <?php
}