<?php
/**
 * Template part for displaying single post Standard hero content - Layout 11
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$meta_args = array(
	'title' => false,
	'category' => false,
	'author-name' => true,
	'author-avatar' => true,
);

?>
<div class="single-hero-11">
    <div class="image-container<?php if( rivax_get_option('single-hero-11-fit') ) echo ' single-hero-fit'; ?>">
		<?php the_post_thumbnail('rivax-large', array( 'title' => get_the_title() )); ?>
        <div class="single-hero-11-overlay"></div>

        <div class="content-inner rivax-position-bottom">
            <div class="single-hero-title">
                <?php if(rivax_get_option('single-post-meta')['category']): ?>
                <div class="category">
		            <?php
		            $categories = get_the_category();
		            foreach ($categories as $category) {
			            echo '<a class="term-id-' . $category->term_id . '" href="' . esc_url( get_category_link( $category->term_id ) ) . '" title="' . esc_attr( $category->name ) . '"><span>' . esc_html( $category->name ) . '</span></a>';
		            }
		            ?>
                </div>
                <?php endif; ?>
                <h1 class="title"><?php the_title(); ?></h1>
            </div>
        </div>
    </div>
    <div class="content-container">
		<?php get_template_part('template-parts/post/hero/title-section', '', $meta_args); ?>
    </div>
</div>
