<?php
/**
 * Template part for displaying single post Gallery hero content
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$position_to_content = rivax_get_option('single-format-gallery-position'); // inside / outside
$gallery_images = get_post_meta( get_the_ID(), 'rivax_single_gallery_images', true);

if($position_to_content == 'outside'): ?>
    <div class="rs-container">
        <div class="rs-row-fluid">
            <div class="rs-col-6">
<?php endif; ?>

    <div class="single-hero-gallery">
        <?php
        if(is_array($gallery_images)) {
            ?>
            <div class="swiper">
                <div class="swiper-wrapper">
                <?php
                $image_size = ($position_to_content == 'outside')? 'rivax-medium' : 'rivax-large';
                foreach ($gallery_images as $id => $gallery_image) {

                    $image_url = wp_get_attachment_image_url($id, $image_size);
                    if($image_url) {
                        echo '<div class="single-hero-gallery-item swiper-slide"><div class="item-wrap" data-swiper-parallax-scale="1.2">';
                        echo '<img  src="' . esc_url($image_url) . '" alt="' . get_the_title() . '">';
                        echo '</div></div>';
                    }
                }
                ?>
                </div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
            <?php
        }
        ?>
    </div>

<?php if($position_to_content == 'outside'): ?>
    </div>
        </div>
            </div>
<?php endif; ?>