<?php
/**
 * Template part for displaying single post Quote hero content
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$quote_content = get_post_meta( get_the_ID(), 'rivax_single_quote_content', true);
$quote_author = get_post_meta( get_the_ID(), 'rivax_single_quote_author', true);

if($quote_content):
?>
<div class="single-hero-quote">
    <div class="quote-content">
        <span class="icon"><i class="ri-quote"></i></span>
        <p class="content"><?php echo esc_html($quote_content); ?></p>
        <p class="author"><?php echo esc_html($quote_author); ?></p>
    </div>
</div>
<?php endif; ?>
<?php get_template_part('template-parts/post/hero/title-section'); ?>