<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

// We can pass $args or get meta from option panel
$single_meta = rivax_get_option('single-post-meta');

if(!$single_meta) {
    $single_meta = array(
        'category'      => true,
        'author-avatar' => true,
        'author-name'   => true,
        'date'          => true,
        'date-updated'  => false,
        'reading-time'  => false,
        'views'         => false,
        'comments'      => true,
    );
}

$show_category = isset($args['category'])? $args['category'] : $single_meta['category'];
$show_author_avatar = isset($args['author-avatar'])? $args['author-avatar'] : $single_meta['author-avatar'];
$show_author_name = isset($args['author-name'])? $args['author-name'] : $single_meta['author-name'];
$show_date = isset($args['date'])? $args['date'] : $single_meta['date'];
$show_date_updated = isset($args['date-updated'])? $args['date-updated'] : $single_meta['date-updated'];
$show_reading_time = isset($args['reading-time'])? $args['reading-time'] : $single_meta['reading-time'];
$show_views = isset($args['views'])? $args['views'] : $single_meta['views'];
$show_comments = isset($args['comments'])? $args['comments'] : $single_meta['comments'];
$show_title = isset($args['title'])? $args['title'] : true;
?>
<div class="single-hero-title">
    <?php if( $show_category ): ?>
        <div class="category">
            <?php
            $categories = get_the_category();
            foreach ($categories as $category) {
                echo '<a class="term-id-' . $category->term_id . '" href="' . esc_url( get_category_link( $category->term_id ) ) . '" title="' . esc_attr( $category->name ) . '"><span>' . esc_html( $category->name ) . '</span></a>';
            }
            ?>
        </div>
    <?php endif; ?>

    <?php if( $show_title ): ?>
        <h1 class="title"><span class="title-span"><?php the_title(); ?></span></h1>
    <?php endif; ?>
    <div class="single-hero-meta">
        <?php if( $show_author_avatar ): ?>
            <div class="meta-1">
                <a target="_blank" class="author-avatar" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta( 'ID' ))); ?>">
                    <?php echo get_avatar( get_the_author_meta( 'user_email' ), 45 ); ?>
                </a>
            </div>
        <?php endif; ?>

        <div class="meta-2">
            <div class="top">
                <?php if( $show_author_name ): ?>
                    <span class="author-by"><?php echo rivax_get_option('translate-by')?: esc_html__('By ', 'syron'); ?></span>
                    <a target="_blank" class="author-name" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta( 'ID' ))); ?>">
                        <?php echo esc_html(get_the_author()); ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="bottom">
                <?php if( $show_date ): ?>
                    <span class="meta-item date">
                        <?php echo get_the_date(); ?>
                    </span>
                <?php endif; ?>

                <?php if( $show_reading_time ): ?>
                    <span class="meta-item reading-time">
                        <?php
                        $mins = rivax_get_reading_time();
                        if($mins > 1) {
                            echo intval($mins) . ' ';
                            echo rivax_get_option('translate-min-read')?: esc_html__('Min Read', 'syron');
                        }
                        else {
	                        echo rivax_get_option('translate-one-min-read')?: esc_html__('One Min Read', 'syron');
                        }
                        ?>
                    </span>
                <?php endif; ?>
            </div>
        </div>
        <div class="meta-3">
		    <?php if( $show_views ): ?>
                <span class="meta-item views" title="<?php echo rivax_get_option('translate-views')?: esc_attr__('Views', 'syron'); ?>">
                        <i class="ri-fire"></i>
                        <span class="count"><?php echo rivax_get_post_views(get_the_ID()); ?></span>
                    </span>
		    <?php endif; ?>

		    <?php if( $show_comments ): ?>
                <span class="meta-item comments" title="<?php echo rivax_get_option('translate-comments')?: esc_attr__('Comments', 'syron'); ?>">
                        <i class="ri-chat"></i>
                        <span class="count"><?php echo intval(get_comments_number()); ?></span>
                    </span>
		    <?php endif; ?>
        </div>
    </div>
</div>
