<?php
/**
 * Template part for displaying single post next/prev posts
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

if( rivax_get_option('single-post-next-prev-posts') ) {
    $previous_post = get_previous_post();
    $next_post = get_next_post();
    $image_animation = rivax_get_option('posts-animation');

    if( $next_post || $previous_post ) {
        ?>
        <div class="single-next-prev-posts-container">
            <div class="single-next-prev-posts card-layout-w">
                <div class="single-next-prev-posts-title">
                    <div class="rivax-divider-heading divider-style-1">
                        <div class="divider divider-1"></div>
                        <div class="divider divider-2"></div>
                        <h5 class="title">
                        <span class="title-inner">
                            <span class="title-text"><?php echo esc_html(rivax_get_option('single-next-prev-posts-title')); ?></span>
                        </span>
                        </h5>
                        <div class="divider divider-3"></div>
                        <div class="divider divider-4"></div>
                    </div>
                </div>
                <div class="next-prev-row">
                    <div class="next-prev-col">
                        <?php
                        if( $previous_post ) {
                            ?>
                            <div class="post-wrapper prev-post">
                                <div class="image<?php if($image_animation) echo ' has-animation'; ?>">
                                    <a href="<?php echo esc_url(get_permalink($previous_post->ID)); ?>">
                                        <?php
                                        echo get_the_post_thumbnail($previous_post->ID, 'thumbnail', array( 'title' => get_the_title() ));

                                        if($image_animation) {
                                            echo '<div class="image-animation">';
                                            echo get_the_post_thumbnail($previous_post->ID, 'thumbnail', array( 'title' => get_the_title() ));
                                            echo '</div>';
                                        }
                                        ?>
                                    </a>
                                </div>
                                <div class="content">
                                    <div class="next-prev-label">
                                        <span class="icon"><i class="ri-right-arrow-1"></i></span>
                                        <span class="text"><?php echo rivax_get_option('translate-previous')?: esc_html__('Previous', 'syron'); ?></span>
                                    </div>
                                    <h3 class="title">
                                        <a class="title-animation-underline" href="<?php echo esc_url(get_permalink($previous_post->ID)); ?>"><?php echo esc_html(get_the_title($previous_post->ID)); ?></a>
                                    </h3>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="next-prev-col">
                        <?php
                        if( $next_post ) {
                            ?>
                            <div class="post-wrapper next-post">
                                <div class="image<?php if($image_animation) echo ' has-animation'; ?>">
                                    <a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>">
                                        <?php
                                        echo get_the_post_thumbnail($next_post->ID, 'thumbnail', array( 'title' => get_the_title() ));

                                        if($image_animation) {
                                            echo '<div class="image-animation">';
                                            echo get_the_post_thumbnail($next_post->ID, 'thumbnail', array( 'title' => get_the_title() ));
                                            echo '</div>';
                                        }
                                        ?>
                                    </a>
                                </div>
                                <div class="content">
                                    <div class="next-prev-label">
                                        <span class="text"><?php echo rivax_get_option('translate-next')?: esc_html__('Next', 'syron'); ?></span>
                                        <span class="icon"><i class="ri-right-arrow-1"></i></span>
                                    </div>
                                    <h3 class="title">
                                        <a class="title-animation-underline" href="<?php echo esc_url(get_permalink($next_post->ID)); ?>"><?php echo esc_html(get_the_title($next_post->ID)); ?></a>
                                    </h3>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}