<?php
/**
 * Template part for displaying single post share box
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

if( rivax_get_option('single-post-share-box') ) {
    ?>
    <div class="single-share-box-container">
        <?php
        $social = rivax_get_option('single-post-share-box-options');
        $share_summary = wp_strip_all_tags(get_the_excerpt());
        $share_url = get_permalink();
        $share_title = htmlspecialchars(get_the_title(), ENT_COMPAT, 'UTF-8');
        $share_media = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'full' );
        ?>
        <h4 class="title"><?php echo esc_html(rivax_get_option('single-post-share-box-title')); ?></h4>
        <div class="single-share-box">
            <?php if( $social['facebook'] ): ?>
                <a class="facebook" data-title="Facebook" rel="nofollow" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($share_url); ?>" target="_blank"><i class="ri-facebook"></i></a>
            <?php endif; ?>
            <?php if( $social['twitter'] ): ?>
                <a class="twitter" data-title="X" rel="nofollow"  href="https://twitter.com/intent/tweet?text=<?php echo urlencode($share_title); ?>&url=<?php echo esc_url($share_url); ?>" target="_blank"><i class="ri-twitter"></i></a>
            <?php endif; ?>
            <?php if( $social['linkedin'] ): ?>
                <a class="linkedin" data-title="Linkedin" rel="nofollow" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo esc_url($share_url); ?>&title=<?php echo urlencode($share_title); ?>" target="_blank"><i class="ri-linkedin"></i></a>
            <?php endif; ?>
            <?php if( $social['pinterest'] ): ?>
                <a class="pinterest" data-title="Pinterest" rel="nofollow"  href="https://pinterest.com/pin/create/link/?url=<?php echo esc_url($share_url); ?>&media=<?php echo esc_url($share_media); ?>&description=<?php echo urlencode($share_title); ?>" target="_blank"><i class="ri-pinterest"></i></a>
            <?php endif; ?>
            <?php if( $social['telegram'] ): ?>
                <a class="telegram" data-title="Telegram" rel="nofollow" href="https://t.me/share/?url=<?php echo esc_url($share_url); ?>&text=<?php echo urlencode($share_title); ?>" target="_blank"><i class="ri-telegram"></i></a>
            <?php endif; ?>
            <?php if( $social['email'] ): ?>
                <a class="email" data-title="Email" rel="nofollow"  href="mailto:?subject=<?php echo urlencode($share_title); ?>&body=<?php echo esc_url($share_url); ?>" target="_blank"><i class="ri-email"></i></a>
            <?php endif; ?>
            <?php if( $social['whatsapp'] ): ?>
                <a class="whatsapp" data-title="Whatsapp" rel="nofollow" href="https://api.whatsapp.com/send?text=<?php echo esc_url($share_url); ?>" target="_blank"><i class="ri-whatsapp"></i></a>
            <?php endif; ?>
        </div>

        <?php if( $social['link'] ): ?>
        <div class="single-share-box-link">
            <div class="form-content">
                <input type="text" name="url" value="<?php echo urldecode( get_the_permalink() ); ?>" class="share-link-text" readonly>
                <button type="submit" class="share-link-btn">
                    <i class="ri-copy"></i>
                    <span class="copied-popup-text"><?php esc_html_e('Link Copied!', 'syron') ?></span>
                </button>
            </div>
        </div>
        <?php endif; ?>

    </div>
    <?php
}