<?php
/**
 * Template part for displaying single post hero content - inside content
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$post_format = get_post_format() ? : 'standard';
$selected_standard_layout = intval( get_post_meta(get_the_ID(), 'rivax_single_post_layout', true ) );
$global_standard_layout = intval(rivax_get_option('single-hero'));
$standard_post_layout = $selected_standard_layout && class_exists('Redux')? $selected_standard_layout : $global_standard_layout; // Current post selected layout
$standard_inside_layouts = array(1, 4, 8, 11); // Standard layouts for inside place
$standard_inside_title = array(2, 9); // Title for inside place

echo '<div class="single-hero-inside">';

if( $post_format == 'gallery' ) {
	if(rivax_get_option('single-format-gallery-position') == 'inside') {
		get_template_part('template-parts/post/hero/content-gallery');
	}
	get_template_part('template-parts/post/hero/title-section');
}
elseif( $post_format == 'video' ) {
    get_template_part('template-parts/post/hero/content-video');
}
elseif( $post_format == 'audio' ) {
    get_template_part('template-parts/post/hero/content-audio');
}
elseif( $post_format == 'link' ) {
    get_template_part('template-parts/post/hero/content-link');
}
elseif( $post_format == 'quote' ) {
    get_template_part('template-parts/post/hero/content-quote');
}
elseif( $post_format == 'standard' && in_array($standard_post_layout, $standard_inside_layouts) ) {
    get_template_part('template-parts/post/hero/content-' . $standard_post_layout);
}
elseif( $post_format == 'standard' && in_array($standard_post_layout, $standard_inside_title) ) {
	get_template_part('template-parts/post/hero/title-section');
}
elseif( $standard_post_layout == 0 ) {
    get_template_part('template-parts/post/hero/content-1');
}

echo '</div>';