<?php
/**
 * Template part for displaying single post hero content - outside content
 */
if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

$post_format = get_post_format() ? : 'standard';
$selected_standard_layout = intval( get_post_meta(get_the_ID(), 'rivax_single_post_layout', true ) );
$global_standard_layout = intval(rivax_get_option('single-hero'));
$standard_post_layout = $selected_standard_layout && class_exists('Redux')? $selected_standard_layout : $global_standard_layout; // Current post selected layout
$standard_outside_layouts = array(2, 3, 5, 6, 7, 9, 10); // Standard layouts for outside place

echo '<div class="single-hero-outside">';

if( $post_format == 'gallery' && rivax_get_option('single-format-gallery-position') == 'outside' ) {
    get_template_part('template-parts/post/hero/content-gallery');
}
elseif( $post_format == 'standard' && in_array($standard_post_layout, $standard_outside_layouts) ) {
    get_template_part('template-parts/post/hero/content-' . $standard_post_layout);
}

echo '</div>';