<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// Enqueue child theme style 
if ( !function_exists( 'teta_child_theme_assets' ) ) {
	
    function teta_child_theme_assets() {
		if ( is_rtl() ) {
			wp_enqueue_style( 'teta_child_theme_style', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'icomoon','kite-theme-style','kite-woocommerce-style','kite-responsive', 'kite-rtl') );  
		} else { 
			wp_enqueue_style( 'teta_child_theme_style', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'icomoon','kite-theme-style','kite-woocommerce-style','kite-responsive' ) );  
		}

		wp_enqueue_script( 'teta_child_script', trailingslashit( get_stylesheet_directory_uri() ) . 'main.js', array('jquery'), 1.0, true );
	}

	
}
add_action( 'wp_enqueue_scripts', 'teta_child_theme_assets', 100 );


/*----------------------------------------
    write your codes in the following
-----------------------------------------*/

