/*-----------------------------------------------------------------------------------*/
/*  checkout
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var checkout = {

        /*----------------------------------------------------------------------------------*/
        /* Reinitialise select2 on countery select in checkout page
        /*-----------------------------------------------------------------------------------*/
        reinitCheckoutCounterySelect2: function () {
            var self = this;

            if ( $('.woocommerce-checkout select.country_to_state.country_select').length > 1 ) {

                //It's an copy of getEnhancedSelectFormatString function in woocommerce/assets/js/frontend/country-select.js
                var getEnhancedSelectFormatString = function () {
                    return {
                        'language': {
                            errorLoading: function () {
                                // Workaround for https://github.com/select2/select2/issues/4355 instead of i18n_ajax_error.
                                return wc_country_select_params.i18n_searching;
                            },
                            inputTooLong: function (args) {
                                var overChars = args.input.length - args.maximum;

                                if (1 === overChars) {
                                    return wc_country_select_params.i18n_input_too_long_1;
                                }

                                return wc_country_select_params.i18n_input_too_long_n.replace('%qty%', overChars);
                            },
                            inputTooShort: function (args) {
                                var remainingChars = args.minimum - args.input.length;

                                if (1 === remainingChars) {
                                    return wc_country_select_params.i18n_input_too_short_1;
                                }

                                return wc_country_select_params.i18n_input_too_short_n.replace('%qty%', remainingChars);
                            },
                            loadingMore: function () {
                                return wc_country_select_params.i18n_load_more;
                            },
                            maximumSelected: function (args) {
                                if (args.maximum === 1) {
                                    return wc_country_select_params.i18n_selection_too_long_1;
                                }

                                return wc_country_select_params.i18n_selection_too_long_n.replace('%qty%', args.maximum);
                            },
                            noResults: function () {
                                return wc_country_select_params.i18n_no_matches;
                            },
                            searching: function () {
                                return wc_country_select_params.i18n_searching;
                            }
                        }
                    };
                }

                var initSelect2ForWcSelects = function () {

                    setTimeout(function () {

                        if ($.isFunction($.fn.select2)) {

                            var wcCountrySelectSelect2 = function () {
                                $('select.country_select:visible, select.state_select:visible').each(function () {
                                    var select2_args = $.extend({
                                        placeholderOption: 'first',
                                        width: '100%'
                                    }, getEnhancedSelectFormatString());

                                    $(this).select2(select2_args);
                                });
                            };

                            wcCountrySelectSelect2();
                        }

                    }, 1000);
                }

                self.$body.bind('country_to_state_changed', function () {
                    initSelect2ForWcSelects();
                });

                initSelect2ForWcSelects();
            }
        },

        checkoutCoupon: function() {
            $('form.checkout button[name="apply_coupon"]').on( 'click', function(e){
                e.preventDefault();

                var $form = $( this ).parents('form');

                if ( $form.is( '.processing' ) ) {
                    return false;
                }

                $form.addClass( 'processing' ).block({
                    message: null,
                    overlayCSS: {
                        background: '#fff',
                        opacity: 0.6
                    }
                });

                var data = {
                    security: wc_checkout_params.apply_coupon_nonce,
                    coupon_code: $form.find( 'input[name="coupon_code"]' ).val()
                };

                $.ajax({
                    type:   'POST',
                    url:    wc_checkout_params.wc_ajax_url.toString().replace( '%%endpoint%%', 'apply_coupon' ),
                    data:   data,
                    success:    function( code ) {
                        $( '.woocommerce-error, .woocommerce-message' ).remove();
                        $form.removeClass( 'processing' ).unblock();

                        if ( code ) {
                            $( document.body ).trigger( 'applied_coupon_in_checkout', [ data.coupon_code ] );
                            $( document.body ).trigger( 'update_checkout', { update_shipping_method: false } );
                        }
                    },
                    dataType: 'html'
                });
            });
        }
    };

    kiteTheme = Object.assign( kiteTheme, checkout );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($){
    kiteTheme.reinitCheckoutCounterySelect2();
    kiteTheme.checkoutCoupon();
})(jQuery);