/*-----------------------------------------------------------------------------------*/
/*  ajaxWoocommerceTab
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var ajaxWoocommerceTab = {
        woocommerceAjaxProductsTab: function (container = $(document)) {
            if ( !container.find('.ajax_products_tab').length ) {
                return;
            }
            var self = this,
                xhr = null,
                $panels = container.find('.ajax_products_tab .vc_tta-panels');
            $panels.each(function (index, el) {
                $(this).attr('style', 'min-height:' + $(this).height() + 'px !important;');
            });
            container.find('.ajax_products_tab li.vc_tta-tab,.ajax_products_tab li.vc_tta-tab a,.ajax_products_tab li.vc_tta-tab span').off('click');
            container.find('.ajax_products_tab li.vc_tta-tab').on('click', function (event) {
                event.preventDefault();

                if (xhr) {
                    xhr.abort();
                }

                if ($(this).hasClass('vc_active')) {
                    return;
                } else {
                    $(this).parents('.vc_tta-container').find('li.vc_active').removeClass('vc_active');
                    $(this).addClass('vc_active');
                }
                if ($(this).parents('.ajax_products_tab').find('.vc_tta-panel[data-tab-id=' + $(this).data('tab-id') + ']').length) {
                    $(this).parents('.ajax_products_tab').find('.vc_tta-panel.vc_active_show').removeClass('vc_active_show').removeClass('show').removeClass('vc_active');
                    $(this).parents('.ajax_products_tab').find('.vc_tta-panel[data-tab-id=' + $(this).data('tab-id') + ']').addClass('vc_active_show show vc_active');
                    $(this).parents('.ajax_products_tab').find('.vc_tta-panels').attr('style', 'min-height:' + $('.vc_tta-panels').find('.vc_active.vc_tta-panel').outerHeight() + 'px !important');
                    self.runIsotopeInProducts();
                    return;
                }
                var $tabPanels = $(this).parents('.ajax_products_tab').find('.vc_tta-panels');
                if ($tabPanels.outerHeight() > 500) {
                    $tabPanels.find('.wc-loading').css('top', '20%');
                } else {
                    $tabPanels.find('.wc-loading').css('top', '50%');
                }
                $tabPanels.find('.wc-loading').removeClass('hide');
                $tabPanels.find('.vc_active_show').removeClass('vc_active_show').removeClass('show').removeClass('vc_active');
                var data = {
                    action: 'fetch_woocommerce_shortcode_dom',
                    atts: $(this).data('shortcode-prop'),
                    tab_id: $(this).data('tab-id'),
                    kite_nonce: kite_theme_vars.nonce,
                    context: 'frontend'
                };
                xhr = $.ajax({
                    url: kite_theme_vars.ajax_url,
                    type: 'GET',
                    dataType: 'html',
                    data: data,
                }).done(function (response) {
                    $tabPanels.find('.wc-loading').addClass('hide');
                    $tabPanels.append(response);
                    self.carousel();
                    self.runIsotopeInProducts();
                    self.lazyLoadOnLoad($tabPanels);
                    self.lazyLoadOnHover($tabPanels);
                    self.compare();
                    self.woocommerceVariationItemSelect();
                    self.woocommerceButtonsOnHoverCartClick();
                    self.mobileHoverState();
                    self.productsInfoOnClick();
                    self.productQuickView();
                    $tabPanels.attr('style', 'min-height:' + $tabPanels.find('.vc_active.vc_tta-panel').height() + 'px !important;');
                }).fail(function (response) {

                }).always(function () {

                });
            });
        },

    };

    kiteTheme = Object.assign( kiteTheme, ajaxWoocommerceTab );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.woocommerceAjaxProductsTab();
    }
})(jQuery, window.kiteTheme);