/*-----------------------------------------------------------------------------------*/
/*  bannerHeyperLink
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var banner = {
        bannerHyperLink: function () {

            if ( $('.banner').length > 0 ) {
                var $banner = $('.banner');
                $banner.each(function (index, el) {
                    if ($(this).find('a').length > 0) {
                        $(this).find('.content-container').css('cursor', 'pointer');
                        $(this).on('click', function (event) {
                            var $a = $(this).find('a');
                            var $url = $a.attr('href'),
                                $target = $a.attr('target');
                            window.open($url, $target);

                        });
                    }
                });
            }
        },

    };

    kiteTheme = Object.assign( kiteTheme, banner );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.bannerHyperLink();
    }

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-banner.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
        });
    });
})(jQuery, window.kiteTheme);