/*-----------------------------------------------------------------------------------*/
/*  blog
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var blog = {

        initBlog: function() {
            this.blogToggle();
            this.blogToggleLoadmore();
            this.blogHeadLine();
            this.toggleBlog();
            this.blogLoadMore();
            this.blogMasonry();
            // move to single blog js file 
            this.blogPostSlider();
            this.singlePage();
            this.reviewForm();
            this.blogFloatingPart();
        },

        blogResizeEvent: function(){
            var self = this;
            // blog toggle
            $('.blogaccordion').each(function () {
                var postVar = self.blogToggleArray($(this));
                // set toggle mode When Page Loaded
                self.blogToggleSet(postVar);
            });

            this.blogMasonry();
            this.blogHeadLine();
            this.toggleBlog();
        },

        blogOnReadyEvent: function () {
            this.fixedSidebar();  
        },
        /*-----------------------------------------------------------------------------------*/
        /*  blog toggle & blog toggle load more 
        /*-----------------------------------------------------------------------------------*/

        // blog toggle click 
        blogToggleClick: function (postVar) {

            var self = this;

            var $toggleMode = parseInt(postVar.$accordion.attr("data-value"));

            if ( $toggleMode === 0 ) {

                var $accordionHeight = "350px";
                if (self.windowWidth > 480) {
					$accordionHeight = "520px";
				}

                postVar.$content.fadeIn();


                postVar.$frameTitle.css({
                    opacity: 0.3,
                    'background-color': '#fff',
                    height: '160px'
                }),

				//post title And Date animation css
				postVar.$monthTitle.css({
					'border-left-color': '#fff',
					left: '-81px'
				});

                postVar.$titleImage.toggleClass('accordion_closed'),
                postVar.$accordion.toggleClass('accordionclosed'),

				// change data Value
				postVar.$accordion.attr("data-value", "1");

            } else if ( $toggleMode === 1 || isNaN($toggleMode) ) {

                postVar.$content.fadeOut('fast');
                postVar.$frameTitle.css({
                    opacity: 1,
                    'background-color': 'transparent',
                    height: '100%'
                })

                //post title And Date animation css
                postVar.$day.css({
                    width: '130px'
                }),

				postVar.$monthTitle.css({
					'border-left-color': '#fff',
					left: '0px'
				}),

				postVar.$monthTitle.find('.monthyear').css({
					left: '0px',
				}),

				postVar.$monthTitle.find('.blogtitle').css({
					left: '0px',
				});

                postVar.$titleImage.toggleClass('accordion_closed');
                postVar.$accordion.toggleClass('accordionclosed'),

				// change data Value
				postVar.$accordion.attr("data-value", "0");
            }


        },

        // blog toggle default set
        blogToggleSet: function (postVar) {
            var self = this;
            if ( postVar.$flag === 0 ) {
                // Set Close Mode
                postVar.$content.slideUp(function () {
                    self.parallaxImg();
                });

                postVar.$titleImage.toggleClass('accordion_closed');

            } else if ( postVar.$flag === 1 || isNaN(postVar.$flag) ) {

                postVar.$accordionBox10.add(postVar.$accordionBox).animate(
                    { height: postVar.$imgHeight },
                    {
                        queue: false,
                        duration: 500
					}
				)

                postVar.$frameTitle.css({
                    opacity: 0.3,
                    'background-color': '#fff',
                    height: '160px'
                })

            }

        },

        blogToggleArray: function ($thisAccordion) {

            var $accordion = $thisAccordion,
                $titleImage = $accordion.find('.image'),
                $imgH = $titleImage.find('img'),
                $noImage = $titleImage.find('.noImage'),
                $content = $accordion.find('.accordion_content'),
                $accordionBox2 = $accordion.find('.accordion_box2'),
                $accordionBox10 = $accordion.find('.accordion_box10'),
                $flag = parseInt($accordion.attr("data-value")),
                $blogClose = $accordion.find('.blogClose'),
                $minus = $accordion.find('.minus'),
                $plus = $accordion.find('.plus'),
                $accordionBox = $accordion.find('.accordionBox'),
                $frameTitle = $accordion.find('.frameTitle'),
                $day = $accordion.find('.accordion_title'),
                $monthTitle = $accordion.find('.leftborder');


            var postVar = {
                $accordion: $accordion,
                $titleImage: $titleImage,
                $imgH: $imgH,
                $noImage: $noImage,
                $content: $content,
                $accordionBox2: $accordionBox2,
                $accordionBox10: $accordionBox10,
                $flag: $flag,
                $minus: $minus,
                $plus: $plus,
                $accordionBox: $accordionBox,
                $frameTitle: $frameTitle,
                $day: $day,
                $monthTitle: $monthTitle,
            };

            return postVar;
        },

        // blog toggle
        blogToggle: function () {

            var self = this;
            if ( ! $('.blogaccordion').length ) {
                return;
            }

            $('.blogaccordion').each(function () {

                var $accordion = $(this),
                    $titleImage = $accordion.find('.image'),
                    $imgH = $titleImage.find('img'),
                    $noImage = $titleImage.find('.noImage'),
                    $content = $accordion.find('.accordion_content'),
                    $accordionBox2 = $accordion.find('.accordion_box2'),
                    $accordionBox10 = $accordion.find('.accordion_box10'),
                    $flag = parseInt($accordion.attr("data-value")),
                    $blogClose = $accordion.find('.blogClose'),
                    $minus = $accordion.find('.minus'),
                    $plus = $accordion.find('.plus'),
                    $accordionBox = $accordion.find('.accordionBox'),
                    $frameTitle = $accordion.find('.frameTitle'),
                    $day = $accordion.find('.accordion_title'),
                    $monthTitle = $accordion.find('.leftborder');

                var postVar = {
                    $accordion: $accordion,
                    $titleImage: $titleImage,
                    $imgH: $imgH,
                    $noImage: $noImage,
                    $content: $content,
                    $accordionBox2: $accordionBox2,
                    $accordionBox10: $accordionBox10,
                    $flag: $flag,
                    $minus: $minus,
                    $plus: $plus,
                    $accordionBox: $accordionBox,
                    $frameTitle: $frameTitle,
                    $day: $day,
                    $monthTitle: $monthTitle,
                };

                // set toggle mode When Page Loaded
                self.blogToggleSet(postVar);

                $minus.add($plus).add($blogClose).click(function () {
                    // toggle Post When Click Event Occur
                    self.blogToggleClick(postVar);
                });

            });

        },

        /* blog toggle loadmore */
        blogToggleLoadmore: function () {

            var self = this;

            $(".posts-page-" + (self.blogPageNum + 1)).find('.blogaccordion').each(function () {
                var $accordion = $(this),
                    $title = $accordion.find('.accordion_title'),
                    $titleImage = $accordion.find('.image'),
                    $imgH = $titleImage.find('img'),
                    $noImage = $titleImage.find('.noImage'),
                    $content = $accordion.find('.accordion_content'),
                    $accordionBox2 = $accordion.find('.accordion_box2'),
                    $accordionBox10 = $accordion.find('.accordion_box10'),
                    $flag = parseInt($accordion.attr("data-value")),
                    $blogClose = $accordion.find('.blogClose'),
                    $minus = $accordion.find('.minus'),
                    $plus = $accordion.find('.plus'),
                    $accordionBox = $accordion.find('.accordionBox'),
                    $frameTitle = $accordion.find('.frameTitle'),
                    $day = $accordion.find('.accordion_title'),
                    $monthTitle = $accordion.find('.leftborder');

                var postLoadVar = {
                    $accordion: $accordion,
                    $titleImage: $titleImage,
                    $imgH: $imgH,
                    $noImage: $noImage,
                    $content: $content,
                    $accordionBox2: $accordionBox2,
                    $accordionBox10: $accordionBox10,
                    $flag: $flag,
                    $minus: $minus,
                    $plus: $plus,
                    $accordionBox: $accordionBox,
                    $frameTitle: $frameTitle,
                    $day: $day,
                    $monthTitle: $monthTitle,
                };

                // set toggle mode When Page Loaded
                self.blogToggleSet(postLoadVar);

                $minus.add($plus).add($blogClose).click(function () {
                    // toggle Post When Click Event Occur
                    self.blogToggleClick(postLoadVar);
                });

            });
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Blog Load More Function
        /*-----------------------------------------------------------------------------------*/
        blogLoadMore: function () {

            var self = this,
                $loadBTN = $('.pagenavigation');

            if ( typeof paged_data == 'undefined' || $loadBTN.length < 1 ) {
				return;
			}

            var max = 1;

            if ( $loadBTN.hasClass('cartblog') ) {
                var $uniqueId = "#" + $loadBTN.siblings('.isotope').attr('data-id'),
                    $blog = $($uniqueId).first();
                max = $blog.data('maxpages');
            } else {
                max = parseInt(paged_data.maxPages);
            }

            if ( max < 2 ) {
				return;
			}

            //Replace links with load more button
            $loadBTN.html('<div class="readmore clearfix"><div class="loadmore loadmoreactive"><span class="text load-more-text">' + paged_data.loadmoreText + '</span><span class="text loading-text">' + paged_data.loadingText + '</span><span class="text no-more-text">' + paged_data.noMorePostsText + '</span></div></div>');

            $('.loadmore').click(function () {
                var $btn = $(this);
                $loadBTN = $(this).parents('.pagenavigation');

                if ( $loadBTN.hasClass('cartblog') ) {// It is a card blog

                    var $uniqueId = " #" + $loadBTN.siblings('.isotope').attr('data-id'),
                        $blog = $($uniqueId).first(),
                        $isCardBlog = true;
                    // Next line finds the first hidden page
                    var startPage = $blog.data('page'),
                        nextPage = startPage + 1,
                        max = $blog.data('maxpages'),
                        isLoading = false;
                    //Next line stores the pages that appeared by far
                    $blog.data('page', nextPage);
                } else if ( $loadBTN.hasClass('readmore-blog') ) {
                    var $uniqueId = " #" + $loadBTN.siblings('.blog-head-line-container, .blog-toggle-container').attr('data-id'),
                        $blog = $($uniqueId).first(),
                        $isHeadLineBlog = true;
                    // Next line finds the first hidden page
                    var startPage = $blog.data('page'),
                        nextPage = startPage + 1,
                        max = $blog.data('maxpages'),
                        isLoading = false;
                    //Next line stores the pages that appeared by far
                    $blog.attr('data-page', nextPage);
                    $blog.data('page', nextPage);

                } else {// It is classic blog
                    var startPage = parseInt(paged_data.startPage),
                        nextPage = startPage + 1,
                        max = parseInt(paged_data.maxPages),
                        isLoading = false;
                    var $blog = "#blogloop",
                        $uniqueId = ' .post';
                }

                if ( max < 2 ) { 
					return; 
				}

                //Activate loadmore button
                if ( nextPage > max ) {
                    $btn.removeClass('loadingactive').addClass('loadmoreactive');
				}

                if ( nextPage > max || isLoading ) {
					return;
				}

                isLoading = true;

                //Set loading text
                $(this).removeClass('loadmoreactive').addClass('loadingactive');
                var $pageContainer = $('<div class="posts-page-' + nextPage + '"></div>');

                //Next line is for creating a valid link to next page
                paged_data.nextLink = '/?postpage=' + nextPage;
                paged_data.nextLink = '?postpage=' + nextPage;

                $pageContainer.load(paged_data.nextLink + $uniqueId, function () {

                    //Insert the posts container before the load more button
                    $pageContainer.waitForImages(function () { //loads gallery in classic blog load more
                        var $content;
                        if ( $isCardBlog ) {
                            $content = $($pageContainer.html());
                            $content = $($content.html());
                        } else {
                            $content = $pageContainer;
                        }

                        if ( $isCardBlog ) {
                            var $container = $($uniqueId);
                            $container.append($content).isotope('appended',$content);
                            $container.waitForImages(function(){
                                setTimeout(function () {
                                    // call isotope animation ( defualt and custom mode )
                                    self.lazyLoadOnLoad($container);
                                    self.parallaxImg();
                                    self.isotopeAnimation($blog);
                                }, 500);
                            });
                        } else {
                            $content.hide().appendTo($blog).fadeIn('fast');
                        }

                        // Update page number and nextLink.
                        paged_data.startPage = paged_data.startPage.replace(/[0-9]+/, startPage + 1);

                        if ( nextPage < max ) {
                            $btn.removeClass('loadingactive').addClass('loadmoreactive');
                        } else if (nextPage >= max) {
                            $btn.removeClass('loadingactive loadmoreactive').addClass('nomoreactive');
                        }

                        isLoading = false;

                        if ( !($isCardBlog) ) {
                            self.blogPageNum = nextPage;
                            self.blogPageNum--;

                            self.blogToggleLoadmore();
							self.toggleBlog();
                            self.blogPostSlider();
                            self.fitVideo();
                        }

                    });


                });

            });

        },
        /*-----------------------------------------------------------------------------------*/
        /*  Blog Head Line Responsive Function
        /*-----------------------------------------------------------------------------------*/
        blogHeadLine: function() {
            if ( !$('.blog-head-line-container').length ) {
				return;
			}

            $('.blog-head-line-container').each(function() {
                if ($(this).parent().width() <= 350) {
                    $(this).find('.blog-head-line-item,.blog-head-line-description').addClass('responsive-350');
                    $(this).find('.blog-head-line-item,.blog-head-line-description,.blog-head-line-details').removeClass('responsive-674 responsive-558 responsive-451');
                } else if ( 350 < $(this).parent().width() && $(this).parent().width() <= 451 ) {
                    $(this).find('.blog-head-line-item,.blog-head-line-description').addClass('responsive-451');
                    $(this).find('.blog-head-line-item,.blog-head-line-description,.blog-head-line-details').removeClass('responsive-674 responsive-558 responsive-350');
                } else if ( 451 < $(this).parent().width() && $(this).parent().width() <= 558 ) {
                    $(this).find('.blog-head-line-item,.blog-head-line-description').addClass('responsive-558');
                    $(this).find('.blog-head-line-item,.blog-head-line-description,.blog-head-line-details').removeClass('responsive-674 responsive-451 responsive-350');
                } else if ( 558 < $(this).parent().width() && $(this).parent().width() <= 674 ) {
                    $(this).find('.blog-head-line-item,.blog-head-line-description,.blog-head-line-details').addClass('responsive-674');
                    $(this).find('.blog-head-line-item,.blog-head-line-description,.blog-head-line-details').removeClass('responsive-558 responsive-451 responsive-350');
                } else {
                    $(this).find('.blog-head-line-item,.blog-head-line-description,.blog-head-line-details').removeClass('responsive-674 responsive-558 responsive-451 responsive-350');
                }
            });
        },

		/*-----------------------------------------------------------------------------------*/
        /* Blog Toggle Responsive Function
        /*-----------------------------------------------------------------------------------*/
		toggleBlog: function() {
            if ( !$('.blog-toggle-container').length ) {
				return;
			}

			$('.blog-toggle-container').each(function() {
			   var $this = $(this);

				if ($this.parent().width() > 952) {
					$this.find('.blogaccordion').addClass('responsive-1024');
					$this.find('.blogaccordion').removeClass('responsive-952 responsive-475 responsive-265');
                }
				if ( 475 <  $this.parent().width() &&  $this.parent().width() <= 952) {
					$this.find('.blogaccordion').addClass('responsive-952');
                    $this.find('.blogaccordion').removeClass('responsive-265 responsive-475 responsive-1024');
                }
				if ( 265 <  $this.parent().width() &&  $this.parent().width() <= 475 ) {
                    $this.find('.blogaccordion').addClass('responsive-475');
                    $this.find('.blogaccordion').removeClass('responsive-952 responsive-265 responsive-1024');
                }
				if ($this.parent().width() <= 265) {
                    $this.find('.blogaccordion').addClass('responsive-265');
                    $this.find('.blogaccordion').removeClass('responsive-952 responsive-475 responsive-1024');
                }

            });
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Blog Post Slider 
        /*-----------------------------------------------------------------------------------*/

        blogPostSlider: function () {

            // blog post slider - swoper slider
            if ( ! $('.bp-swiper').length ) {
                return;
            }
            $('.bp-swiper').not('.disabled_swiper').each(function () {

                var $blogPostNextBtn = $(this).find('.arrows-button-next'); // Next btns
                var $blogPostPrevBtn = $(this).find('.arrows-button-prev');// Previous Btns
                $blogPostNextBtn.add($blogPostPrevBtn).css({ 'opacity': '1' });

                var swiper = new Swiper($(this)[0], {

                    loop: true,
                    speed: 650,
                    watchSlidesProgress: true,
                    navigation: {
                        nextEl: $blogPostNextBtn[0],
                        prevEl: $blogPostPrevBtn[0],
                    },
                    on: {
                        slideChangeTransitionStart: function () {
                            //Unset height
                            $('.bp-swiper .swiper-wrapper').css({ height: '' });
                            //Calc Height
                            var $blogPostSwiperWidth = $('.bp-swiper').width(), // Container Width
                                $imgeWidth = $(this.slides[this.activeIndex]).find('img').attr('width'), // initial Images Width
                                $imgeHeight = $(this.slides[this.activeIndex]).find('img').attr('height'), // initial image width
                                $imgeNewHeight = ($blogPostSwiperWidth * $imgeHeight) / $imgeWidth; // Calc image height in container

                            $('.bp-swiper .swiper-wrapper').css({ height: $imgeNewHeight });
                            $('.bp-swiper').css({ height: $imgeNewHeight });
                        },
                    },
                });

            });

        },

        /*----------------------------------------------------------------------------------*/
        /*   Singlepages initialize
        /*-----------------------------------------------------------------------------------*/

        singlePage: function () {
            var self = this;
            if ( $('#blogsingle').length || $('.cblog').length ) {
                self.blogPostSlider(); // Blog Post slider
                self.socailshare(); // socail share
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*  ReviewForm  blog and product details
        /*-----------------------------------------------------------------------------------*/

        reviewForm: function () {

            // blog detail
            if ( $('.comment-respond').length ) {

                $(".comment-respond input").focus(function () {
                    $(this).siblings('.label').addClass('inputfocus');
                    $(this).siblings('.graylabel').addClass('inputfocus');
                });


                $(".comment-respond input").focusout(function () {
                    $(this).siblings('.label').removeClass('inputfocus');
                    $(this).siblings('.graylabel').removeClass('inputfocus');
                });

                $(".comment-respond textarea").focus(function () {
                    $(this).siblings('.label').addClass('inputfocus');
                    $(this).siblings('.graylabel').addClass('inputfocus');
                });


                $(".comment-respond textarea").focusout(function () {
                    $(this).siblings('.label').removeClass('inputfocus');
                    $(this).siblings('.graylabel').removeClass('inputfocus');
                });

            }

        },

        /*----------------------------------------------------------------------------------*/
        /*  Masonry Blog
        /*-----------------------------------------------------------------------------------*/

        blogMasonry: function (isLoadMore, container = $(document)) {
            var self = this;

            container.find('.masonry-blog.isotope').each(function () {

                var $container = $(this);
                var $layoutMode = $(this).data('layoutmode');

                // calc blog wrap width
                var $columnNumber = $(this).data('columnnumber');

                if (self.windowWidth <= 979) {
                    //2column in vertical tablets
                    $columnNumber = 2; 
                    if (self.windowWidth <= 480) {
                        //1column in mobile devices
                        $columnNumber = 1;
                    }
                }

                var columnGutter = 12;
                var blogWrapWidth = $(this).parents('.vc_column-inner,.elementor-widget-container').width();
                var $colWidth = Math.floor(blogWrapWidth / $columnNumber) - (2 * columnGutter);

                if (isLoadMore != true) {
                    $container.isotope({
                        itemSelector: '.isotope-item',
                        layoutMode: $layoutMode,
                        originLeft: ( ! $('body').hasClass('rtl') )
                    });
                }

                // call isotope animation ( defualt and custom mode )
                self.isotopeAnimation($container);

                // var blog_resize_handler = function () {
                //     setTimeout(function () {
                //         $container.isotope('reLayout');
                //     }, 300);
                // }
                // self.$window.on('resize', blog_resize_handler);
                // self.$window.one('djaxClick', function () {
                //     self.$window.unbind('resize', blog_resize_handler);
                // });

                $container.find('.blog-masonry-container').each(function () {

                    var $blogItems = $(this);

                    $blogItems.css({
                        'width': $colWidth,
                        'max-width': $colWidth,
                    });


                    $blogItems.find('.swiper').each(function () {

                        var $this = $(this);
                        if ( $this.find('.swiper-slide').length > 1 ) {
                            var $nextButton = $this.find('.swiper-button-next'),
                                $prevButton = $this.find('.swiper-button-prev'),

                                autoplayDuration = 3000 + Math.floor(Math.random() * 4000);

                            //Prevent from running swiper multiple times on initiated items
                            if ( $this[0].swiper != undefined ) {
                                return true;
                            }

                            if (autoplayDuration == 0) {
                                var autoplay = false;
                            } else {
                                var autoplay = { delay: autoplayDuration };
                            }
                            // Slider For Blog : Gallert Post format
                            var blogCartSlider = new Swiper($this[0], {
                                speed: 600,
                                longSwipesMs: 700,
                                touchAngle: 30,
                                loop: true,
                                autoplayDisableOnInteraction: false,
                                spaceBetween: 0,
                                followFinger: false,
                                watchSlidesProgress: true,
                                navigation: {
                                    nextEl: $nextButton[0],
                                    prevEl: $prevButton[0],
                                },
                                autoplay: autoplay,
                            });

                            var blogCartSliderResizeHandler = function () {
                                setTimeout(function () {
                                    blogCartSlider.on('resize');
                                }, 100);
                            }

                            self.$window.on('resize', blogCartSliderResizeHandler);

                            self.$window.one('djaxClick', function () {
                                self.$window.unbind('resize', blogCartSliderResizeHandler);
                            });

                            // resize swiper after loading to calculate width correctly
                            blogCartSliderResizeHandler();


                        } else {
                            $this.find('.swiper-wrapper').addClass('disabled_swiper');
                        }

                    });
                    self.galleryStart(); //To restart pop-up video and pop-up sound
                });
            });
        },

        blogFloatingPart: function() {

            if ( ! $('.kt-single-post-container').length ) {
                return;
            }

            var $postContainer = $('.kt-single-post-container'),
                postContainerTopOffset = $postContainer.offset().top - 64,
                postContainerHeight = $postContainer.height(),
                bottomOfPostContainerTopOffset = postContainerTopOffset + postContainerHeight,
                $floatingPart = $('.kt-floating-info');

            var setFloatingPartPosition = function(){
                var scrollPosition = $(document).scrollTop();
                if ( scrollPosition > postContainerTopOffset && scrollPosition < bottomOfPostContainerTopOffset ) {
                    $floatingPart.addClass('fixed');
                } else if ( bottomOfPostContainerTopOffset - scrollPosition <= 120  ) {
                    $floatingPart.addClass('fixed');
                } else {
                    $floatingPart.removeClass('fixed');
                }
            }

            setFloatingPartPosition();
            $(document).on('scroll', function(){
                setFloatingPartPosition()
            });
        },

        fixedSidebar: function () {
            var self = this;
            if (!$('.cblog .main-sidebar-container, #blogsingle .main-sidebar-container').length || self.$window.width() < 1140 || !self.$body.hasClass('has-fixed-sidebar') ) {
                return;
            }

            var $sidebar = $('.main-sidebar-container'),
                sidebarHeight = $sidebar.height(),
                sidebarWidth = $sidebar.width(),
                sidebarOffsetFromTop = $sidebar.offset().top,
                footerOffsetFromTop = $('footer').offset().top,
                $blog = $('.cblog, #blogsingle'),
                blogContainerWidth = $('.cblog #content, #blogsingle > .container').width();

            self.$window.on('scroll', function () {
                var requiredTopOffset = self.$body.hasClass('admin-bar') ? 32 : 0,
                    scrollTop = self.$document.scrollTop();
                
                if (sidebarOffsetFromTop + sidebarHeight > self.windowHeight) {
                    var requiredScrollAmount = sidebarHeight + sidebarOffsetFromTop - self.windowHeight;
                    if (scrollTop >= requiredScrollAmount) {
                        if ($blog.hasClass('right')) {
                            $sidebar.css('position', 'fixed');
                            
                            if (self.$body.hasClass('rtl')) {
                                $blog.find('.span9').css('float', 'left');
                            } else {
                                var rightPosition = (self.windowWidth - blogContainerWidth) / 2;
                                $sidebar.css('right', rightPosition + 'px');
                            }

                            $sidebar.css('bottom', '0px');
                            $sidebar.css('top', 'unset');
                            $sidebar.width(sidebarWidth);
                        } else {
                            $sidebar.css('position', 'fixed');
                            $sidebar.css('bottom', '0px');
                            $sidebar.css('top', 'unset');
                            if (self.$body.hasClass('rtl')) {
                                var leftPosition = (self.windowWidth - blogContainerWidth) / 2;
                                $sidebar.css('left', leftPosition + 'px');
                            } else {
                                $blog.find('.span9').css('float', 'right');
                            }
                            
                            $sidebar.width(sidebarWidth);
                        }
                    } else {
                        $sidebar.removeAttr('style');
                    }
                } else {
                    if ((sidebarOffsetFromTop - scrollTop) <= requiredTopOffset) {
                        if ($blog.hasClass('right')) {
                            var rightPosition = (self.windowWidth - blogContainerWidth) / 2;
                            $sidebar.css('position', 'fixed');
                            $sidebar.css('right', rightPosition + 'px');
                            $sidebar.css('top', '32px');
                            $sidebar.width(sidebarWidth);
                        } else {
                            $sidebar.css('position', 'fixed');
                            $blog.find('.span9').css('float', 'right');
                            $sidebar.width(sidebarWidth);
                        }
                    } else {
                        $sidebar.removeAttr('style');
                    }
                }

                if (scrollTop >= footerOffsetFromTop - self.windowHeight) {
                    if (sidebarHeight < $blog.find('.span9').height()) {
                        $sidebar.removeAttr('style');
                        var sidebarBottomGap = $blog.find('.span9').height() - sidebarHeight;
                        $sidebar.css('top', sidebarBottomGap + 'px');
                        $sidebar.width(sidebarWidth);
                    }                    
                }
            });
        }

    };

    kiteTheme = Object.assign( kiteTheme, blog );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.initBlog();
    }
    $(window).on( 'resize', function(){
        kiteTheme.blogResizeEvent();
    });

    $(document).on( 'ready', function(){
        kiteTheme.blogOnReadyEvent();
    });

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-blog.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
            kiteTheme.blogMasonry($scope);
            kiteTheme.blogLoadMore();
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-blog-headline.default', function ($scope) {
            kiteTheme.blogHeadLine();
            kiteTheme.blogLoadMore();
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-toggle-blog.default', function ($scope) {
            kiteTheme.toggleBlog();
            kiteTheme.blogLoadMore();
        });
    });
})(jQuery, window.kiteTheme);