/*-----------------------------------------------------------------------------------*/
/*  carousel
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var carousel = {
        carouselResizeEvent: function() {
            var self = this;
            if ($('.carousel').length > 0) {
                clearTimeout(self.resizeId);
                self.resizeId = setTimeout(function () {
                    self.updateCarousel();
                }, 300);
            }
        },
        /*-----------------------------------------------------------------------------------*/
        /*  carousel Shortcode
        /*-----------------------------------------------------------------------------------*/
        carousel: function ($container) {

            var self = this,
                $carousel;

            if ($container === undefined) {
                $carousel = $('.carousel');
            } else {
                $carousel = $container.hasClass('carousel') ? $container : $container.find('.carousel');
            }

            if ($carousel.length <= 0) {
                return;
            }

            // FullWidth Carousel remove col12 paddings
            $carousel.parents('.fullwidth').find('.vc_col-sm-12').css({
                'padding-right': '0px',
                'padding-left': '0px',
            });

            $carousel.each(function () {
                if ($(this).parents('.vc_tta-panel').length > 0) {
                    if ( !$(this).parents('.vc_tta-panel').hasClass('vc_active') ) {
                        return;
                    }
                }

                var $this = $(this),
                    $container = $this.find('.products'),
                    wcShortcodeWithBorder = $this.find('div.product').hasClass('with-border'),
                    setVisibleNumber = parseInt($this.find('.swiper').attr('data-visibleitems')),
                    visibleItems = 1;

                visibleItems = self.getVisibleItemNum($this, setVisibleNumber);

                var loopslideNum = visibleItems + 1,
                    gutter = 10,
                    slideClass = 'swiper-slide',
                    autoPlay = 0;
                if ( ($this.data('autoplay') == 'on') && ( self.windowWidth >= 1025 || $this.hasClass('kt-text-slider-container') ) ) {
                    autoPlay = 5000;
                }

                if ( $this.hasClass('wc-shortcode') ) { // wc-shortcode carousels

                    if ( $this.hasClass('no-gutter') || visibleItems == 1 ) {
                        gutter = 0;
                    }

                    slideClass = 'product';
                    autoPlay = 0;
                    if ( ( $this.data('autoplay') == 'on' && self.windowWidth >= 1025 ) || ( $this.data('responsive-autoplay') == 'on' && self.windowWidth < 1025 ) ) {
                        autoPlay = 3000;
                    }

                } else if ($this.hasClass('testimonials-style')) { // testimonials shortcode (testimonials-style)
                    gutter = 10;
                } else if ( $this.hasClass('instagram-carousel') ) {

                    slideClass = 'insta-media';
                    autoPlay = 0;
                    gutter = $this.hasClass('no-gutter') ? 0 : 10;

                } else { // image carousels
                    gutter = $this.hasClass('no-gutter') ? 0 : 10;
                }

                // disable loop for "gallery carousel" element - is buggy
                var loop = true;
                if ( $this.find('.swiper').parent().hasClass('gallery_carousel') ) {
                    loop = false;
                }
                if ( $this.hasClass('related') && $this.find('.swiper').data('exist_items') <= 3 ) {
                    loop = false;
                    $this.find('.arrows-button-next,.arrows-button-prev').css('display', 'none');
                }
                if ( autoPlay == 0 ) {
                    var autoPlay = false;
                } else {
                    var autoPlay = { delay: autoPlay };
                }
                if ( $this.find('.swiper').parents('#product-fullview-thumbs').length ) {
                    autoPlay = false;
                }

                var swiper = new Swiper($this.find('.swiper')[0], {
                    autoplay: autoPlay,
                    touchAngle: 45,
                    speed: 600,
                    longSwipesMs: 800,
                    loop: loop,
                    slidesPerView: visibleItems,
                    loopedSlides: loopslideNum,
                    autoplayDisableOnInteraction: false,
                    slideClass: slideClass,
                    spaceBetween: gutter,
                    roundLengths: false,
                    preloadImages: false,
                    watchSlidesProgress: true,
                    pagination: {
                        el: '.swiper-pagination',
                    },
                    scrollbar: {
                        el: '.swiper-scrollbar',
                    },
                    on: {
                        init: function () {
                            if ($container.length) { // wc-shortcode carousels
                                if ($container.parents('.elementor-element').length) {
                                    self.productsInfoOnClick();
                                    self.woocommerceVariationItemSelect();
                                }
                                self.showAnimation($container, 1); // secound Parametr determines this code Runs In Carousel mode
                            }
                            else {
                                self.showAnimation($this, 2);   // "2" used for animation of image Carousel
                            }

                            $this.find('.arrows-button-next,.arrows-button-prev').css('opacity', 1);
                        },
                        slideChangeTransitionEnd: function () {
                            if ($this.hasClass('wc-shortcode')) {
                                self.showAnimation($container, 1);
                            }
                            else if ($this.hasClass('instagram-carousel')) { // instagram carousel
                                self.showAnimation($this, 3);   // "3" used for animation of image  instagram carousel
                            }
                            else {
                                self.showAnimation($this, 2);   // 2 used for image Carousel animation
                            }
                        },
                        touchEnd: function () {
                            if ($this.hasClass('wc-shortcode')) {
                                self.showAnimation($container, 1);
                            }

                            if ($this.hasClass('instagram-carousel')) { // instagram carousel
                                self.showAnimation($this, 3);   // 3 used for image  instagram carousel  animation
                            } else {
                                self.showAnimation($this, 2);   // 2 used for image Carousel animation
                            }
                        },
                        transitionStart: function () {
                            if ($this.hasClass('wc-shortcode') && wcShortcodeWithBorder) {
                                $this.find('div.last-visible-item').removeClass("last-visible-item");
                                $this.find('.swiper-slide-visible').last().addClass("last-visible-item");
                            }
                        },
                    },

                });

                //load image of duplicate slides
                setTimeout(function () {
                    //Remove is-loading class and prepare it for images lazy loading
                    $this.find('.swiper-slide-duplicate .lazy-load-on-load').removeClass('is-loading');
                    self.lazyLoadOnLoad($this.find('.swiper-slide-duplicate'));
                }, 500);

                if (autoPlay) {
                    $this.find('.swiper,.arrows-button-next,.arrows-button-prev').hover(function () {
                        swiper.autoplay.stop();
                    }, function () {
                        swiper.autoplay.start();
                    });
                    if (self.windowWidth <= 767 && ! $this.hasClass('kt-text-slider-container') && $this.data('responsive-autoplay') != 'on' )
                        swiper.autoplay.stop();
                }
            });
            $carousel.find('.arrows-button-next, .kt-next-btn').bind('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                $(this).siblings('.swiper')[0].swiper.slideNext();
            });

            $carousel.find('.arrows-button-prev, .kt-prev-btn').bind('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                $(this).siblings('.swiper')[0].swiper.slidePrev();

            });

        },

        getVisibleItemNum: function ($container, visibleItems) {
            var self = this;

            if ( ( $container.hasClass('wc-shortcode')) || ($container.hasClass('testimonials-style') ) ) {
                var $productsWrapper = $container.find('.products');

                if ( self.windowWidth <= 1140 && self.windowWidth >= 768 ) {
                    if ( $productsWrapper.length ) {
                        for (var i = 2; i < 5; i++) {
                            if ( $productsWrapper.hasClass( 'shop-tablet-'+i+'column' ) ) {
                                return i;
                            }
                        }
                    }
                }

                if ( self.windowWidth <= 1140 ) {
                    if ( visibleItems > 3 ) {
                        if ( $productsWrapper.length ) {
                            $productsWrapper.removeClass('shop-'+visibleItems+'column');
                            $productsWrapper.addClass('shop-3column');
                        }
                        visibleItems = 3; //3columns in vertical tablet devices
                    }
                    //2column in mobiles
                    if ( self.windowWidth <= 979 ) {
                        if ( visibleItems >= 2 ) {
                            if ( $productsWrapper.length ) {
                                $productsWrapper.removeClass('shop-3column');
                                $productsWrapper.addClass('shop-2column');
                            }
                            visibleItems = 2;//2columns in mobile devices
                        }

                        if ( self.windowWidth <= 480 ) {
                            if ( $container.hasClass('phone-column-2') ) {
                                visibleItems = 2;
                            } else {
                                if ( $productsWrapper.length ) {
                                    $productsWrapper.removeClass('shop-2column');
                                    $productsWrapper.addClass('shop-1column');
                                }
                                visibleItems = 1;//1column in mobile devices
                            }
                        }
                    }
                } else {
                    if ($productsWrapper.length && !$productsWrapper.hasClass('shop-'+visibleItems+'column')) {
                        for (var i = 1; i < 6; i++) {
                            $productsWrapper.removeClass( 'shop-'+i+'column' );
                        }
                        $productsWrapper.addClass( 'shop-'+visibleItems+'column' );
                    }
                }
            } else {
                if ( self.windowWidth <= 979 ) {
                    if ( visibleItems > 3 ) {
                        visibleItems = 3; //3columns in vertical tablet devices
                    }
                    //2column in mobiles
                    if ( self.windowWidth <= 767 ) {
                        if ( visibleItems >= 2 ) {
                            visibleItems = 2;//2columns in mobile devices
                        }

                        if ( self.windowWidth <= 480 ) {
                            if ( $container.hasClass('instagram-carousel') || $container.hasClass('phone-column-2') ) {
                                visibleItems = 2;//1column in mobile devices
                            } else {
                                visibleItems = 1;//1column in mobile devices
                            }
                        }
                    }
                }

            }

            return visibleItems;
        },

        updateCarousel: function (container = $(document)) {
            var self = this,
                $carousel = container.find('.carousel');

            if ( ! $carousel.length ) {
                return;
            }
            $carousel.each(function () {

                var $this = $(this),
                    $swiperContainer = $this.find('.swiper');

                if ($swiperContainer[0].swiper != undefined) {
                    var visibleItems = self.getVisibleItemNum($this, $swiperContainer.attr('data-visibleitems'));

                    $swiperContainer[0].swiper.params.slidesPerView = visibleItems;
                    $swiperContainer[0].swiper.params.loopedSlides = visibleItems + 1;

                    if ($this.hasClass('wc-shortcode')) { // wc-shortcode carousels
                        var gutter = ($this.hasClass('no-gutter') || visibleItems == 1) ? 0 : 20;

                        $swiperContainer[0].swiper.update(true);
                        self.showAnimation($this.find('.products'), 1); // secound Parametr determine this code Run In Carousel
                    }

                    else if (($this.hasClass('testimonials-style')) || ($this.hasClass('instagram-carousel'))) { // testimonials-shortcode(testimonials-style) and instagram-carousel
                        $swiperContainer[0].swiper.update(true);

                    } else {
                        self.showAnimation($this, 2);   // 2 used for image Carousel animation
                        $swiperContainer[0].swiper.update(true);
                    }

                } else {
                    self.carousel($this);
                }
            });
        },

    };

    kiteTheme = Object.assign( kiteTheme, carousel );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($){
    if ( window.kiteTheme ) {
        kiteTheme.carousel();
    }

    $(window).on( 'resize', function(){
        kiteTheme.carouselResizeEvent();
    });

    $(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/kite-testimonial.default', function ($scope) {
            kiteTheme.updateCarousel($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-image-carousel.default', function ($scope) {
            kiteTheme.updateCarousel($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-gallery-carousel.default', function ($scope) {
            kiteTheme.updateCarousel($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-woocommerce-products.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
            kiteTheme.lazyLoadOnHover($scope);
            kiteTheme.updateCarousel($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-woocommerce-products-by-attribute.default', function ($scope) {
            kiteTheme.updateCarousel($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-woocommerce-hand-picked-products.default', function ($scope) {
            kiteTheme.updateCarousel($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-ajax-woocommerce-products.default', function ($scope) {
            kiteTheme.updateCarousel($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-product-categories.default', function ($scope) {
            kiteTheme.updateCarousel($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-instagram-feed.default', function ($scope) {
            kiteTheme.updateCarousel($scope);
        });
    });
})(jQuery);