/*-----------------------------------------------------------------------------------*/
/*  contactForm
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var contactForm = {
        contactForm: function () {
            if ( ! $('form.wpcf7-form').parents('div.wpcf7').length ) return;
            $('form.wpcf7-form').parents('div.wpcf7').each(function (index, el) {
                if ( $(this).parent().width() < 325 ) {
                    $(this).addClass('responsive');
                } else {
                    $(this).removeClass('responsive');
                }
            });
            $('form.wpcf7-form.two_column').parents('div.wpcf7').each(function (index, el) {
                if ( $(this).parent().width() < 510 ) {
                    $(this).addClass('responsive');
                } else {
                    $(this).removeClass('responsive');
                }
            });
            $('form.wpcf7-form.two_column p input[type!="submit"]').parents('p').addClass('two_column');
            $('form.wpcf7-form.two_column p textarea').parents('p').addClass('textarea');
        },
    };

    kiteTheme = Object.assign( kiteTheme, contactForm );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.contactForm();
    }
    $(window).on( 'resize', function(){
        kiteTheme.contactForm();
    });

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-contact-form-7.default', function ($scope) {
            kiteTheme.contactForm();
        });
    });
})(jQuery, window.kiteTheme);