/*-----------------------------------------------------------------------------------*/
/*  countDown
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var countDown = {

        countdown: function () {
            if( ! $(".countdown-timer").length ) {
				return;
			}

            $(".countdown-timer").each(function () {
                var $this = $(this);
                if ( $this.hasClass('initiated') ) {
					return;
				}

                $this.addClass('initiated');

                var updateCountDown = function () {
                    var date = Date.parse($this.data("end")) / 1000,
                        now = Math.floor($.now() / 1000),
                        $day = $this.find(".days"),
                        $hours = $this.find(".hours"),
                        $min = $this.find(".minutes"),
                        $second = $this.find(".seconds"),
                        dayDistance = date - now;

                    if (dayDistance > 0) {
                        var day = Math.floor(dayDistance / 86400);
                        dayDistance -= 60 * day * 60 * 24;
                        var hours = Math.floor(dayDistance / 3600);
                        dayDistance -= 60 * hours * 60;
                        var min = Math.floor(dayDistance / 60);
                        dayDistance -= 60 * min,
                            10 > day && (day = "0" + day),
                            10 > hours && (hours = "0" + hours),
                            10 > min && (min = "0" + min),
                            10 > dayDistance && (dayDistance = "0" + dayDistance),
                            1 > $day.length || "00" == day ? $day.parent().hide() : $day.text(day),
                            $hours.text(hours + "	" + ":"),
                            $min.text(min + "	" + ":"),
                            //$min.text(min),
                            $second.text(dayDistance)
                    } else {
                        $this.css( 'display', 'none' );
                    }
                };
                setInterval(updateCountDown, 1000),
                    updateCountDown()
            })
        },

    };

    kiteTheme = Object.assign( kiteTheme, countDown );
} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( kiteTheme ) {
        kiteTheme.countdown();
    }

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-count-down.default', function ($scope) {
            kiteTheme.countdown();
        });
    });

    $(document).on('kite_ajax_products_loaded', function () {
        kiteTheme.countdown();
    });
})(jQuery, window.kiteTheme);