/*-----------------------------------------------------------------------------------*/
/*  counter
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var counter = {
        /*-----------------------------------------------------------------------------------*/
        /*  Counter Box
        /*-----------------------------------------------------------------------------------*/

        counterBox: function () { // counterBox run in document ready and call after Ajax
            var self = this;

            var $counterBoxContainers = $('.counterbox:not(.shortcodeanimation), .counterbox.shortcodeanimation.no-responsive-animation');
            if (!$counterBoxContainers.length) return;
            self.counterBoxAnimate($counterBoxContainers);
        },

        /* Counter Box With Animation */
        counterBoxAnimate: function ($element) { // call in appear function - run when element come to screen view

            $element.each(function () {
                var countNmber = $(this).attr('data-countNmber');
                $(this).find('.counterboxnumber').countTo({
                    from: 0,
                    to: countNmber,
                    speed: 2000,
                    refreshInterval: 10,
                });
            });
        },

    };

    kiteTheme = Object.assign( kiteTheme, counter );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.counterBox();
    }

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-counter-box.default', function ($scope) {
            kiteTheme.counterBox();
        });
    });
})(jQuery, window.kiteTheme);