/*-----------------------------------------------------------------------------------*/
/*  customTitle
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var customTitle = {
        customTitle: function () {

            var self = this;

            if ( $('.custom-title').length <= 0 || self.msie > 0 || !!self.msie11 || self.windowWidth <= 1140 || self.isTouchDevice ) {
                return;
            }

            var $titles = $('.custom-title');
            self.windowHeight = self.$window.height();
            var scrollPosition = 0;

            var parallaxHandler = function () {
                $titles.each(function () {
                    var $el = $(this),
                        elementTop = $el.data('offsetTop'),
                        factorMult = 0;

                    var offsetDiff = elementTop - scrollPosition;
                    factorMult = 1 - ((((self.windowHeight / 3) - offsetDiff) / (self.windowHeight / 3)) * 1.1);

                    var $parallaxedShape = $(this).find('.shape-container');
                    if ($parallaxedShape.length) {

                        //shape
                        factorMult = (elementTop - scrollPosition - (self.windowHeight / 4)) * 0.15;

                        // Parallax For Custom Shape  in top of [ $self.windowHeight / 4 ]  size
                        if (elementTop < (self.windowHeight / 4)) {

                            factorMult = factorMult + (self.windowHeight / 16);
                            $parallaxedShape.css({ transform: 'translate3d(0,' + factorMult + 'px,0)' });

                        } else {

                            // Parallax For Custom Shape
                            if (factorMult > -10) {
                                $parallaxedShape.css({ transform: 'translate3d(0,' + factorMult + 'px,0)' });
                            }

                        }
                    }
                });
            }

            var parallaxInit = function () {
                $titles.each(function () {
                    var $el = $(this);
                    if ($el.find('.title >span').length) {
                        $el.data('offsetTop', $el.find('.title >span').offset().top);
                    }
                });
            }

            var requestTick = function () {
                parallaxInit();
                scrollPosition = self.$window.scrollTop();
                window.requestAnimationFrame(parallaxHandler);
            }

            var resizeHandler = function () {
                self.windowHeight = self.$window.height();
                parallaxInit();
            }

            parallaxInit();
            parallaxHandler();

            self.$window.on('scroll', requestTick).resize(resizeHandler);

            self.$window.one('djaxClick', function () {
                self.$window.unbind('scroll', requestTick).unbind('resize', resizeHandler);
            });
        },
    };

    kiteTheme = Object.assign( kiteTheme, customTitle );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.customTitle();
    }
})(jQuery, window.kiteTheme);