/*-----------------------------------------------------------------------------------*/
/*  imageHotSpots
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var imageHotSpots = {

        imageHotSpots: function() {
            $('.kt-hotspot').each(function(){
                var $this = $(this),
                    $container = $this.parents('.kt-hotspots-container'),
                    containerWidth = $container.width(),
                    containerHeight = $container.height(),
                    hotspotWidth = $this.width(),
                    hotspotHeight = $this.height(),
                    $hotspotDetails = $this.find( '.kt-hotspot-details');

                var hotspotLeftOffset = $this.data('left'),
                    hotspotTopOffset = $this.data('top');

                hotspotLeftOffset = hotspotLeftOffset * containerWidth / 100;
                hotspotTopOffset = hotspotTopOffset * containerHeight / 100;

                var right = ( containerWidth - hotspotLeftOffset < 157 ) ? true : false,
                    left = ( hotspotLeftOffset < 157 ) ? true : false,
                    bottom = ( containerHeight - ( hotspotTopOffset + $hotspotDetails.height() ) < 75 ) ? true : false;

                var xPos = 'calc(-50% + ' + ( hotspotWidth / 2 ) + 'px)',
                    yPos = '5px';

                if (document.body.classList.contains('rtl')) {
                    xPos = right ? xPos : '100%';
                    xPos = left ? xPos : '0';
                } else {
                    xPos = right ? '-100%' : xPos;
                    xPos = left ? '0' : xPos;
                }

                yPos = bottom ? 'calc(-100% - ' + ( hotspotHeight + 5 ) + 'px)' : yPos;

                $hotspotDetails.attr( 'style', 'transform:translate3D(' + xPos + ', ' + yPos + ', 0 )');
            });
        },

    };

    kiteTheme = Object.assign( kiteTheme, imageHotSpots );
} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( kiteTheme ) {
        kiteTheme.imageHotSpots();
    }
})(jQuery, window.kiteTheme);