/*-----------------------------------------------------------------------------------*/
/*  instagram
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var instagram = {

        instagramInit: function() {
            this.instagramAjaxRequest();
            this.instagramAnimation();
            this.instagramEqualHeightWidth();
        },

        instagramAjaxRequest: function( container = $(document)) {
            var self = this;
            if (container.find('.insta-ajax').length) {
                let elements = [] ;
                container.find('.insta-ajax').each(function(){
                    elements.push($(this).attr('id'));
                });
                let i = 0;
                var instaAjaxFunction = function(i) {
                    if (i < elements.length ) {
                        let instaUrl = "https://instagram.com/";
                        let el = container.find('#'+elements[i]);
                        let instaData = el.data('insta');

                        if ( typeof instaData == 'undefined' || !instaData ) return;

                        if (instaData.hashtag.length) {
                            instaUrl += "explore/tags/" + instaData.hashtag;
                        } else if (instaData.username) {
                            instaUrl += instaData.username.trim();
                        } else {
                            return;
                        }

                        $.ajax({
                            url: instaUrl
                        }).done(function(response){
                            let ajaxurl = kite_theme_vars.ajax_url;
                            $.ajax({
                                url: ajaxurl,
                                method:'post',
                                data: {
                                    action:"kite-instagram-generate-dom",
                                    insta_data: instaData,
                                    insta_html: response
                                }
                            }).done( function( newResponse ) {
                                if ( instaData.carousel.length ) {
                                    el.find('.swiper-wrapper').html(newResponse);
                                    self.carousel(container);
                                    self.instagramAnimation();
                                    self.instagramEqualHeightWidth();
                                } else {
                                    el.find('.instagramfeed').html(newResponse);
                                    self.instagramAnimation();
                                    self.instagramEqualHeightWidth();
                                }
                                ++i;
                                instaAjaxFunction(i);
                            }).fail(function(error){
                                console.log('2.failed to load instagram data');
                                ++i;
                                instaAjaxFunction(i);
                            });
                        }).fail(function(){
                            console.log('1.failed to load instagram data');
                            ++i;
                            instaAjaxFunction(i);
                        });
                    }
                };
                instaAjaxFunction(i);
            }
        },
        instagramEqualHeightWidth: function () {
            if ($('.instagram-feed').length) {
                if ($('.instagram-feed').data('equal-height-width')) {
                    $('.instagram-feed').find('.instagram-img img').each(function (index, el) {
                        $(this).attr('style', 'height:' + $(this).width() + 'px !important;object-fit:cover;');
                    });
                }
            }
        },

        /* Instagram animation  */
        instagramAnimation: function () {
            var self = this;

            if ( ! $('body .instagram-feed').length ) { 
                return;
            }

            var instagramAnimationBase = function ($container) {
                var $selector,
                    counter = 0;

                if ($container.find('.instagramfeed').hasClass('instagram-carousel')) { // Selector for carousel mode
                    $selector = '.swiper-slide-visible:not(.isanimated)';
                } else { // selector for grid mode
                    $selector = '.instagramfeed .instagram-img:not(.isanimated)';
                }
                $container.find($selector).waypoint({
                    handler: function () {
                        var $this = $(this.element);

                        $this.each(function () {
                            var $item = $(this);
                            setTimeout(function () {

                                //Ask self.animationDelay() for the amount of delay per each item
                                var delay = self.animationDelay(counter, $item);

                                // Select all items
                                var $allItems = $container.find('.instagramfeed .instagram-img');

                                //Select one of available animations
                                self.setAnimationForItems($container, $allItems, $item, delay);

                                //Reset counter per each iteration.
                                counter = counter + 1;

                            }, 50);
                            counter = 0;
                        });
                        this.destroy();
                    },
                    offset: '95%'
                });
            }

            $('body .instagram-feed').each(function () {

                var $container = $(this);

                if ((self.isMobile() || self.isTablet()) && $container.hasClass('no-responsive-animation')) {
                    return true;
                }

                instagramAnimationBase($container);

            });

            //Remove class of animation because there is no need for animation in toggle-sidebar
            $('body .instagram-feed').removeClass('fadein fadeinfrombottom fadeinfromtop fadeinfromright fadeinfromleft zoomin');
        },

    };

    kiteTheme = Object.assign( kiteTheme, instagram );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.instagramInit();
    }
    $(window).on( 'resize', function(){
        kiteTheme.instagramEqualHeightWidth();
    });

    $(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/kite-instagram-feed.default', function ($scope) {
            kiteTheme.instagramAjaxRequest($scope);

            // kiteTheme.instagramEqualHeightWidth();
            kiteTheme.instagramAnimation();
        });
    });
})(jQuery, window.kiteTheme);