/*-----------------------------------------------------------------------------------*/
/*  lookBookFullScreen
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var lookBookFullScreen = {
        /*-----------------------------------------------------------------------------------*/
        /*  Lookbook FullScreen Image Reveal
        /*-----------------------------------------------------------------------------------*/
        lookBookFullScreen: function () {
            if ( !$('.imagefullscreenreveal').length ) {
                return;
            }
            if ( $(window).width() < 1140 ) {
                $('.imagefullscreenreveal .swiper').css('display', 'none');
                return;
            }
            $('.imagefullscreenreveal').each(function () {
                var $this = $(this);
                var $swiperContainer = $(this).find('.swiper');
                var lookBookFullsSreenSwiper = new Swiper($swiperContainer[0], {
                    watchSlidesProgress: true,
                    autoplay: {
                        delay: 400,
                    },
                    speed: 200,
                    loop: true,
                    effect: 'fade',
                });
                lookBookFullsSreenSwiper.autoplay.stop();
                $this.find(' > span').hover(function () {
                    /* Stuff to do when the mouse enters the element */
                    lookBookFullsSreenSwiper.autoplay.start();
                    $(this).parents('.imagefullscreenreveal').addClass('hover');
                }, function () {
                    /* Stuff to do when the mouse leaves the element */
                    lookBookFullsSreenSwiper.autoplay.stop();
                    $(this).parents('.imagefullscreenreveal').removeClass('hover');
                });
            });
        },

    };

    kiteTheme = Object.assign( kiteTheme, lookBookFullScreen );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.lookBookFullScreen();
    }
})(jQuery, window.kiteTheme);