/*-----------------------------------------------------------------------------------*/
/*  newsletter
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var newsletter = {
        /*-----------------------------------------------------------------------------------*/
        /*  Easy Pie Chart Function
        /*-----------------------------------------------------------------------------------*/

        newsletter: function () {
            if ( ! $('.mailpoet_form.mailpoet_form_widget, .widget_mc4wp_form_widget, .mc4wp-form').length ) return;
            $('.mailpoet_form.mailpoet_form_widget, .widget_mc4wp_form_widget').each(function (index, el) {
                if ($(this).parents('.kt-newsletter').length == 0) {
                    $(this).wrap('<div class="kt-newsletter boxed style1"></div>');
                }
            });

            $('.widget_wysija_cont').each(function (index, el) {
                if ($(this).parents('.kt-newsletter').length == 0) {
                    $(this).wrap('<div class="kt-newsletter boxed style1"></div>');
                }
            });

            $('.kt-newsletter').each(function (index, el) {
                if ($(this).parent().width() < 325 || $(this).find('input:not(:hidden)').length > 2)
                    $(this).addClass('responsive');
                else
                    $(this).removeClass('responsive');


            });

            $('.mailpoet_paragraph').each(function (index, el) {
                if ($(this).find('input.mailpoet_submit').length && $(this).find('.mailpoet_submit_loading').length == 0)
                    $(this).append('<span class="mailpoet_submit_loading"></span>');
            });

            $('.kt-newsletter .mailpoet_text,.kt-newsletter .wysija-paragraph .wysija-input').hover(function () {
                $(this).parents('.kt-newsletter').addClass('hover');
            }, function () {
                $(this).parents('.kt-newsletter').removeClass('hover');
            });
        },
    };

    kiteTheme = Object.assign( kiteTheme, newsletter );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.newsletter();
    }
    $(window).on( 'resize', function(){
        kiteTheme.newsletter();
    });

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-newsletter.default', function ($scope) {
            kiteTheme.newsletter();
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-newsletter-mailchimp.default', function ($scope) {
            kiteTheme.newsletter();
        });
    });
})(jQuery, window.kiteTheme);