/*-----------------------------------------------------------------------------------*/
/*  pieChart
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var pieChart = {
        /*-----------------------------------------------------------------------------------*/
        /*  Easy Pie Chart Function
        /*-----------------------------------------------------------------------------------*/

        pieChart: function () { // pieChart run in document ready and call after Ajax

            var self = this;

            var $pieChartBox = $('.piechartbox:not(.shortcodeanimation), .piechartbox.shortcodeanimation.no-responsive-animation');

            if (!$pieChartBox.length) return;

            self.pieChartAnimate($pieChartBox);
        },

        /* PieChart With Animation*/
        pieChartAnimate: function ($element) { // call when its appeared on viewport
            var self = this;

            var animation = false;
            if ( self.windowWidth > 1140 ) {
                animation = { duration: 2500, enabled: true };
            }

            $element.each(function () {
                var $this = $(this);
                var $dot = $this.find('.dot-container');
                $this.find('.easypiechart').easyPieChart({
                    scaleColor: false,
                    barColor: $this.attr('data-barColor'),
                    lineWidth: 2,
                    trackColor: 'rgba(0,0,0,0)',
                    lineCap: 'round',
                    easing: 'easeOutQuint',
                    animate: animation,
                    size: 145,
                    onStep: function (from, to, percent) {
                        $dot.css({ transform: 'rotate(' + (percent * 3.6 + 6) + 'deg)' });
                    }
                });

                if ( animation == false ) {
                    var percent = $this.find('.easypiechart').data('percent');
                    $dot.css({ transform: 'rotate(' + (percent * 3.6 + 6) + 'deg)' });
                }
            });
        },
    };

    kiteTheme = Object.assign(kiteTheme, pieChart);

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.pieChart();
    }

    $(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/kite-piechart.default', function ($scope) {
            kiteTheme.pieChart();
        });
    });
})(jQuery, window.kiteTheme);