/*-----------------------------------------------------------------------------------*/
/*  ProgressBar
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var progressBar = {
        /*-----------------------------------------------------------------------------------*/
        /*  progress bar with animation Function
        /*-----------------------------------------------------------------------------------*/

        progressBar: function () { // progressBar run in document ready and call after Ajax

            var self = this;

            var $progressBar = $('.progress_bar:not(.shortcodeanimation), .progress_bar.shortcodeanimation.no-responsive-animation');

            if ( !$progressBar.length ) { 
				return;
			}

            self.progressBarAnimate($progressBar);
        },

        /* Animate progressBar */
        progressBarAnimate: function ($element) { // call when its appeared on viewport

            var self = this;

            $element.each(function () {
                var $this = $(this),
                    percentage = $this.find('.progressbar_percent').data('percentage');
                $this.find('.progress_percent_value').addClass("complete");
                $this.find('.progressbar_percent').css('width', percentage + '%');

            });
        },

    };

    kiteTheme = Object.assign(kiteTheme, progressBar);

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.progressBar();
    }

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-progressbar.default', function ($scope) {
            kiteTheme.progressBar();
        });
    });
})(jQuery, window.kiteTheme);