/*-----------------------------------------------------------------------------------*/
/*  tetaTextBox
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var tetaTextBox = {
        typeAnimation: function () {
            var self = this;
            
			if ( ! $('.textbox[data-animation-txt="true"]').length ) { 
				return;
			}

            $('.textbox[data-animation-txt="true"]').each(function () {
                var string = [$('#' + $(this).attr('id') + ' #txtbox').attr('data-text')],
                    loop = Boolean(parseInt($(this).attr('data-loop'))),
                    typeSpeed = parseInt($(this).attr('data-speed')),
                    backDelay = $('#' + $(this).attr('id') + ' #txtbox').attr('backDelay'),
                    backSpeed = parseInt($(this).attr('data-backspeed'));
                var typed = new Typed('#' + $(this).attr('id') + '  #txtbox', {
                    strings: string,
                    typeSpeed: typeSpeed,
                    backSpeed: backSpeed,
                    backDelay: backDelay,
                    fadeOut: true,
                    loop: loop
                });
            });
        },

    };

    kiteTheme = Object.assign( kiteTheme, tetaTextBox);

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.typeAnimation();
    }
})(jQuery, window.kiteTheme);